/* rxout.c - a simple program to interleave data for output
   to DEC RX50. Input on stdin; output should be RX50 device
   Note: assumes RQDX3 interleave; pads disk with nulls */

#include <unistd.h>
#include <stdio.h>
#include <sys/errno.h>

char out[409600];
char buf[512];
int l,n = 0;

int rxoffset(int secno);

int main (int argc, char * argv[]) {
memset(out,0,409600);
while (1) {
	memset(buf,0,512);
	l = read (STDIN_FILENO,buf,512);
	if (l == -1) {
		fprintf(stderr,"%s: read error (%s)\n",argv[0],strerror(errno));
		exit(-1);
	}
	if (l == 0) goto OUTPUT;
	memcpy(out+rxoffset(n),buf,512);
	++n;
}	

OUTPUT:
write(STDOUT_FILENO,out,409600);
}

int rxoffset(int secno) {
	int ps,ls,pt,lt;
	if (secno > 799) {
		fprintf(stderr,"Input too large for RX50. No output.\n");
		exit(-1);
	}
	lt = secno / 10;
	ls = secno % 10;
	pt = (lt==79)?0:(lt+1);
	if (ls<5) {
		ps = ls * 2;
	} else {
		ps = (ls * 2)%10 + 1;
	}

	ps = (ps+((lt*2)%10))%10; /* skew */

	return ((pt*10 + ps)*512);
}
