/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: prstat.c,v 1.10 1999/10/27 18:44:05 hbb Exp $
 */
# include <stdio.h>
# include <stdlib.h>
# include <time.h>
# include <sys/types.h>
# include <sys/stat.h>
# ifdef HAVE_SYSMACROS
#  include <sys/sysmacros.h>
# endif
# include "begemot.h"

# ifdef DECL_CFTIME
int cftime(char *s, char *format, const time_t *clock);
# endif

# ifdef TIMESPEC_HAS_TS
#  define TV_SEC	ts_sec
#  define TV_NSEC	ts_nsec
# else
#  define TV_SEC	tv_sec
#  define TV_NSEC	tv_nsec
# endif

# define CB(B,F) ((B & F) != 0)

/*
 * Print the contents of a stat buffer onto a file
 */
void
prstat(FILE *fp, const struct stat *sb)
{
# if defined(STAT_HAS_TIMESPEC)
	char tbuf[512];
	clock_t clock;
# elif defined(STAT_HAS_TIMEVAL)
	char tbuf[512];
# else
	char *tval;
# endif

	(void)fprintf(fp, "st_dev = (%lu,%lu)\n",
		(u_long)major(sb->st_dev),
		(u_long)minor(sb->st_dev));
	(void)fprintf(fp, "st_ino = %lu\n", (u_long)sb->st_ino);
	(void)fprintf(fp, "st_mode = ");
	switch(sb->st_mode & S_IFMT) {

	  case S_IFIFO:
			(void)putc('f', fp);
			break;

	  case S_IFCHR:
			(void)putc('c', fp);
			break;

	  case S_IFDIR:
			(void)putc('d', fp);
			break;

# ifdef IFNAM
	  case S_IFNAM:
			(void)putc('n', fp);
			break;
# endif

	  case S_IFBLK:
			(void)putc('b', fp);
			break;

	  case S_IFREG:
			(void)putc('-', fp);
			break;

	  case S_IFLNK:
			(void)putc('l', fp);
			break;

	  case S_IFSOCK:
			(void)putc('s', fp);
			break;

# ifdef IFDOOR
	  case S_IFDOOR:
			(void)putc('o', fp);
			break;
# endif

	  default:
			(void)fprintf(fp, "type=0x%lx", (u_long)((sb->st_mode & S_IFMT) >> 12));
			break;
	}
	(void)putc(' ', fp);

	if(sb->st_mode & S_ISUID)
		(void)fprintf(fp, "suid ");
	if(sb->st_mode & S_ISGID)
		(void)fprintf(fp, "sgid ");
	if(sb->st_mode & S_ISVTX)
		(void)fprintf(fp, "vtx ");

	(void)fprintf(fp, "%c%c%c%c%c%c%c%c%c",
		"-r"[CB(S_IRUSR, sb->st_mode)],
		"-w"[CB(S_IWUSR, sb->st_mode)],
		"-x"[CB(S_IXUSR, sb->st_mode)],
		"-r"[CB(S_IRGRP, sb->st_mode)],
		"-w"[CB(S_IWGRP, sb->st_mode)],
		"-x"[CB(S_IXGRP, sb->st_mode)],
		"-r"[CB(S_IROTH, sb->st_mode)],
		"-w"[CB(S_IWOTH, sb->st_mode)],
		"-x"[CB(S_IXOTH, sb->st_mode)]);
	(void)putc('\n', fp);
	(void)fprintf(fp, "st_nlink = %lu\n", (u_long)sb->st_nlink);
	(void)fprintf(fp, "st_uid = %ld\n", (long)sb->st_uid);
	(void)fprintf(fp, "st_gid = %ld\n", (long)sb->st_gid);
	(void)fprintf(fp, "st_rdev = (%lu,%lu)\n",
		(u_long)major(sb->st_rdev), 
		(u_long)minor(sb->st_rdev));
	(void)fprintf(fp, "st_size = %ld\n", (long)sb->st_size);

# ifdef STAT_HAS_TIMESPEC
	clock = sb->st_atimespec.TV_SEC;
	(void)strftime(tbuf, sizeof(tbuf), "%Y %T", gmtime(&clock));
	(void)sprintf(tbuf + strlen(tbuf), ".%09lu", sb->st_atimespec.TV_NSEC);
	(void)fprintf(fp, "st_atime = %s\n", tbuf);

	clock = sb->st_mtimespec.TV_SEC;
	(void)strftime(tbuf, sizeof(tbuf), "%Y %T", gmtime(&clock));
	(void)sprintf(tbuf + strlen(tbuf), ".%09lu", sb->st_mtimespec.TV_NSEC);
	(void)fprintf(fp, "st_mtime = %s\n", tbuf);

	clock = sb->st_ctimespec.TV_SEC;
	(void)strftime(tbuf, sizeof(tbuf), "%Y %T", gmtime(&clock));
	(void)sprintf(tbuf + strlen(tbuf), ".%09lu", sb->st_ctimespec.TV_NSEC);
	(void)fprintf(fp, "st_ctime = %s\n", tbuf);
# elif defined(STAT_HAS_TIMEVAL)
	(void)cftime(tbuf, (char *)NULL, (const time_t *)&sb->st_atim.tv_sec);
	(void)fprintf(fp, "st_atime = %s\n", tbuf);
	(void)cftime(tbuf, (char *)NULL, (const time_t *)&sb->st_mtim.tv_sec);
	(void)fprintf(fp, "st_mtime = %s\n", tbuf);
	(void)cftime(tbuf, (char *)NULL, (const time_t *)&sb->st_ctim.tv_sec);
	(void)fprintf(fp, "st_ctime = %s\n", tbuf);
# else
	tval = asctime(gmtime(&sb->st_atime));
	(void)fprintf(fp, "st_atime = %s", tval);
	tval = asctime(gmtime(&sb->st_mtime));
	(void)fprintf(fp, "st_mtime = %s", tval);
	tval = asctime(gmtime(&sb->st_ctime));
	(void)fprintf(fp, "st_ctime = %s", tval);
# endif
	(void)fprintf(fp, "st_blksize = %ld\n", (long)sb->st_blksize);
	(void)fprintf(fp, "st_blocks = %"QUADFMT"d\n", (unsigned long long)sb->st_blocks);
# ifdef STAT_HAS_FSTYPE
	(void)fprintf(fp, "st_fstype = %.*s\n", (int)sizeof(sb->st_fstype), sb->st_fstype);
# endif
}

# ifdef TEST
# include <string.h>
# include <errno.h>
int
main(int argc, char *argv[])
{
	struct stat statb;

	if(fstat(0, &statb))
		panic("cannot stat stdin: %s", strerror(errno));
	prstat(stdout, &statb);
	return 0;
}
# endif
