'\"
'\" Copyright (c)1997 Begemot Computer Associates. All rights reserved.
'\" See the file COPYRIGHT for details of redistribution and use.
'\"
'\" $Id: verb.man,v 1.4 1998/03/26 15:11:17 robf Exp $
'\"
.TH verbose l "17 Mar 1998" "BEGEMOT" "BEGEMOT Library"
.SH NAME
verb \- print verbose messages
.SH SYNOPSIS
.nf
.LP
.B "# include <begemot.h>"
.LP
.BI "void verb(u_int " opt ", u_int " level ", const char *" fmt ", ...);"
.LP
.BI "void verbc(u_int " opt ", u_int " level ", const char *" fmt ", ...);"
.LP
.BI "void verbn(u_int " opt ", u_int " level ", const char *" fmt ", ...);"
.LP
.BI "void vverb(u_int " opt ", u_int " level ", const char *" fmt ", va_list "ap ");"
.LP
.BI "void vverbc(u_int " opt ", u_int " level ", const char *" fmt ", va_list "ap ");"
.LP
.BI "void vverbn(u_int " opt ", u_int " level ", const char *" fmt ", va_list "ap ");"
.LP
.BI "u_int verb_level(u_int " opt ");"
.LP
.BI "void verb_option(char * " optarg ");"
.LP
.BI "void verb_update(FILE * " fp ");"
.LP
.BI "void verb_opts(verb_option_t * " opts ");"
.fi
.SH DESCRIPTION
The
.B verb
family of functions may be used to print debug and other information from
programs in a uniform way. They can be used in simple programs, as well as
in large programs.
.P
The functions employ the concept of so-called verbose facilities and levels.
A facility (or option) usually represents one sub-system or sub-function of
a given program, whereas the verbose level controls the amount of information
to be printed for each facility. In simple programs one facility (the default one)
may be sufficient, whereas in complex programs it is often desirable to enable/disable
debugging printout in different parts of the program independent of each other.
.P
Facilities are defined by providing a definition of an array of
.BR verb_option_t 's.
This array consists of structures, the first field of which is an ASCII
string for the facility name. So the definition
.RS
.nf

verb_option_t verbopts[] = {
	{ "lexer" },
	{ "parser" },
	{ "gen" },
	{ NULL }
};

.fi
.RE
could be used to define the facilities for a compiler. The array must be terminated
with a NULL entry. If your program consists of more than one source file,
you may also want to provide symbolic definitions of the facilities in a 
header file (for only one source file, you don't need an extra header):
.RS
.nf

enum {
	V_LEXER,
	V_PARSER,
	V_GEN
};

.fi
.RE
.P
The option array is made known to the library by calling
.IR verb_opts .
If
.B verb_opts
is not called, the default definition from the library, containing the
facility "verbose" is used, which is sufficient for simple programs. A symbolic
definition of
.B V_DFTL
is provided in this case for the facility.
.P
The verbose level is usually set through command line arguments. You should
aquire the habit of using the same option for verbosity in all your programs.
A convention could be to use the 'v' or 'd'. The argument of this
option should be passed to
.BR verb_option .
The argument may take one of two forms: a facility name or facility=value,
where value is an integer. In the first case, the level of the verbose
facility is incremented by one, in the second case it is set to the given value.
.P
The facility "all" is always defined (and you can't override this definition)
to mean: change all facilities. So the string
.B all=2
will set all verbose levels to 2.
.P
For simple programs with only one verbose facility, you can use your option
without an argument and call
.B verb_option("all")
instead.
.P
Verbose levels can also be changed from a file by calling
.B verb_update
with an open file pointer. This is useful for long-running
complex programs, where you may want to change the verbose level
dynamically. In this case you could catch a signal, open a
file with a fixed name in the signal handler and pass the file
to verb_update.
.P
To actually print something the functions
.BR verb ", " verbn " or " verbc
or their va_list equivalents are used.
These functions differ in the appearance of the output:
.B verb
prints the standard prefix (see
.BR panic (l)),
the message and appends a newline.
.B verbn
does not append the newline and
.B verbc
only prints the message without prefix and newline. The output is sent
to the standard error file descriptor.
.P
To obtain the current verbose level for a given facility you may call
.BR verb_level .
.SH "ENVIRONMENT"
.TP
BEGEMOT_ERR
Overrides the prefix format mode.
.SH "SEE ALSO"
.BR panic (l),
.SH AUTHOR
Harti B. Brandt
