/* weird.c - Weird instructions. */


#include "defines.h"


void 
waiti()
{
    fprintf(stderr, "Apout - waiti instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}

void 
halt()
{
    fprintf(stderr, "Apout - halt instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void 
iot()
{
    fprintf(stderr, "Apout - iot instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void 
emt()
{
    fprintf(stderr, "Apout - emt instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void 
bpt()
{
    fprintf(stderr, "Apout - bpt instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void 
fis()
{
    fprintf(stderr, "Apout - unimplemented floating pt instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void 
illegal()
{
    fprintf(stderr, "Apout - illegal instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void 
not_impl()
{
    fprintf(stderr, "Apout - unimplemented instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void 
mark()
{
    fprintf(stderr, "Apout - mark instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void 
mfpd()
{
    fprintf(stderr, "Apout - mfpd instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void 
mtpd()
{
    fprintf(stderr, "Apout - mtpd instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}


void bne() {
    brx(CC_Z, 0);
}
void beq() {
    brx(0, CC_Z);
}
void bpl() {
    brx(CC_N, 0);
}
void bmi() {
    brx(0, CC_N);
}
void bhi() {
    brx(CC_C | CC_Z, 0);
}
void bvc() {
    brx(CC_V, 0);
}
void bvs() {
    brx(0, CC_V);
}
void bcc() {
    brx(CC_C, 0);
}
void bcs() {
    brx(0, CC_C);
}
void scc() {
    psw |= (ir & 017);
}
void ccc() {
    psw &= ~(ir & 017);
}


/* sob() - Subtract One and Branch Instruction. */

void 
sob()
{
    regs[SRC_REG] -= 1;
    if (regs[SRC_REG]) {
	regs[PC] -= (ir & 077) * 2;
    }
}


/* mfps() - Move from Processor Status Instruction. */

void 
mfps()
{
    uint8_t data;
    uint16_t word;

    data = LOW8(psw);

    CHGB_CC_N(data);
    CHGB_CC_Z(data);
    CLR_CC_V();

    if (DST_MODE) {
	storeb_dst(data);
    } else {
	if (data & SIGN_B) {
	    word = 0177400;
	} else {
	    word = 0;
	}
	word += data;
	store_dst(word);
    }
}


/* mtps() - Move to Processor Status Instruction. */

void 
mtps()
{
    uint8_t data;

    loadb_dst(&data);

    psw &= ~0017;
    psw += (data & 0017);
}


/* mfpi() - Move From Previous Instruction Space Instruction. */

void 
mfpi()
{
    uint16_t data;

    loadp_dst(&data);
    push(data);
}


/* mtpi() - To From Previous Instruction Space Instruction. */

void 
mtpi()
{
    uint16_t data;

    pop(&data);
    storep_dst(data);
}


/* ash() - Arithmetic Shift Instruction. */

void 
ash()
{
    uint16_t temp;
    uint16_t old;
    uint16_t sign;
    uint16_t shift;
    unsigned count;

    temp = regs[SRC_REG];

    load_dst(&shift);

    old = temp;

    if ((shift & 077) == 0) {	/* no shift */
	CHG_CC_N(temp);
	CHG_CC_Z(temp);
	CLR_CC_V();
	return;
    }
    if (shift & 040) {		/* right shift */
	count = 0100 - (shift & 077);
	sign = temp & SIGN;
	while (count--) {
	    if (temp & LSBIT) {
		SET_CC_C();
	    } else {
		CLR_CC_C();
	    }
	    temp >>= 1;
	    temp += sign;
	}
    } else {			/* left shift */
	count = shift & 037;
	while (count--) {
	    if (temp & SIGN) {
		SET_CC_C();
	    } else {
		CLR_CC_C();
	    }
	    temp <<= 1;
	}
    }

    CHG_CC_N(temp);
    CHG_CC_Z(temp);

    if ((old & SIGN) == (temp & SIGN)) {
	CLR_CC_V();
    } else {
	SET_CC_V();
    }

    regs[SRC_REG] = temp;
}


/* mul() and divide() - Multiply and Divide Instrcutions.  These work on
 * signed values, and we'll do the same.  This may not be portable. */


union s_u_word {
    uint16_t u_word;
    short s_word;
};

union s_u_long {
    unsigned long u_long;
    long s_long;
};


void 
mul()
{
    union s_u_word data1;
    union s_u_word data2;
    union s_u_long tmp;

    data1.u_word = regs[SRC_REG];
    load_dst(&data2.u_word);

    tmp.s_long = ((long) data1.s_word) * ((long) data2.s_word);

    regs[SRC_REG] = (tmp.u_long >> 16);
    regs[(SRC_REG) | 1] = (tmp.u_long & 0177777);

    CLR_CC_ALL();

    if (tmp.u_long == 0)
	SET_CC_Z();
    else
	CLR_CC_Z();

    if (tmp.u_long & 0x80000000)
	SET_CC_N();
    else
	CLR_CC_N();
}

void 
divide()
{
    union s_u_long tmp;
    union s_u_long eql;
    union s_u_word data2;

    tmp.u_long = regs[SRC_REG];
    tmp.u_long = tmp.u_long << 16;
    tmp.u_long += regs[(SRC_REG) | 1];

    load_dst(&data2.u_word);

    if (data2.u_word == 0) {
	SET_CC_C();
	SET_CC_V();
	return;
    } else {
	CLR_CC_C();
    }

    eql.s_long = tmp.s_long / data2.s_word;
    regs[SRC_REG] = eql.u_long & 0177777;

    if (eql.u_long == 0)
	SET_CC_Z();
    else
	CLR_CC_Z();

    if ((eql.s_long > 077777) || (eql.s_long < -0100000))
	SET_CC_V();
    else
	CLR_CC_V();

    if (eql.s_long < 0)
	SET_CC_N();
    else
	CLR_CC_N();

    eql.s_long = tmp.s_long % data2.s_word;
    regs[(SRC_REG) | 1] = eql.u_long & 0177777;
}


/* ashc() - Arithmetic Shift Combined Instruction. */

void 
ashc()
{
    unsigned long temp;
    unsigned long old;
    unsigned long sign;
    unsigned count;
    uint16_t shift;

    temp = regs[SRC_REG];
    temp <<= 16;
    temp += regs[(SRC_REG) | 1];

    old = temp;

    load_dst(&shift);

    if ((shift & 077) == 0) {	/* no shift */

	CLR_CC_V();

	if (temp & 0x80000000) {
	    SET_CC_N();
	} else {
	    CLR_CC_N();
	}

	if (temp) {
	    CLR_CC_Z();
	} else {
	    SET_CC_Z();
	}
	return;
    }
    if (shift & 040) {		/* right shift */
	count = 0100 - (shift & 077);
	sign = temp & 0x80000000;
	while (count--) {
	    if (temp & LSBIT) {
		SET_CC_C();
	    } else {
		CLR_CC_C();
	    }
	    temp >>= 1;
	    temp += sign;
	}
    } else {			/* left shift */
	count = shift & 037;
	while (count--) {
	    if (temp & 0x80000000) {
		SET_CC_C();
	    } else {
		CLR_CC_C();
	    }
	    temp <<= 1;
	}
    }

    if (temp & 0x80000000)
	SET_CC_N();
    else
	CLR_CC_N();

    if (temp)
	CLR_CC_Z();
    else
	SET_CC_Z();

    if ((old & 0x80000000) == (temp & 0x80000000)) {
	CLR_CC_V();
    } else {
	SET_CC_V();
    }

    regs[SRC_REG] = (temp >> 16);
    regs[(SRC_REG) | 1] = LOW16(temp);
}


/* xor() - Exclusive Or Instruction */

void 
xor()
{
    uint16_t data1;
    uint16_t data2;

    data2 = regs[SRC_REG];

    load_dst(&data1);

    data2 = data2 ^ data1;

    CHG_CC_N(data2);
    CHG_CC_Z(data2);
    CLR_CC_V();

    store_dst_2(data2);
}
