# You should be `root' to install things.

BIN = /bin
LIB = /lib
PREF =

STICKY = OLD

CC = cc
CFLAGS = -O
YACC = yacc
LEX = lex
LDFLAGS = -n -s

#------
# install: Create & install cc, c0, c1, c2, cpp, using $(PREF) as version ID.
#------
install: cc c0 c1 c2 cpp
	-mv $(BIN)/$(PREF)cc $(BIN)/$(STICKY)$(PREF)cc
	-mv $(LIB)/$(PREF)c0 $(LIB)/$(STICKY)$(PREF)c0
	-mv $(LIB)/$(PREF)c1 $(LIB)/$(STICKY)$(PREF)c1
	-mv $(LIB)/$(PREF)c2 $(LIB)/$(STICKY)$(PREF)c2
	-mv $(LIB)/$(PREF)cpp $(LIB)/$(STICKY)$(PREF)cpp
	mv cc $(BIN)/$(PREF)cc
	mv c0 $(LIB)/$(PREF)c0
	mv c1 $(LIB)/$(PREF)c1
	mv c2 $(LIB)/$(PREF)c2
	mv cpp $(LIB)/$(PREF)cpp
	-chown bin $(BIN)/$(PREF)cc $(LIB)/$(PREF)c0 $(LIB)/$(PREF)c1 \
			$(LIB)/$(PREF)c2 $(LIB)/$(PREF)cpp
	-chmod 1755 $(BIN)/$(PREF)cc $(LIB)/$(PREF)c0 $(LIB)/$(PREF)c1 \
			$(LIB)/$(PREF)c2 $(LIB)/$(PREF)cpp
	ls -l $(BIN)/$(PREF)cc $(LIB)/$(PREF)c0 $(LIB)/$(PREF)c1 \
			$(LIB)/$(PREF)c2 $(LIB)/$(PREF)cpp
	echo "Remove following STICKY files after next reboot:"
	-ls -l $(BIN)/$(STICKY)$(PREF)cc $(LIB)/$(STICKY)$(PREF)c0 \
			$(LIB)/$(STICKY)$(PREF)c1 \
			$(LIB)/$(STICKY)$(PREF)c2 $(LIB)/$(STICKY)$(PREF)cpp

cc: cc.c
	$(CC) $(CFLAGS) $(LDFLAGS) -o cc cc.c -lS


c0: c00.o c01.o c02.o c03.o c04.o c05.o
	$(CC) $(LDFLAGS) -o c0 c00.o c01.o c02.o c03.o c04.o c05.o

c00.o c01.o c02.o c03.o c04.o c05.o: c0.h


c1: c10.o c11.o c12.o c13.o table.o
	$(CC) $(LDFLAGS) -o c1 c10.o c11.o c12.o c13.o table.o

c10.o c11.o c12.o c13.o: c1.h

table.o: table.s cvopt
	= p $$p: ; cvopt <table.s >table.i
	as -o table.o table.i
	rm table.i

cvopt:	cvopt.c
	$(CC) -n -s -O -o cvopt cvopt.c


c2: c20.o c21.o
	$(CC) $(LDFLAGS) -o c2 c20.o c21.o

c20.o c21.0: c2.h


cpp: cpp.o cpy.o
	$(CC) $(CFLAGS) $(LDFLAGS) cpp.o cpy.o -ly -ll -lS -o cpp

cpp.o: cpp.c

cpy.o: lex.yy.c cpy.c

lex.yy.c: cpl.l
	$(LEX) cpl.l


clean:
	-rm cpp.o lex.yy.c cpy.c cpy.o y.tab.c
	-rm c0?.o c1?.o c2?.o
DFLAGS) -o c1 c10.o c11.o c12.o c13.o table.o

c10.o c11.o c12.o c13.o: c1.h

table.o: table.s cvopt
	= p $$p: ; cvopt <table.s >table.i
	as -o table.(        jmp
 GBjmp(I)
 jsrc,MA
 GBjsrc,#(I)
 GAjsrc,(I)
 clr
 clrf
 movC,I
 movof,I
 GBmovC(I),I
 GBmovof(I),I
 mov+,I+
mov,I
 GBmov+2(I),I+
mov(I),I
 movC',I
M'C''
 mov',I
M,A''
 GJmovC(J),I
M'C(J)
 GBmovC(I),-(sp)
M'C(I)
movCsp)+,I
 GJmov(J),I
M,#(J)
 GBmov(I),-(sp)
M,#(I)
movsp)+,I
 GAM1,A+
V
 GJmov+2(J),I+
mov(J),I
M1,#+2(J)
V(J)
 GBmov+2(I),-(sp)
mov(I),-(sp)
add1,#+2(I)
V(I)
movsp)+,I
movsp)+,I+
 GAMP
 GAM
M+
V
 KAmovC,A
 KAmovfo,A
 GBKAmovf,#(I)
 GBmovC,#(I)
movC(I),I
 GBKAmovfo,#(I)
 GBKImovC,#(I)
movC,I
 KAGJmovf,#(J)
 KAGJmovfo,#(J)
 GDKAmovC,*(sp)+
 GDKAmovfo,*(sp)+
 KAmov+,A+
mov,A
 KAGJmov+,2+#(J)
mov,#(J)
 GDKAmov,*(sp)
add2,(sp)
mov+,*(sp)+
 KAbicC,A'
bisC,A''
 KCGBbicC,#(I)
bisCsp),#(I)
movsp)+,I
 GA GAM'
 GAMD,I
 GAKJMD(J),I
 GAKIMP,I
 KDGAMD(sp)+,I
 KCGAMPsp)+,I
 GAM,I+
V
 GAKIM,I+
V
 GAM,I
M+,I+
V
 GAKIM+,I+
V
M,I
 KCGAMsp)+,I
Msp)+,I+
V
 GCKAxor,(sp)
movsp)+,I
 KCGAM,(sp)
movsp)+,I
M+,(sp)
movsp)+,I+
 GAasr
 GATM,I-
 GATKJM(J),I-
 GATKIM,I-
 KCGATMsp)+,I-
 M,A'
mov'',I
 movC',I
MP,I
movC,A''
 KBM(I),A'
mov'',I
 KAM,A'
mov'',I
 KBGJM(I),#(J)
mov(J),I
 movf',I
KIMP,I
movf,A''
 KCmovC',I
MPsp)+,I
movC,A''
 KCmovof',I
MPsp)+,I
movfo,A''
 KAGJM,#(J)
mov(J),I
 KCGBMsp)+,#(I)
mov(I),I
 GDKCmovC2(sp),I
MPsp)+,I
movC,*(sp)+
 KCGBmovC(I),I
MPsp)+,I
movC,#(I)
 KCGBmovof(I),J
MPsp)+,J
movfo,#(I)
movf,I
 movC',I
V-
MP,I-
movC-,A''
 KCmovC',I
V-
Msp)+,I-
movC-,A''
 KCGJmovC(J),I
V-
Msp)+,I-
movC-,#(J)
 GDKCmovC2(sp),I
V-
Msp)+,I-
movC-,*(sp)+
 movC',I
V-
M,I-
movC,A''
 KCmovC',I
V-
Msp)+,I-
movC,A''
 KCGJmovC(J),I
V-
Msp)+,I-
movC,#(J)
 GDKCmovC2(sp),I
V-
Msp)+,I-
mov,*(sp)+
 KCmovb',I
xor,(sp)
movsp)+,I
movb,A''
 GDmovC(sp),-(sp)
KAxor,(sp)
movCsp)+,I
movC,*(sp)+
 asrC'
movC'',I
 GBasrC(I)
movC(I),I
 movif,I
 GBmovif(I),I
 GAmovif,I
 GAmovfi,I
 GAsetl
movfi,-(sp)
movsp)+,I
movsp)+,I+
seti
 setl
movif,I
seti
 GBsetl
movif(I),I
s