	/* +tcode */
	char *tclr;	/* char sequence to clear tabs and return carriage */
	int tmaxtab;	/* maximum allowed position */
	int tdefmax;	/* default maximum, if +l omitted */
	int tmarg;	/* type of margin setting allowed */
} *tt	termtab;


int maxtab;	/* max tab value for repetitive spec, from +l, default 132 */
int margin;	/* margin (for TN and GSIS), from +m, default 10 */
int margflg;	/* >0 ==> +m option used, 0 ==> not */
char *terminal	omit;		/* type of terminal used */
char *tabspec	"-8";	/* default tab specification */
char fsuprs;	/* from +f, 0 ==> print tabs if --file, 1 ==> suppress */
char	quick;	/* from +q, 0 ==> clear tabs, 1 ==> omit clear */

int	ttyold[3];	/* tty table */
int	ttysave;	/* save for modes */
int	istty;		/* 1 ==> is actual tty */

static char SCCSID[] "@(#)tabs.c	2.7";
main(argc,argv)
int argc;
char *argv[];
{
	int tabvect[NTABS];	/* build tab list here */
	char *scan;	/* scan pointer to next char */
	int endup();
	signal(2,&endup);	/* catch interrupts */
	if (gtty(1, ttyold) == 0) {
		ttysave = ttyold[2];
		istty++;
	}
	tabvect[0] = 0;	/* mark as not yet filled in */
	while (--argc > 0) {
		scan = *++argv;
		if (*scan == '+')
			switch (*++scan) {
			case 'f':
				fsuprs = 1;
				break;
			case 'l':
				scan++;
				maxtab = getnum(&scan);
				break;
			case 'm':
				margflg++;
				scan++;
				if (*scan)
					margin = getnum(&scan);
				else
					margin = 10;
				break;
			case 'T':
			case 't':
				terminal = ++scan;
				break;
			case 'q':
				quick++;
				break;
			}
		else
			tabspec = scan;		/* save tab specification */
	}
	termadj();	/* check terminal type and alter parameters */
	scantab(tabspec,tabvect,0);
	if (!tabvect[0])
		repetab("8",tabvect);
	settabs(tabvect);
	endup();
	exit(0);
}

/*	scantab: scan 1 tabspec & return tab list for it */

scantab(scan,tabvect,level)
char *scan;
int tabvect[NTABS], level;
{
	register char c;
	if (*scan == '-')
		if ((c = *++scan) == '-')
			filetab(++scan,tabvect,level);
		else if (c >= '0' && c <= '9')
			repetab(scan,tabvect);
		else if (stdtab(scan,tabvect))
			abend("unknown tab code");
		else;
	else
		arbitab(scan,tabvect);
	return;
}

/*	repetab: scan and set repetitve tabs, 1+n, 1+2*n, etc */

repetab(scan,tabvect)
char *scan;
int tabvect[NTABS];
{
	register int incr, i, tabn;
	int limit;
	incr = getnum(&scan);
	tabn = 1;
	limit = (maxtab-1)/(incr?incr:1)-1; /* # last actual tab */
	if (limit>NTABS-2)
		limit = NTABS-2;
	for (i = 0; i<=limit; i++)
		tabvect[i] = tabn =+ incr;
	tabvect[i] = 0;
	return;
}

/*	arbitab: handle list of arbitrary tabs */

arbitab(scan,tabvect)
char *scan;
int tabvect[NTABS];
{
	register int i, t, last;
	char c;
	last = 0;
	for (i = 0; i<NTABS-1;) {
		if ((c = *scan) == '+') {
			scan++;		/* +n ==> increment, not absolute */
			if (t = getnum(&scan))
				tabvect[i++] = last =+ t;
			else abend("illegal increment");
		}
		else {
			if ((t = getnum(&scan)) > last)
				tabvect[i++] = last = t;
			else abend("illegal tabs");
		}
		if (*scan++ != ',') break;
	}
	if (last > NCOLS)
		abend("illegal tabs");
	tabvect[i] = 0;
	return;
}

/*	filetab: copy tabspec from existing file */
#define CARDSIZ	132
filetab(scan,tabvect,level)
char *scan;
int tabvect[NTABS];
{
	register int length, i;
	register char c;
	int fildes;
	char card[CARDSIZ];	/* buffer area for 1st card in file */
	char state, found;
	char *temp;
	if (level)
		abend("file indirection");
	if ((fildes = open(scan,0)) < 0)
		abend("can't open");
	length = read(fildes,card,CARDSIZ);
	close(fildes);
	found = state = 0;
	scan = 0;
	for (i = 0; i<length && (c = card[i]) != '\n'; i++) {
		switch (state) {
		case 0:
			state = (c == '<'); break;
		case 1:
			state = (c == ':')?2:0; break;
		case 2:
			if (c == 't')
				state = 3;
			else if (c == ':')
				state = 6;
			else if (c != ' ')
				state = 5;
			break;
		case 3:
			if (c == ' ')
				state = 2;
			else {
				scan = &card[i];
				state = 4;
			}
			break;
		case 4:
			if (c == ' ') {
				card[i] = '\0';
				state = 5;
			}
			else if (c == ':') {
				card[i] = '\0';
				state = 6;
			}
			break;
		case 5:
			if (c == ' ')
				state = 2;
			else if (c == ':')
				state = 6;
			break;
		case 6:
			if (c == '>') {
				found = 1;
				goto done;
			}
			else state = 5;
			break;
		}
	}
done:
	if (found && scan != 0) {
		scantab(scan,tabvect,1);
		temp = scan;
		while (*++temp);
		*temp = '\n';
		if (fsuprs == 0)
			write(1,scan,++temp-scan);
	}
	else scantab("-8",tabvect,1);
	return;
}

/*	termadj: check terminal type; adjust margin & maxtab if needed.
	set global tt -> right entry in termtab */
termadj()
{
	register struct ttab *t;
	for(t =tt; t->tcode; t++) {
		if (equal(terminal,t->tcode))
			break;
	}
	if (!t->tcode)
		t = tt;		/* unrecognizable = +t by self */
	if (maxtab == 0)
		maxtab = t->tdefmax;	/* use default, since +l omitted */
	else if (maxtab > t->tmaxtab)
		t = t->tmaxtab;		/* too big, use max allowed */
	tt = t;
	return;
}

char	*cleartabs();
/*	settabs: set actual tabs at terminal */
/*	note: this code caters to necessities of handling GSI and
	other terminals in a consistent way. */

settabs(tabvect)
int tabvect[NTABS];
{
	char setbuf[250];	/* 2+3*NTABS+2+NCOLS+NTABS (approx) */
	register char *p;		/* ptr for assembly in setbuf */
	register int *curtab;		/* ptr to tabvect item */
	int i, previous, nblanks;
	if (istty) {
		ttyold[2] =& 0777757;
		stty(1,ttyold);	/* turn off cr-lf map */
	}
	p = setbuf;
	*p++ = CR;
	if (!quick)
		p = cleartabs(p, tt->tclr);

	if (margflg)
		switch(tt->tmarg) {
		case GMG:	/* GSI300S */
		/* NOTE: the 300S appears somewhat odd, in that there is
		a column 0, but there is no way to do a direct tab to it.
		The sequence ESC 'T' '\0' jumps to column 27 and prints
		a '0', without changing the margin. */
			*p++ = ESC;
			*p++ = 'T';	/* setup for direct tab */
			if (margin =& 0177)	/* normal case */
				*p++ = margin;
			else {			/* +m0 case */
				*p++ = 1;	/* column 1