.de hd
'sp 1
.tl ''- % -''
'sp 2
..
.de ft
'bp
..
.po 6
.lt 85
.ll 85
.pl 12i
.in 0
.nh
.ce 3
.ul
THE UNSW UNIX M6809 ASSEMBLER REFERENCE MANUAL
.sp 2
P.C. Maxwell
.sp
.ul
DEPARTMENT OF COMPUTER SCIENCE
.wh 0 hd
.wh -1i ft
.sp 4
.in +4
.ti -4
.ul
1.  INTRODUCTION
.sp
The UNIX M6809 assembler is a two-pass assembler which assembles source
programs into Minibug loader format and produces a formatted listing.
The object code is produced on a file named m.out and the listing on m.lst.
.sp 2
.ti -4
.ul
2.  ASSEMBLER SOURCE STATEMENTS
.sp
A source program is composed of a sequence of statements.  A source
statement includes from zero to four fields.  From left to right, the four
fields are:
.sp
.ti +6
(1)  label (2)  operator (mnemonic) (3)  operand (4)  comment
.sp
The comment is optional, but may be used with any source statements.
.sp
Blank lines are also recognized by the assembler and printed as such on
the listing.  A label is required for some statements which are involved
with the definition of symbols and, in some cases, as the destinations
of branch and jump instructions.  An operand field may or may not be
present depending on the nature of the operator.  The successive fields
within a statement are separated by one or more tabs and/or spaces.
Except for the label field, which may appear on a line by itself, each
source statement must appear on a single line.
.sp
An asterisk (*) in the first character position of any line causes the
entire line to be treated as a comment.  Otherwise, the comment
will be preceded in the statement by one or more fields of the other three
types, and the comment will occupy the last field in the statement.
.sp 2
.ti -4
.ul
3.  LABELS
.sp
The following rules apply to labels:
.in +4
.sp
.ti -4
1.\ \ A label consists of from 1 to 8 alphanumeric characters (upper and
lower case are distinguished), or a single digit 0 - 9 inclusive
(these are temporary labels).
.sp
.ti -4
2.\ \ The first character of a label must be alphabetic, except temporary
labels.
.sp
.ti -4
3.\ \ A label must begin in the first character position of a statement.
.sp
.ti -4
4.\ \ All labels within a program must be unique (except for temporary labels
or if the program is segmented - see under SEG).
.sp
.ti -4
5.\ \ A label must not be the same as a reserved register name (A,B,X,Y,U,S,DP).
.sp
.ti -4
6.\ \ A label must not be any of the mnemonics that are used for
instructions or directives.
.sp
.ti -4
7.\ \ Labels may appear on a line by themselves.
.sp
.ti -4
8.\ \ Labels should be followed immediately by a colon for ease
of reading.
.in -4
.bp
.ul
Temporary Labels
.sp
These consist of a single digit [0 - 9] and are used in branch/jump
instructions in association with the characters `f' and `b'.  Thus
.sp
.in +18
.ti -8
bra\ 2b\ \ branch to the first label `2' encountered
before this instruction.
.ti -8
jmp\ 3f\ \ jump to the first label `3' encountered
following this instruction.
.in -18
.sp
From these examples it is seen that temporary labels can be multiply defined.
.sp 2
.ul
.ti -4
4.  THE OPERATOR FIELD
.sp
The mnemonic operators recognised by the assembler include 59
.ul
executable instructions,
each of which is translated by the assembler into instructions of from one
to three bytes of machine code.  The remaining mnemonic operators are
.ul
assembler directives,
of which four (FCB, FCC, FDB and ZMB) are translated into one or more
bytes of machine code.  The other assembler directives control the overall
assembly process and are not translated individually into machine code.
All operators may be written in either upper or lower case and must not
start in the first character position.
.sp 2
.ul
.ti -4
5.  OPERAND
.sp
The assembler recognises numbers, symbols and expressions in the operand
field.  The number and symbol are a degenerate form of the expression.
.sp
.ul
The Expression Constituting the Operand Field
.sp
An expression is either a symbol, a number, or combination of symbols and
numbers being separated from one another by the arithmetic operators
(+, -, *, or /), blanks and parentheses.
.sp
Numbers may be decimal, octal, hexadecimal or binary, indicated as follows:
.sp
.ti +4
.ul
Decimal
\ \ -  no prefix or suffix  e.g.  17, 29, 350 etc.
.ti +4
.ul
Octal
\ \ -  prefix of @ (or o' or O')  e.g.  @4     4 decimal
.ti +48
@17    15 decimal
.ti +48
@19    illegal
.sp
.ti +4
.ul
Hexadecimal
\ \ -  prefix of $ (or x' or X')  e.g.  $10    16 decimal
.ti +55
$A    10 decimal
.sp
.ti +4
.ul
Binary
\ \ -  prefix of % (or b' or B') e.g.  %1101    13 decimal
.sp 2
Symbols normally have the value of the corresponding label appearing
elsewhere in the program.  The excepting symbol is `*' which has the
value of the PC at the location where the * is used.
.sp
The assembler evaluates expressions algebraically from left to right (there
is no precedence).  No parentheses are allowed within an expression.
.sp
A fractional result, if obtained during the evaluation of an expression,
will be truncated to an integer value.
.sp
.ul
NOTE:
The use of expressions in the
source language does not imply any capability of the microprocessor to
evaluate those expressions, since the expressions are evaluated during
assembly and not during execution.
.sp 2
.ul
.ti -4
6.  ADDRESSING
.sp
Most addressing modes are implicit in the type of instruction used
(e.g. LDA addresses the accumulator A; BRA is relative).  Some,
however, need specified indicators, as follows:
.sp 2
.ul
Register Addressing
.sp
In cases where a register or set of registers is used by an instruction,
 these appear in the operand field separated by commas:
.sp
.in 14
TFR	X,Y
.br
PSHS	A,B,X,Y
.in -10
.sp 2
.ul
Immediate Addressing
.sp
This mode of addressing is selected by beginning the specification of
the corresponding operand with the character `#'.
.br
With the immediate mode of addressing, the operand field of the source
statement either contains the actual value of the operand, or it includes
a symbol or an expression which has, when fully evaluated, an algebraic
value equal to the value of the operand.  The operand may be specified
in accordance with any of the following formats:
.sp
.in +14
#Number
.br
#Symbol
.br
#Expression
.br
#'
.in -14
.sp
The first 3 are self explanatory (note that the value must be in the allowed
range
to be accommodated in 8 bits for all except X and SP, in which 16 bit numbers
are allowed).  In the last of the alternative forms, #', the apostrophe
instructs the assembler to translate the next character into the corresponding
7-bit ASCII code.  The ASCII code so obtained is then the value of the operand.
Bits 0\ -\ 6 are used, with bit 7 = 0.  Commonly used special characters
used in this form are provided for as follows:
.sp
.in +24
.ti -6
Use   \\n   for linefeed
.br
\\r       carriage return
.br
\\b       backspace
.br
\\t       tab
.br
\\s       space
.br
\\0       null
.sp
.in -24
Note that character constants may be used anywhere an expression or number
is allowed.  The above special character representations may also appear
in the FCC directive.
.sp 2
.ul
Relative Addressing
.sp
Because a 1 byte offset is an 8-bit signed number, the address of the destination
is limited by
.sp
.ti +20
(* + 2) - 128  <=  D  <=  (* + 2) + 127
.sp
If a branch is desired outside these limits a long branch
(or jump) instruction must be used.
If the branch length is not known, the following substitutions may be used:
.bp
.ti +20
JBR   instead of   BRA/LBRA
.ti +20
JBS   instead of   BSR/LBSR
.sp
in which case the assembler will insert the appropriate form.  The
same philosophy applies to conditional branches, where `J' may be used
in place of `B' to give JEQ, JLS etc.
.sp 2
.ul
Indexed Addressing
.sp
The data for obtaining the numerical address may be written in any of the
forms:
.sp
.in +20
,R
.br
{A|B|D},R
.br
{number|symbol|expression},R
.br
,{-|--}R{+|++}
.sp
.in -20
where R = X,Y,U or S.  The first form is equivalent to '0,R' i.e. the
operand address is the same as the contents of the index register.  In all
other cases
.sp
.ti +10
effective address  =  value + contents of index register (R)
.sp
where "value" is the 8-bit or 16-bit
.ul
signed
number obtained from evaluating
the "expression", "symbol" or "number".
.sp 2
.ul
PC Relative Addressing
.sp
This is really another form of indexing where the PC is used as the index
register.  The only form allowable is
.sp
.ti +14
{number|symbol|expression},PCR
.sp 2
.ul
Direct and Extended Addressing
.sp
By default, addressing will be in extended mode.  Direct addressing may
be selected by use of the symbol '<':
.ti +14
.sp
e.g.  LDD	<CAT
.sp
.br
in which case the least significant 8 bits of the operand address are
placed in the byte following the opcode.  It is assumed that DP will have
the correct value to be used as the high order byte of the address during
execution.
.sp 2
.ul
Indirect Addressing
.sp
This is implemented by enclosing the operand in square brackets:
.sp
.ti +14
e.g.   LDB	[THING]
.br
.ti +21
LDD	[A,Y]
.sp
where the operand may be of type extended or indexed (excluding increment or
decrement by 1 but including PC relative).
.sp 2
.ul
.ti -4
7.  ASSEMBLER DIRECTIVES
.sp
The assembler directives allow the programmer control of the assembly
of the executable instructions into machine code, including control of
the allocation of memory, and assignment of values to data, when
applicable.  The assembler directives also provide for the control
of the format of the assembler output, and for user options.
.sp
A functional calssification of the assembler directives is given below:
.sp
.in +17
.ti -9
ORG\ \ \ :\ \ Assigns origin of program counter.  Its function is to
define the numerical address of the first byte of the subsequent portion
of the coded program.
.sp
.ti -9
EQU\ \ \ :\ \ Equates a symbol to a numerical value, another symbol
or an expressions.  The value of the operand may not be determined until
pass two of the assembly process.
.sp
.ti -15
BYTE, FCB\ \ \ :\ \ Form Constant Byte.  FCB places the values of its operands
in the following bytes of code.
.sp
.ti -16
ASCII, FCC\ \ \ :\ \ Form Constant Character.  FCC places the ASCII value of its
string operand into the code.
.sp
.ti -15
WORD, FDB\ \ \ :\ \ Form Double Byte.  FDB places the value of its operands in
the following two-byte groups.
.sp
.ti -9
RMB\ \ \ :\ \ The assembler reserves a number of bytes of code; the number
is determined by the RMB operand.
.sp
.ti -9
ZMB\ \ \ :\ \ The same as RMB except the locations are set to zero.
.sp
.ti -14
PAG, OPT\ \ \ :\ \ Concerned with options regarding source listings.
.sp
.ti -9
SEG\ \ \ :\ \ Used to segment the program.  The code following the
directive forms a new segment.
.sp 2
.in -17
.ul
FCC  Form Constant Characters
.sp
The "FCC" directive translates strings of characters into their 7-bit ASCII
codes.  The format is
.sp
.ti +20
FCC     /text/
.sp
If the actual text is required to include the slash character then `\\/'
should be used.  Thus:
.sp
.ti +20
FCC     /\\//
.sp
is translated into a single byte representing the ASCII code for /.
.sp 2
.ul
FDB (FCB)  Form Double (Constant) Byte
.sp
These directives may have one or more operands separated by commas.
A 16-bit (8 for FCB) signed binary number, corresponding to the value
of each operand is stored in two (one) bytes of the object program.
Negative operands are converted into 2's complement.  Characters are
inserted if preceded by ':
.sp
.ti +10
e.g.  FCB   -2, X'AB, 'a, '\\r
.sp
would result in FE, AB, 61, 0D.
.bp
.ul
ORG  Origin
.sp
This defines the numerical address of the first byte of machine code
which follows the ORG statement.  The operand field may be a number,
symbol or expression.  If no ORG statement appears at the start of a
program, the default setting of the PC is 0000.
.sp 2
.ul
SEG  Segment
.sp
The segmentation implemented in this assembler provides a means of
logically splitting the source program.  The boundaries between
multiple input files are not automatically assumed to be segment boundaries.
Segmentation is achieved by use of the directive SEG.  The first
character of the first (or only) file of a segmented program must be `#'.
This should be followed by the SEG directive.  In this first occurrence
only it is necessary to specify the segmentation character as follows:
.sp
.ti +10
either  a)  SEG -C
.ti +14
or  b)  SEG C
.sp
where C is an alphanumeric character (including `$' and `_').
.sp
.in +12
.ti -4
a)\ \ defines that all identifiers beginning with C are global and all
others local, and
.ti -4
b)\ \ defines that all identifiers beginning with C are local and all others
global.
.in -12
.sp
Subsequent SEG calls effectively clear the symbol table of all local symbols.
This means the same local symbols may be used in more than one program
segment (refer point 4 under rules for labels).  Subject to certain
selectable options (see below), the listing will contain a local symbol
table at the end of each segment.
.sp
In a segmented program it is illegal to use an identifier consisting solely
of the segmentation character.
.sp
There is no restriction on jumping over segment boundaries even to temporary
labels.
.sp 2
.ul
PAG  Page
.sp
This command produces a form feed to a new page on the source listing.
.sp 2
.ul
OPT  Options
.sp
The following format statements (in upper or lower case) are recognised after
the OPT directive:
.sp
.in +12
.ti -8
FCCOFF\ \ limits the listing of the code generated by the FCC directive
to one line only (this is the default setting).
.sp
.ti -8
FCCON\ \ \ causes the full code generated by FCC directives to be listed.
.sp
.ti -12
FDB and FCB also have similar forms to limit listings.
.sp
.ti -8
SYMOFF\ \ suppresses the printing of all subsequent symbol tables (if any).
.sp
.ti -8
SYMON\ \ \ causes any subsequent symbol tables to be printed.
.sp
.in -12
Because a local symbol table is generated at the end of each segment
and a global symbol table at the end of the listing, the ability to
switch the listing of symbol tables on and off is not superfluous.
.sp 2
.ti -4
.ul
8.  LIMITS
.sp
The following limits apply to the assembler:
.sp
.ti +8
Symbol table   200 symbols (or as selected - see Usage)
.sp
.ti +8
Line length    132 characters.
.sp 2
.ti -4
.ul
9.  USAGE
.sp
The assembler should be called as follows:
.sp
.ti +6
mas09 [-l] [-s[n]] file [more files]
.sp
The assembler will assemble the concatenation of the given files as though
they were one file.  The -l and -s flags operate as follows:
.sp
.in +30
.ti -24
none present (default)  object code written to a file `m.out';
no listing is produced; symbol table is 200.
.sp
.ti -24
-l\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ as above but a listing is
produced on a file `m.lst'.
.sp
.ti -24
-s\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ set symbol table size to 400.
.sp
.ti -24
-sn\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ set symbol table size to n
(minimum 200).
.sp 2
.in -30
.ul
.ti -4
10.  DIAGNOSTICS
.sp
When syntactic or semantic errors occur, a self-explanatory error message
is output indicating the line-number and file in which the error occurred.
Errors in pass 1 cause the cancellation of pass 2.
.sp
The only errors that are detected in pass 2 are undefined symbols and
branch instructions whose targets are out of range.  If either of these
errors occurs, the listing and object files are still produced.
.sp
For undefined symbols, a `U' appears in column 1 of the listing against
each reference to the symbol.  The error is also indicated in the
symbol table, if any.  The value of an undefined symbol is taken to be zero.
.sp
For out-of-range branch instructions a `B' appears in column 1, and a
zero relative address is generated.
.sp
Symbol table overflow is indicated by a message.
.sp
If "assembler error" appears, seek help as this indicates something has
gone wrong with the assembler, rather than with your program.
.bp
.ti -4
.ul
APPENDIX  -  USE OF THE ASSEMBLER WITH THE 6809 S-BUG SYSTEM
.sp
.ti -4
1.  Power on terminal.
.sp
.ti -4
2.  Set all switches (on right hand side of terminal keyboard) UP.  In
particular the L-R (local-remote) switch should be set to R.
.sp
.ti -4
3.  The indicator:
.br
.ti +14
11/40 login:
.br
should appear.  You are now communicating with Unix.
.sp
.ti -4
4.  Assemble your program.
.sp
.ti -4
5.  Type 'load'.
.sp
Load is the command to Unix to take the 'm.out' file and transfer it to your
6809 system.  The hexadecimal encoding of the assembled program should be
listed on the terminal screen.  If a successful load has been accomplished
from Unix, the message
.sp
.ti +14
good load
.sp
will appear.  If the message does not appear then repeat step 5.  If it
still doesn't appear, seek help.
.sp
.ti -4
6.  Now switch the L-R switch to L (local).  You are now communicating
with S-BUG on the 6809.
.sp 2
For utilisation and operation of S-BUG refer to the user/reference manual.
