/*
 * KT-11 addresses and bits.
 */

#define	UISD	((physadr)0177600)	/* fst user I-space desc reg */
#define	UISA	((physadr)0177640)	/* fst user I-space addr reg */
#define	UDSA	((physadr)0177660)	/* fst user D-space addr reg */

#define	RO	02		/* read only */
#define	RW	06		/* read/write */
#define	ED	010		/* extend direction */
#define	TX	020		/* Software: text segment */
#define	ABS	040		/* Software: absolute address */

/*
 * base of the per-process data area (initialised in mch.s)
 *	D-Space on machines that have it; else I-Space
 */
physadr	ka6;

/*
 * base of the buffers (initialised in mch.s)
 *	D-Space on machines that have it; else I-Space
 */
physadr	ka5;
physadr	kd5;

/*
 * address to access 11/70 UNIBUS map
 */
#define	UBMAP	((physadr)0170200)

/*
 * address of Stack Limit Register (if it exists)
 */
#define	SLR	((physadr)0177774)
