/*
 *	Multiplexed-line structure - one per physical line.
 *	Each physical line may support up to 16 virtual lines
 *	(as open lines are indicated by setting bits in a short).
 */
struct	mx
{
	dev_t		mx_dev;		/* real device id for this line	*/
	char		mx_speeds;	/* real speeds to run this line	*/
	char		mx_nports;	/* nr. of ports for this line (<16) */
	short		mx_open;	/* bit mask of open ports this line */
	char		mx_state;	/* state of input from line */
	char		mx_dbase;	/* minor number to port mapping base */
	char		mx_cnt0;	/* first byte count */
	char		mx_count;	/* bytes left in current message */
	char		mx_xbytes;	/* count of unexpected chars */
	char		mx_ctty;	/* port for current message on line */
	char		mx_oport;	/* last port kicked in mxscan */
	struct tty	*mx_rtty;	/* tty structure of real line */
};

/*
 *	Flow-control variables needed per virtual line
 */
struct	mxflc
{
	char	fc_mxtflc;	/* mx transmit flow validated */
	char	fc_mxrflc;	/* mx receive flow allocated */
	char	fc_lrsiz;	/* last size received for flow control */
	char	fc_idle;	/* seconds that line has been idle */
	short	fc_rate;	/* rate count */
};
