/*
 * Inode structure as it appears on a disk block.
 */
#define	DNADDR	13		/* number of block addresses (each 3 bytes) */
struct dinode
{
	unsigned short	di_mode;     	/* mode and type of file */
	short	di_nlink;    	/* number of links to file */
	short	di_uid;      	/* owner's user id */
	short	di_gid;      	/* owner's group id */
	off_t	di_size;     	/* number of bytes in file */
	char  	di_addr[DNADDR*3];	/* disk block addresses */
	char	di_pad;		/* spare byte! */
	time_t	di_atime;   	/* time last accessed */
	time_t	di_mtime;   	/* time last modified */
	time_t	di_ctime;   	/* time created */
};
#define	INOPB	8	/* 8 inodes per block */
/*
 * the 39 address bytes: 13 addresses of 3 bytes each.
 *	The bytes are as longs would appear minus the most-significant byte
 *	(hence machine-dependant).
 */
