	.title	basic plus to unix interface
.rem *
 ##################################################################
 # these routines interface basic to the system			#
 # all system calls are contained herein			#
 ##################################################################
*
	global	<savreg,resreg,detflg,usrsp,trpint>
	global	<dobye>

	.macro	goof why			;field fip/emt errors
	mov	#why,iosts			;post the error
	return					;fip->emt->rts->user

	.endm

	.macro	fioxit				;fip i/o error exit
	asl	r0				;word offset
	mov	errtab(r0),iosts		;slip him an error
	return					;and return
	.endm
	.macro	fiox
	asl	r0
	mov	errtab(r0),iosts
	.endm

	.macro	fipent	code
	tmporg fiptbl,<2*code'fq>
	.word	fq'code
	unorg
	entry	fq'code
	.endm

	.macro	jsp	where
	jsr	pc,where
	.endm
	.macro	return
	rts	pc
	.endm

	.macro	js5	where
	jsr	r5,where
	.endm

	.macro	saver
	js5	savreg
	.endm

	.macro	resr
	js5	resreg
	.endm




	.sbttl	initialization

	org	unx
	entry	unxini

	global	<savreg,resreg,ccint,cc2int,newjob,fiptbl>

	.nlist me,meb,me,meb

	signal					;catch emt's
	+	sigemt
	+	trpint
.if ne alrm
	signal
	+	sigclk
	+	clkint
.endc
	jsp	getsig				;get initial signal status
	jsp	onsig				;quit, interrupt
	mov	(sp)+,(sp)			;don't care about our name
	mov	sp,r3				;see if forced run
	dec	(r3)				;first our name
	mov	(r3)+,r4			;remaining count
	sub	#2,r4				;we need two args
	bmi	2$				;don't have them
	cmpb	@(r3)+,#'-			;must start with -
	bne	2$				;nope.
	mov	(r3),r2				;filename pointer
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	sys	stat.,r2,#statbuf		; does 'name' exist ??
	bcc	1$				; --> yes
	movb	#'/,-(r2)
	movb	#156,-(r2)			; 'n
	movb	#151,-(r2)			; 'i
	movb	#142,-(r2)			; 'b
	movb	#'/,-(r2)
	sys	stat.,r2,#statbuf		; does '/bin/name' exist ??
	bcc	1$				; --> yes
	movb	#162,-(r2)			; 'r
	movb	#163,-(r2)			; 's
	movb	#165,-(r2)			; 'u
	movb	#'/,-(r2)
					; assume '/usr/bin/name' exists
1$:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	mov	r4,(r3)				;now argc
	mov	r2,-(r3)			;save for a brief moment
	bis	#jfonce,jobf			;quit after this
	mov	r3,usrsp			;where stack will go
	br	3$				;no message
2$:	mov	sp,usrsp			;where stack will go
	mov	#1, r0				;on STO
	write.,	messg,	msgend-messg
3$:	clr	r0				;get mode on SI
	fstat.
	+	statbuf
	mov	statbuf+4,sibits
	mov	#1,r0
	fstat.
	+	statbuf+4
	cmp	statbuf,statbuf+4		;same?
	bne	11$				;no
	cmp	statbuf+2,statbuf+6		;same?
	bne	11$				;no
	inc	iosame				;yes
11$:	open.,	errf,	0			;open the error file
	mov	r0,errfd			;store file descriptor
	jsp	tmpnam				;generate unique temp name
	jmp	newjob				;start him up.....

	.sbttl	catch & reset UNIX signals

clkint:	mov	r0,-(sp)
	signal
	+	sigclk
	+	clkint
	mov	(sp)+,r0
	rti

	.sbttl	pseudo-monitor calls



;*********************************************************
; 	Entry to system functions
;*********************************************************
	entry	unxent		; pseudo system call
	saver			; save all registers untouched.
	clr	iosts		; no error yet
	jsp	@(r5)+		; call proper monitor routine
	resr			; restore all registers
	tst	(r5)+		; correct restored r5
	rts	r5		; back to caller

;*********************************************************
;	Generate a unique temp file name
;*********************************************************
tmpnam:	getpid.			;form is +btm/xxxxxxx+
	mov	#tmpfil+14.,r1	;prepare for digits
1$:	movb	r0,-(r1)	;to octal
	bicb	#370,(r1)
	bisb	#60,(r1)
	ash	#-3,r0
	cmp	r1,#tmpfil+8.
	bhi	1$
	return			;new name installed

;********************************************************
; NAME -
;	install problem name
;********************************************************
	entry	namexx		;install a problem name
	mov	#firqb+fqnam1,r1	
1$:	mov	#pname,r0
	mov	r0,r2
	add	#10.,r2
	clr	r4
2$:	movb	(r1)+,r3
	beq	3$
	cmpb	r3,#'/
	beq	1$
	cmpb	r3,#'.
	bne	4$
	inc	r4
4$:	tst	r4
	bne	2$
	cmp	r0,r2
	bhis	2$
	movb	r3,(r0)+
	br	2$
3$:	cmp	r0,r2
	bhis	5$
	clrb	(r0)+
	br	3$
5$:	return

;******************************************************
; DATE -
;	produce date in screwy format
;******************************************************
	entry	dater
	time.
	sub	#timzon*3600.,r1	;from UNIX, minus GMT
	sbc	r0
	div	#8.*3600.,r0	;into 8 hour units
	mov	r1,-(sp)	;save remainder in seconds
	mov	r0,r1
	clr	r0
	div	#3,r0		;now, r0 is days
	mov	#L1,r2		;year table
	mov	#-1,r3		;year count
1$:	inc	r3
	sub	(r2)+,r0
	bpl	1$
	add	-(r2),r0
	inc	r0		;now, r0 is days + 1
	mul	#1000.,r3	;years*1000.
	add	r0,r3		;+ days
	mov	r3,xrb+xrlen	;ready to return
	mov	(sp)+,r3	;some seconds
	clr	r2
	div	#60.,r2		;into minutes +
	neg	r3
	add	#60.,r3
	mov	r3,xrb+xrloc	;60-seconds
	mul	#8.*60.,r1	;8-hours to minutes
	add	r2,r1
	neg	r1
	add	#1439.,r1
	mov	r1,xrb+xrbc	;1439.-minutes
	mov	#pname,r1
	mov	#xrb+xrci,r2
	mov	#10.,r3
	movb	(r1)+,(r2)+
	sob	r3,.-2
	return

L1:	.word	365.,365.,366.,365.,365.,365.,366.,365.,365.,365.,366.

	tmporg	udata
timwk0:	.blkw	2
timwk1:	.blkw	2
	.blkw	4
	unorg

;******************************************************
; TIME -
;	return a pile of times
;******************************************************
	entry	timer				;misc. statistics
	times.
	+	xrb				; into xrb
	return		;"finished return"
;					(to quote vDV)

;*********************************************************
; ECHOMD -
;	Enable echo on channel
;*********************************************************
	entry	echomd		; enable echo on given channel
	jsr	r5,ttystf
	+	10
	+	0
	return

;*********************************************************
; ECHODS -
;	Disable echo on a terminal
;*********************************************************
	entry	echods		; disable echo on given channel
	jsr	r5,ttystf
	+	0
	+	10
	return

;*********************************************************
; TTCLO -
;	Reset control/O on a given channel
;*********************************************************
	entry	ttclo		; reset control O on given channel
	jsr	r5,ttystf
	+	0
	+	0
	return

;*********************************************************
; TTODT -
;	Set odt mode on a channel
;*********************************************************
	entry	ttyodt		; set ODT mode on given channel
	jsr	r5,ttystf
	+	40
	+	0
	bcs	1$
	bis	#flgodt,uftab(r3)
1$:	return

;*********************************************************
; TTRES -
;	Reset control O and odt mode on channel 0
;*********************************************************
	entry	ttres		; reset control/O and odt mode
	clrb	xrb+xrci
	jsr	r5,ttystf
	+	0
	+	40
	bic	#flgodt,uftab(r3)
	return


;*********************************************************
;	Clear some bits in a tty entry.
;	Set some bits in a tty entry.
;	Do a stty if the result if different than 
;		the source.
;*********************************************************
ttystf:	movb	xrci+xrb,r3
	cmp	r3,#<chnmax*2>
	bhi	4$			;just skip it
	bit	#flgopn,uftab(r3)	;similarly if not
	beq	4$			;open
	movb	uftab+1(r3),r1
	bpl	2$
1$:	inc	r1			;from -1 to 0
2$:	mov	r1,r0
	gtty.,	timwk0
	bcs	3$
	mov	timwk0+4,r2
	bis	(r5),timwk0+4
	bic	2(r5),timwk0+4
	cmp	timwk0+4,r2
	beq	4$
	stty.,	timwk0
	bcc	4$
3$:	fiox
4$:	cmp	(r5)+,(r5)+
	rts	r5

;*********************************************************
; FORK -
;	Parent return is skip, child is not.
;	Child PID is saved for possible later wait
;	Error return if fork is not possible.
;*********************************************************
	entry	forkxx
	fork.
		br 1$		;child return
	bcc	2$
	incb	iosts		;fork error
2$:	add	#2,14(sp)	;set up skip
	mov	r0,childp
	return
1$:	jsp	tmpnam		;set up temp name
	return			;child

;*********************************************************
; CTMP -
;	Duplicate temp file for use by both parent
;	and child. Error return is possible.
;	Special entry with r2 pointer to a buffer that 
;	can be used.
;*********************************************************
	entry	ctmpxx
	mov	#tmpfil+8.,r0
	mov	#cpyfil+8.,r1
1$:	movb	(r0)+,(r1)+	;make copy file name
	bne	1$
	creat.
	+	cpyfil
	+	600
	bcs	5$
	mov	r0,r4
	mov	r2,syscb+2
2$:	mov	#512.,syscb+4
	movb	uftab+<<13.*2>+1>,r0
	sys	read.
	bcs	4$
	mov	r0,syscb+4
	beq	3$
	mov	r4,r0
	sys	write.
	bcs	4$
	cmp	r0,syscb+4
	beq	2$
4$:	unlink.
	+	cpyfil
5$:	incb	iosts
3$:	return

;*********************************************************
; RTMP -
;	Rename the temp files
;*********************************************************
	entry	rtmpxx
	link.
	+	tmpfil
	+	cpyfil
	unlink.
	+	cpyfil
	return

;*********************************************************
; WAIT -
;	wait for the last child process created
;*********************************************************
	entry	waitxx
	clr	childs
2$:	jsp	offsig
3$:	wait.
	bcs	1$
	mov	r1,childs
	cmp	r0,childp
	bne	3$
1$:	jmp	onsig

;*********************************************************
; EXEC -
;	Execute another program.
;	On entry r0 points to the program name,
;		  r1 to the argument list.
;	No return.
;*********************************************************
	entry	execxx
	sys	exec.,r0,r1
	exit.			; not our temp file to delete

;*********************************************************
; SIG -
;	Set/reset signal catching for a given signal
;	Signal number and action follow call in-line
;*********************************************************
	entry	sigxx
	mov	14(sp),r1
	sys	signal.,2(r1),4(r1)
	add	#4,14(sp)	; adjust return
	return

;*********************************************************
; GETSIG -
;	Gets status of INTR and QUIT signals and
;	saves appropriate signal action in 'kilsav',
;	and 'qitsav' respectively.
;	This has been added to permit asynchronous basic
;	programs, which ignore signals.
;
;*********************************************************

	entry	getsig
	signal.
	+	sigint
	+	1
	mov	r0, kilsav	;r0 has old signal status (0 or 1)
	bne	1$
	mov	#ccint, kilsav
1$:	signal.
	+	sigqit
	+	1		;ignore QUIT
	mov	r0, qitsav
	bne	2$
	mov	#cc2int, qitsav
2$:	return

;*********************************************************
; ONSIG -
;	turn on catching control/C and control/P
;			 (interrupt)   (quit)
;*********************************************************
	entry	onsig
	indir.
	+	intind
	indir.
	+	qitind
	return

;*********************************************************
; OFFSIG -
;	turn off catching control/C and control/P
;*********************************************************
	entry	offsig
	signal
	+	sigint
	+	1
	signal
	+	sigqit
	+	1
	return


;*********************************************************
; FIP -
;	File handling routines. Dispatch by subcode.
;*********************************************************
	entry	unxfip
	movb	firqb+fqfun,r0			;get subfunction
1$:	asl	r0				;make word offset
	jsp	@fiptbl(r0)			;to proper fip routine
	return					;back to the user via emt

;*********************************************************
; General open routine:
;	Check for character device, random access, etc.
;*********************************************************

opx:	tst	(sp)+			;called with hsr r5, but we don't return
	movb	firqb+fqfil,r3		;get channel no. * 2
	bit	#flgopn,uftab(r3)	;is file open?
	beq	10$			; yes
	goof	notcls			;no - error
10$:	jsr	pc,2(r5)		;call supplied open routine
	bcc	12$			;return with cc's set
13$:	fioxit				;post to user
12$:	bis	(r5),uftab(r3)		;set in proper bits
	movb	r0,uftab+1(r3)
	mov	firqb+fqlksz,firqb+fqbufl
	bne	3$
	mov	#dskbfl,firqb+fqbufl
3$:	mov	firqb+fqbufl,chnblk(r3)
	fstat.
	+	statbuf
	mov	statbuf+4,-(sp)
	bic	#^c60000,(sp)
	cmp	(sp)+,#20000
	beq	1$
	seek.
	+	0
	+	1
	bcs	1$
	bis	#flgrnd,firqb+fqflag
	bit	#2,firqb+fqbits			;check if open for APEND
	beq	2$
	seek.
	+	0
	+	2
	return
1$:	bis	#flgfrc,firqb+fqflag
2$:	return

;*********************************************************
; ISKB -
;	Handle kb: pseudo-device
;*********************************************************
iskb:	mov	firqb+fqnam1,r0		;special check for KB:
	bic	#20040,r0		;to upper case
	cmp	r0,#"KB			;actually caseless
	bne	1$			;its not KB
	cmp	firqb+fqnam1+2,#':	;get next art
	bne	1$			;its not KB:
	mov	#-1,r0			;special file descr.
	clc				;make sure cc o.k.
	rts	pc			;and leave
1$:	sec				;set carry bit
	rts	pc			;and leave

opxx:	jsr	pc,iskb			;check if kb?
	bcc	opzz			;yes
opyy:	open.				;idiotic rts rules
	+	firqb+fqnam1
	+	2
	bcc	opzz
	open.
	+	firqb+fqnam1
	+	1
	bcc	opzz
	open.
	+	firqb+fqnam1
	+	0
opzz:	rts	pc

;*********************************************************
; OPEN -
;	Open a file for input/output/or input/output
;	on a given channel.
;*********************************************************
	fipent	opn		;open a file for input
	jsr	r5,opx			;general opener
	+	flgin+flgopn		;modes
	br	opxx

;*********************************************************
; CLOSE -
;	Close a given channel
;*********************************************************
	fipent	cls
	mov	firqb+fqfil,r3			;get rsts channel
	beq	2$				;never close channel zero
	movb	uftab+1(r3),r0
	ble	1$				;a standard file
	close.
;( no error checking needed here )
1$:	clr	uftab(r3)			;lose fd and flags
2$:	return					;all done

;*********************************************************
; RST -
;	Close all except perhaps one channel
;*********************************************************
	fipent	rst
	mov	#firqb,r4
	movb	fqfil(r4),r2
	bgt	30$				;only one channel here
	negb	r2
	mov	#15.*2,fqfil(r4)		;start with channel 15.
10$:	cmpb	fqfil(r4),r2			;skip this channel?
	beq	20$				;yes, skip it
	jsp	fqcls				;go for a close
20$:	sub	#2,fqfil(r4)			;next channel please
	bne	10$				;we never close channel 0
30$:	jmp	fqcls				;take it away, close!

;*********************************************************
; DLN -
;	Delete a file
;*********************************************************
	fipent	dln
	unlink.
	+	firqb+fqnam1
	bcc	1$				;all done
	fiox					;no, error
1$:	return					;done.

;*********************************************************
; CRB -
;	Create a binary file
; CRE -
;	Create a non-binary file.
;*********************************************************
	fipent	crb		;open as
	fipent	cre
	jsr	r5,opx			;general open
	+	flgopn+flgin+flgou	;in and out
	jsr	pc,iskb			;check if kb?
	bcc	6$			;yes - no work.
	tst	firqb+fqmode		;check real mode
	bmi	3$			;its real
	mov	#basmod,firqb+fqmode	;make default
3$:	sys	creat.,#firqb+fqnam1,firqb+fqmode
	bcs	6$			;creat failed
	close.				;must close to re-open
	sys	chmod.			;try to get mode right
	br	opyy
6$:	rts	pc			;end of opener

;*********************************************************
; CRT
;	Create/recreate the temp file
;*********************************************************
	fipent	crt		;create temp file
	jsr	r5,opx			;general open
	+	flgopn+flgou+flgin	;all flags
	creat.				;easy
	+	tmpfil			;name
	+	600			;mode
	bcs	1$			;blew it
	close.
	open.
	+	tmpfil			;for rw
	+	2
1$:	rts	pc			;exit

;*********************************************************
; REN -
;	Rename/change protection codes
;*********************************************************
	fipent	ren
	stat.			;first we check if the two files are equal
	+	firqb+fqnam1	;first file
	+	statbuf
	bcs	3$		;does not exist ...
	mov	statbuf,r2	;save device and
	mov	statbuf+2,r3	;and inode #
	stat.			;now for second file
	+	firqb+fqnam2	;second
	+	statbuf
	bcs	3$		;not here
	cmp	r2,statbuf	;same device?
	bne	3$		;no
	cmp	r3,statbuf+2	;same inode?
	bne	3$		;no
4$:	sys	chmod.,#firqb+fqnam2,firqb+fqmode
5$:	bcc	6$
7$:	fiox			;post some error
6$:	return
3$:	link.			;second file must not exist
	+	firqb+fqnam1
	+	firqb+fqnam2
	bcs	5$		;it bombed.
	unlink.			;try to get rid of previous
	+	firqb+fqnam1	;we may not succeed
	bcc	4$		;we did
	unlink.
	+	firqb+fqnam2	;get rid of copy name if possible
	br	7$		;and give an error

;*********************************************************
; LOK -
;	Look-up a file (error code if not around)
;*********************************************************
	fipent	lok				;lookup by name
1$:	stat.
	+	firqb+fqnam1
	+	statbuf
	bcc	2$
	fiox
2$:	return

;*********************************************************
; ERR -
;	Return text of an error message (32 bytes)
;*********************************************************
	fipent err
	movb	firqb+fqerno,r0			;get error index
fqer01:	bic	#177400,r0
	mul	#32.,r0				;mpy by message length
	mov	errfd,r0			;error file
	sys	seek.,r1,#0			;seek to message start
	mov	errfd,r0			;recover file descriptor
	read.
	+	firqb+fqerno
	+	ermlen
	return					;all done

;*********************************************************
; STAT -
;	Return current and maximum core size
;	(in xrlen and xrloc, respectively)
;*********************************************************
	entry	statxx
	clr	r0				;prepare for divide
	mov	$$core,r1			;total core so far
	beq	1$
	div	#kcore,r0			;1024. wds/k
	br	2$				;no need for min. k
1$:	add	#cormin,r0			;rts min size for user
2$:	mov	r0,xrb+xrlen			;this is total size now
	mov	#cormax,xrb+xrloc		;this is the maximum core allocation
	return

;*********************************************************
; CORE -
;	Expand core if possible.
;	xrlen contains number of k wanted.
;*********************************************************
	entry	corexx
	tst	corfff				;exceeded allocation??
	bne	2$				;yes
	mov	xrb+xrlen,r0			;how much does he want?
	cmp	r0,#cormax			;too big?
	bgt	2$				;yes, sorry.
	mul	#kcore,r0			;from k into bytes
	mov	r1,r2				;save r1 for later
	add	#usrorg-1,r1			;rel to data segment
	sys	break.,r1			;ask for core
	bcc	1$				;we got it
	inc	corfff
;	mov	#cormax*kcore,$$core		;say got lots of core
	fioxit					;no such luck...
1$:
	mov	r2,$$core
	return					;before leaving
2$:	mov	#cormax*kcore,$$core		;say lots of core
	inc	corfff
	goof	xcdcor				;tough luck, friend


;*********************************************************
; SLEEP -
;	Sleep for xrlen seconds
;*********************************************************
	entry	sleeper				;snooze for awhile
	mov	xrb+xrlen,r0			;how long?
	sleep.
	return

;*********************************************************
; WRITE -
;	write on a channel.
;	xrloc is buffer address, xrbc is byte count
;*********************************************************
	entry	writer

	mov	#1,r2				;inidicate 'write'
	br	rdwrit				;join common i/o path

;*********************************************************
; READ -
;	read a channel.
;	xrloc is the buffer address, xrlen is the count.
;	xrtime is the number of seconds to allow for the
;	transfer.
;*********************************************************
	entry	readxx

	clr	r2				;indicate 'read'
;*********************************************************
; READ/WRITE -
;	if xrblk is non-zero, it is the block
;	in the file at which the transfer is to be made.
;	The first block of a file is block 1.
;*********************************************************
rdwrit:	movb	xrb+xrci,r1			;get channel index
	bic	#177600,r1			;clear junk
	bitb	#flgopn,uftab(r1)		;is the channel open?
	bne	1$				;yes, it is
	goof	notopn
1$:	movb	uftab+1(r1),r0			;get unix FD; -1 means SI/SO
	cmpb	r0,#-1				;SI/SO?
	bne	read00				;nope
	mov	r2,r0				;std input or output
read00:	mov	r0,-(sp)			;save file descr.
	mov	xrb+xrblk,r4
	beq	read01
	dec	r4
	mul	chnblk(r1),r4
	div	#512.,r4
	sys	seek.,r4,#3
	mov	(sp),r0
	sys	seek.,r5,#1
read01:	mov	(sp)+,r0			;recover fd
	tst	r2				;read or write?
	bne	writ01				;it's write
	mov	r0,r1				;save fd
	bne	read07				;not channel 0
	tst	detflg				;if he is detched
	beq	read07				;kill him
sysout:	jmp	dobye			;clean up some files


read07:	mov	xrb+xrtime,r0		;set wait time first
.if ne alrm
	clktim.				;how long or infinity
.endc
	mov	r1,r0			;get back fd
	bne	1$			;not SI

	mov	xrloc+xrb,r2		;must simulate TTY in all cases
	clr	r3			;how many bytes
3$:	dec	chanzc			;bytes left in buffer?
	bmi	2$			;no
	movb	@chanzp,(r2)		;move in one byte
	inc	chanzp			;bump pointer
	inc	r3
	cmpb	(r2)+,#012		;the terminator?
	beq	4$			;yes -- end of line
	movb	xrb+xrci,r1		;get proper channel no.
	bit	#flgodt,uftab(r1)	;need we look for a terminator?
	bne	4$			;no
	cmp	r3,xrb+xrlen		;buffer filled?
	blo	3$			;no
4$:	mov	r3,r0			;our byte count
	br	10$			;done
2$:	clr	r0			;on SI
	read.				;refill buffer
	+	chanzb
	+	chanzs
	bcs	5$			;an error is an error
	mov	#chanzb,chanzp		;set up pointer
	mov	r0,chanzc		;and count
	bne	3$			;actually got something
	bit	#60000,sibits		;are we coming from a special file?
	beq	sysout
10$:	mov	r0,xrb+xrbc		;save byte count
	bne	11$			;see if eof
	mov	#eof,iosts		;set up
11$:	clr	r0			;now cancel clock
.if ne alrm
	clktim.
.endc
	movb	xrb+xrci,r1		;may need to turn off odt
	bit	#flgodt,uftab(r1)
	beq	12$			;it isn't on
	bic	#flgodt,uftab(r1)
	movb	uftab+1(r1),r1	;get fd
	bpl	14$		;its si
	inc	r1		;to channel 0
14$:	mov	r1,r0		;to unix fd register
	gtty.,	timwk0		;get tty stuff
	bic	#40,timwk0+4
	mov	r1,r0
	stty.,	timwk0
12$:
	return

1$:	sys	read.,xrb+xrloc,xrb+xrlen	;regular channel
	bcc	10$			;no error
5$:	fioxit				;set error up
	br	10$			;and return



writ01:	sys	write.,xrb+xrloc,xrb+xrbc
	bcc	1$
	cmp	r0,#4				;EINTR is really no error
	beq	1$
	fiox
1$:	return					;no more output translation


;*********************************************************
;	EXIT -
;	delete temp file and leave
;*********************************************************
	entry	sysext			;neat exit
	unlink				;get rid of temp file
	+	tmpfil			;basic has already purged open files
	exit.				;and then go

;*********************************************************
;	The BAC file bootstrap.
;	The length of this must agree with the published
;		figure. (common.m)
;*********************************************************
	org	udata

	global	<datlen,bootln,bootst>
bootst:	.word	407			;UNIX magic header
	.word	0			;text size
datlen:	.blkw				;size of data segment
	.word	0			;bss size
	.word	0			;symbol table size
	.blkw	2			;entry/unused
	.word	1			;no relocation

bootcd:	mov	(sp)+,r0		;get the argument count
	asl	r0			;times two
	add	sp,r0			;bias into stack
	clr	(r0)			;change from -1 to 0
	mov	#boota1-bootcd,-(sp)	;move in the dash
	mov	#boota2-bootcd,-(sp)	;now basic's proper name
	mov	sp,1$			;save where exec want's it
	exec.
	+	boota3-bootcd		;basic's real name
1$:	.blkw				;pointer into stack
	exit.
	.enabl	lc			;some file names
boota1:	.asciz	+-+			;the dash argument
boota3:	.ascii	+/bin/+			;basic's directory
boota2:	.asciz	+basicp+		;and name
	.even
	.dsabl	lc			;back to usual
bootln = .-bootst


	.psect	tables,shr
;*********************************************************
; 'errtab' maps unix errors into rsts error calls
; the error entry is returned, in 'iosts' usually by the
; fioxit macro. noerr means no rsts error code applies
;*********************************************************
	noerr	=	0
errtab:
;	rsts error			unix error

	noerr				;error of 0 = no problem
	prviol				;eperm - no permission
	nosuch				;enoent - file not found
	noerr				;esrch - not applicable
	hngtty				;hung tty
	daterr				;eio - physical i/o error
	nodevc				;enxio
	noerr				;e2big
	noerr				;enoexec
	notopn				;ebadf - read/write on closed file
	noerr				;echild
	noerr				;eagain
	xcdcor				;enomem - out of core
	prviol				;eacces - file protect error
	noerr				;unused
	noerr				;enotblk
	noerr				;ebusy
	fiexst				;eexist - delete first please
	noerr				;exdev
	prviol				;enodev - illegal operation
	noerr				;enotdir
	prviol				;eisdir
	noerr				;einval
	noroom				;enfile - out of file space
	bserr				;emfile - too many open files
	noerr				;enotty
	prviol				;etxtbsy - write on pure text
	noroom				;efbig - file too big
	noroom				;enospc - out of space on fs
	noerr				;espipe
	prviol				;erofs - write on r/o filesytem
	noerr
	noerr
	noerr

	.psect	udata,prv

chanzs	=	10.		;size of SI buffer
chanzp:	.blkw			;pointer into buffer
chanzc:	.blkw			;count of bytes left
chanzb:	.blkb	chanzs		;actual buffer

	.enabl	lc
tmpfil:	.asciz	+/tmp/btmxxxxxx+
cpyfil:	.asciz	+/tmp/Btmxxxxxx+
messg:	.ascii	<12>/UNSW Basic+/<12>
msgend:
errf:	.asciz	+/usr/lib/basic.errf+
	.dsabl	lc
	.even

uftab:
	.byte	flgopn,-1
	. = . + <2*chnmax>

	. = . + 10.
$$core::.blkw				;core allocation
childp:	.blkw
childs:	.blkw
usrsp:	.blkw
	.enabl	lc
pname:	.ascii	/Noname/<0><0><0><0>
	.dsabl	lc
errfd:	.blkw
qitind:	signal
	+	sigqit
qitsav:	.blkw			; setting for quit signal - used by ONSIG
intind:	signal
	+	sigint
kilsav:	.blkw			; setting for interrupt signal - used by ONSIG
detflg:	.blkw					;detached flag
sibits:	.blkw					;mode of SI
iosame:	.blkw				;input and output are the same
corfff:: .word 0				;flag for exceeded allocation
lststs::	.blkw				;list control status
	.even
chnblk:	.blkw	chnmax+1
	global	<syscb,statbuf,iosame,childs,childp>

syscb:	.blkw	4
statbu:	.blkb	40.

	.end

