/
/	MODULA Nucleus
/	Jeremy Holden
/	University of York
/	23 April 1977 
/
/	UNIX Assembler version
/	Ian Wand
/	12 September 1977
/
/	Modified to cope with the LSI11
/	Nigel Hawkins
/	20 December 1977
/
/ Assembly parameters
/
/	notlsi			/ zero to cope with unaddressable PS on LSI11
/	noteis			/ nonzero to include multiply and divide routines
/	corend			/ top of physical store - 2
/
/ These values must be set in a prepended file
/
/
/ System parameters
/
	.if notlsi
	ps	= 177776		/ Processor status
	.endif
/
/ Machine instructions not defined in UNIX Assembler
/
	halt	= 0
	rti	= 2
	reset	= 5
	mtps	= 106400^tst
/
/ Process descriptor offsets
/
	pp	= r5			/ Process pointer
	p.sp	= 0			/ Process SP
	p.pc	= 2			/ Process chain
	p.is	= 2			/ Interrupted process SP
	p.st	= 4			/ Process status
	p.sc	= 6			/ Signal chain
	p.ex	= 10			/ Exception chain
	pdsize	= 12			/ Descriptor size
/
/ Device process descriptor template
/
d_sp:		0
d_is:		0
d_st:		0
d_sc:		0
d_ex:		0
d_in:	mov	r0, -(sp)		/ Interrupt entry point
	mov	r1, -(sp)		/ Save registers
	mov	sp, d_is		/ and interrupted process SP
	mov	d_sp, sp		/ Restore device process context
	rts	pc			/ Reenter device process.
d_ea:
/
/ Bit table
/
b:	1;2;4;10;20;40;100;200;400
	1000;2000;4000;10000;20000;40000;100000
/
/ Trap vector values for PC and PS
/
trps:		tobe; 340		/ Time-out, bus error
		rein; 340		/ Reserved instruction
		send; 340		/ BPT
		waitop; 340		/ IOT
		pwrf; 340		/ Power fail
		dwai; 340		/ EMT
		dsen; 340		/ TRAP
		0
/
/ Sundry trap entries
/
pwrf:	mov	$pwru, *$24		/ Power fail
tobe:	halt				/ Time out
rein:	halt				/ Reserved instruction
/
/ Error stops
/
corerr:	halt
/
/ Power-up, restart entry
/
pwru:
/
/ Nucleus entry point
/
nucl:	reset				/ reset everything
	mov	$g-gstart, r0		/ Set size of global area
        asr     r0
	mov	$gstart, r1		/ Set number of words
1:	dec	r0			/ Loop around clearing
	blt	2f			/ every item of global
	clr	(r1)+			/ storage so that program
	br	1b			/ may be restarted
2:	mov	$corend-pdsize, sp	/ Allocate global PD
	mov	sp, pp			/ Set up global PD
	mov	pp, p.pc(pp)		/ Init process chain
	clr	p.st(pp)		/ Mark active
	mov	$trps, r0		/ Get initial trap values
	mov	$4, r1			/ Start at address 4
3:	mov	(r0)+, (r1)+		/ Plug trap vector
	bne	3b			/ stop on zero
	.if notlsi
	clr	*$ps			/ Just in case.
	.endif
	.if notlsi-1
	mtps	$0			/ and for the LSI11!
	.endif
	jmp	init			/ Enter program
/
/ Call device process:
/	R0 = start address
/	R1 = stack size
/ Calling sequence:
/	JSR	PC, DCAL
/
dcal:					/ Allocate process stack
	mov	sp, r4			/ Remember old stack
	sub	r1, sp			/ Allocate stack
	sub	$100, sp		/ and safety gap
	clr	-(sp)			/ Make new callers stack
	mov	(r4)+, -(sp)		/ With PS and PC
	cmp	sp, $nucend+100+gdyn	/ Out of Core?
	blos	corerr			/ yes, then die
	mov	$d_ea, r1		/ Now copy down interrupt
1:	mov	-(r1), -(r4)		/ template code into top
	cmp	r1, $d_in		/ of PD
	bne	1b
	sub	$pdsize, r4		/ Allocate new PD
	mov	r4, r1			/ Set up new stack,
	clr	-(r4)			/ with PS
	mov	r0, -(r4)		/ and PC
	mov	r4, (r1)		/ mark new stack in new PD
	mov	$-1, p.st(r1)		/ Mark as device process
	clr	p.sc(r1)		/ Init signal chain
	br	dcon			/ Enter the process
/
/ Call ordinary process
/	R0 = start address
/	R1 = stack size
/ Calling sequence
/	JSR	PC, PCAL
/
pcal:					/ Allocate process stack
	mov	sp, r4			/ Remember old stack
	sub	r1, sp			/ Allocate stack
	sub	$100, sp		/ and safety gap
	clr	-(sp)			/ Make new callers stack
	mov	(r4)+, -(sp)		/ With PS and PC
	cmp	sp, $nucend+100+gdyn	/ Out of core?
	blos	corerr			/ yes, then die
	sub	$pdsize, r4		/ Allocate new PD
	mov	r4, r1			/ set up new stack
	clr	-(r4)			/ PS
	mov	r0, -(r4)		/ PC
	mov	r4, (r1)		/ Mark SP in new PD
	mov	p.pc(pp), p.pc(r1)	/ Link into process chain
	mov	r1, p.pc(pp)		/ after calling process
	clr	p.sc(r1)		/ Init signal chain
	br	cont			/ Start process
/
/ Send by a device process
/	R0 = queue
/ Called by
/	TRAP
/
dsen:	mov	(r0), r1		/ Get head of chain
	beq	1f			/ exit if empty
	mov	p.sc(r1), (r0)		/ Unlink head of chain
	clr	p.st(r1)		/ Mark as active
1:	rti
/
/ Wait by device process
/	R0 = queue
/	R1 = PD
/ Called by
/	EMT	0
/
dwai:	mov	(r0), p.sc(r1)		/ Insert at head
	mov	r1, (r0)		/ of signal queue
/
/ Doio
/	R1 = PD
/ Called by
/	JSR	PC, DOIO
/
doio:
/
/ Exit device process
/	R1 = PD of caller
/ Called by:
/	JMP	DEXI
/
dexi:	mov	sp, (r1)		/ Save callers context
	mov	p.is(r1), sp		/ Restore interrupted context
	mov	(sp)+, r1		/ Restore saved regs
	mov	(sp)+, r0		/ of interrupted process
	rti				/ and resume it.
/
/ Wait (ordinary process)
/ 	R0 = queue
/	R1 = priority
/ Called by:
/	IOT
/
waitop:	mov	(r0), r2		/ look at next in queue
	beq	1f			/ Nonexistent ?
	cmp	r1, p.st(r2)		/ Is it higher prio?
	blt	1f			/ Yes, insert here
	mov	r2, r0			/ No, move along chain
	add	$p.sc, r0		/ and try next process
	br	waitop
1:	mov	(r0), p.sc(pp)		/ Link into signal chain
	mov	pp, (r0)
	mov	r1, p.st(pp)		/ Set status = prio
	.if notlsi
	clr	ps			/ Reallow interrupts
	.endif
	.if notlsi-1
	mtps	$0			/ Reallow interrupts on the LSI11
	.endif
/
/ Find runnable process
/
find:	mov	pp, r1			/ Start with current process
1:	mov	p.pc(r1), r1		/ Move along process chain
	tst	p.st(r1)		/ Runnable?
	bne	1b			/ No, try next one.
	.if notlsi
	bis	$340, ps		/ Disable interrupts
	.endif
	.if notlsi-1
	mtps	$200			/ Disable interrupts on the LSI11
	.endif
	br	cont			/ Continue with new process
/
/ Send (ordinary process)
/	R0 = queue
/ Called by
/	BPT
/
send:	mov	(r0), r1		/ Get head of chain
	beq	contx			/ Nothing, then exit.
	mov	p.sc(r1), (r0)		/ Unlink it
	tst	p.st(r1)		/ Device process ?
	bpl	cont			/ Yes, its different
/
/ Resume device process
/	R1 = new PP
/
dcon:	cmp	-(sp), -(sp)		/ Fake register save.
	mov	sp, p.is(r1)		/ Save callers context
	mov	(r1), sp		/ Restore device process context
	rti				/ Enter device process
/
/ Resume normal process
/
cont:	mov	sp, (pp)		/ Save senders context
	mov	r1, pp			/ Get new context
	mov	(pp), sp		/ restore stack pointer
	clr	p.st(pp)		/ Mark as runnable
contx:	rti				/ and resume process
/
/ Exit process.
/ Called by:
/	JMP	EXIT
/
pexi:	com	p.st(pp)		/ Mark it dead
	br	find			/ and find another
	.if	noteis
/
/ Shift routine
/ 	Result in R0
/
eiss:	tst	r0
	bmi	2f
	beq	4f
1:	asl	r1
	dec	r0
	bne	1b
	br	4f
2:	neg	r0
3:	asr	r1
	dec	r0
	bne	3b
4:	mov	r1, r0
	rts	pc
/
/ Multiply routine
/	Returns R0*R1 in R0
/
eism:	mov	r0, -(sp)
	bpl	1f
	neg	(sp)
	neg	r1
1:	clr	r0
	br	4f
2:	add	r1, r0
3:	asl	r1
4:	clc
	ror	(sp)
	bcs	2b
	bne	3b
	tst	(sp)+
	rts	pc
/
/ Division routine
/	returns r1/r0 in R0,
/	remainder in R1
/
eisd:	mov	r2, -(sp)
	mov	r0, -(sp)
	mov	r1, -(sp)
	bpl	1f
	neg	r1
1:	mov	r0, r2
	bpl	2f
	neg	r2
2:	mov	r2, -(sp)
3:	asl	r2
	bpl	3b
	clc
	ror	r2
	clr	r0
4:	asl	r0
	cmp	r1, r2
	bmi	5f
	inc	r0
	sub	r2, r1
5:	asr	r2
	cmp	r2, (sp)
	bge	4b
	tst	(sp)+
	tst	(sp)+
	bpl	6f
	neg	r0
	neg	r1
6:	tst	(sp)+
	bpl	7f
	neg	r0
7:	mov	(sp)+, r2
	rts	pc


/
/ XOR routine
/   Returns  r0 XOR r1  in r0
/
eisx:
	mov	r2,-(sp)
	mov	r0,r2
	bic	r1,r2
	bic	r0,r1
	bis	r1,r2
	mov	r2,r0
	mov	(sp)+,r2
	rts	pc
/
/ DIV routine
/
eisD:
	jsr	pc,eisd
	tst	r1
	bge	1f
	dec	r0
1:	rts	pc

/
/ MOD routine
/
eisM:
	mov	r0,-(sp)
	jsr	pc,eisd
	tst	r1
	bge	1f
	add	(sp),r1
1:	tst	(sp)+
	rts	pc
/
/

/



	.endif
	.bss
nucend:
