#
#include <local-system>
/* Expand Huffman coded input to
 * Input file format:
 *      PACKED flag defined below (integer)
 *      Number of chars in expanded file (float)
 *      Number of words in expanded tree (integer)
 *      Tree in 'compressed' form:
 *              If 0<=byte<=0376, expand by zero padding to left
 *              If byte=0377, next two bytes for one word
 *          Terminal nodes: First word is zero; second is character
 *          Non-terminal nodes: Incremental 0/1 pointers
 *      Code string for number of characters in expanded file
 */
struct iobuf
{       int fildes;
	int nleft;
	char *nextp;
	char buf[512];
} buf, obuf;

struct
{       char minor;
	char major;
	int inumber;
	int flags;
	char nlinks;
	char uid;
	char gid;
	char size0;
	int size1;
	int addr[8];
	int actime[2];
	int modtime[2];
} status;

extern errno;
#define LNAME  80
#define PACKED 017437 /* <US><US> - Unlikely value */

#ifndef FPT
long size;
#endif FPT
#ifdef FPT
float size;
#endif FPT
struct {int hi, lo;};
int tree[1024];

main(argc, argv)
int argc; char *argv[];
{       register int i, k, *t;
	int sep, keysize;
	char filename[LNAME], *cp;
/**/ int *u;

	for (k = 1; k<argc; k++)
	{       sep = -1;  cp = filename;
		for (i=0; i < (LNAME-3) && (*cp = argv[k][i]); i++)
			if (*cp++ == '/') sep = i;
		if (cp[-1]=='p' && cp[-2]=='.')
		{       argv[k][i-2] = '\0'; /* Remove .p and try again */
			k--;
			continue;
		}

		if (i >= (LNAME-3) || (i-sep) > 13)
		{       printf ("File name too long -- %s\n",argv[k]);
			continue;
		}
		*cp++ = '.';  *cp++ = 'p';  *cp = '\0';
		if (fopen(filename,&buf) < 0)
		{       printf ("Unable to open %s\n", filename);
			continue;
		}

		if (fcreat(argv[k],&obuf) == -1)
		{       printf ("Unable to create %s\n", argv[k]);
			close(buf.fildes);
			continue;
		}

		fstat(buf.fildes,&status);
		chmod(argv[k],status.flags&07777);
  chown(argv[k],(status.gid<<8)|status.uid); /* IAN J Jan '77 */
		errno = 0;

		if (getw(&buf) != PACKED) goto err;
		size.hi = getw(&buf);
		size.lo = getw(&buf);
		t = tree;
		for (keysize = getw(&buf); keysize--; )
		{       if ((i = getc(&buf)) == 0377)
				*t++ = getw(&buf);
			else
				*t++ = i;
		}
/**//* for (u=tree; u<t; u++ ) printf("%4d: %6d  <%3o> %c\n",   */
/**//*            u-tree, *u, *u&0377, *u);                     */

		expand();

		if (errno == 0)
		{       fflush(&obuf);
			unlink(filename);
		}
		else
     err:       {       printf ("Unable to unpack %s\n", filename);
			unlink(argv[k]);
		}
		close(obuf.fildes);
		close(buf.fildes);
	}
}

expand()
{       register int tp, bit, word;

	bit = tp = 0;
	for (;;)
	{       if (bit == 0)
		{       word = getw(&buf);
			bit = 16;
		}
		tp =+ tree[tp + (word<0)];
		word =<< 1;  bit--;
		if (tree[tp] == 0)
		{       putc(tree[tp+1],&obuf);
			tp = 0;
#ifndef FPT
			if ((size =- 1) == 0) return;
#endif FPT
#ifdef FPT
			if ((size =- 1.0) == 0) return;
#endif FPT
		}
	}
}
