#
/* general nonsense overlay program
 * J. N. Rottman
 */


int	ofile;			/*overlay descriptor file */
int	ovfile;			/*overlay output file */
int	blkpnt	0;		/*current block pointer in overlay file */
int	rempnt	0;		/*current rem pointer in file */
char	root[30];		/*name of root file (without extension) */
char	ovn[25][30];		/*overlay file names */

struct	otable	{
	int	oblk;
	int	orem;
	int	ocnt;
} otable[25];

struct	otable	*opnt otable;

int	msize	0;		/* max size of overlay region */
int	rootsize;		/* size of root */
int	bflag 0;

main(argc,argv)
int argc;
char *argv[];
{
	int	i,nov;
	if(argc==3) {
		bflag++;
		argc--;
	}

	if(argc != 2)
		ferror("Arg count");
	ofile = open(argv[1],0);
	if(ofile == -1)
		ferror("Cannot open descriptor file");

	readln(root);

	nov = 0;

	while(readln(ovn[nov]))
		nov++;

	ovfile=creat("ov.out",0644);

	if(ovfile == -1)
		ferror("Cannot create output file");

	sizeroot();
	for(i = 0; i < nov; i++)
		linkit(i);

	maktab();

	close(ovfile);
	close(ofile);
}
ferror(s)
char *s;
{
	printf("%s\n",s);
	close(ovfile);
	unlink("ov.out");
	exit(1);
}

readln(s)
char *s;
{
	register char *s1;
	register int bc;
	char	cc;
	s1=s;
	while((bc=read(ofile,&cc,1)) && cc != '\n')
		*s1++ = cc;
	*s1 = '\0';
	return(bc);
}

linkit(i)
int i;
{
	extern int ldivr;
	register int size;
	int k,magic[8];
	extern int ldivr;

	callsys(2,"../link",root,ovn[i]);

	k = open(ext(root,".out"),0);

	if(k == -1)
		ferror("Cannot open object");

	read(k,magic,16);
	if(magic[0] != 0407)
		ferror("Not magic");
	if(magic[1] != 0)
		ferror("Not null text");
	if(magic[3] != 0)
		ferror("Not null bss");

	/* set up descriptor in otable */


	size = magic[2] - rootsize;

	seek(k,rootsize,1);

	opnt->oblk = blkpnt;
	opnt->orem = rempnt;
	opnt->ocnt = size;
	
	tran(k,ovfile,size);

	close(k);

	msize = max(size,msize);
	size = ldiv(0,size,512);
	blkpnt =+ size;
	rempnt =+ ldivr;
	if(rempnt >= 512) {
		rempnt =- 512;
		blkpnt++;
	}
	if(bflag&&rempnt) {
		blkpnt++;
		rempnt=0;
	}
	opnt++;
}

tran(in,out,count)
{
	char	buffer[512];
	int	block,remn;
	extern	ldivr;

	block = ldiv(0,count,512);
	remn  = ldivr;

	while(block--) {
		read(in,buffer,512);
		write(out,buffer,512);
	}
	if(remn) {
		read(in,buffer,remn);
		write(out,buffer,(bflag ? 512 : remn));
	}
}

ext(s1,s2)
char *s1,*s2;
{
	static	char	s3[50];
	register char	*r1,*r2,*r3;

	r1 = s1;
	r2 = s2;
	r3 = s3;

	while(*r3 = *r1++) r3++;
	while(*r3++ = *r2++);
	return(s3);
}

sizeroot()
{
	int	rfile,magic[8];
	callsys(1,"../link",root);
	rfile = open(ext(root,".out"));
	if(rfile == -1)
		ferror("Cannot open root file");
	read(rfile,magic,16);
	if(magic[0] != 0407)
		ferror("Root not magic");
	if(magic[1] != 0)
		ferror("Non-null root text");
	if(magic[3])
		ferror("Non-null root bss");
	rootsize = magic[2];
	close(rfile);
}
callsys(n,s1,s2,s3)
int n;
char *s1,*s2,*s3;
{
	int	d;
	d = fork();
	if(d==0) {
		if(n=2)
			execl(s1,s1,s2,s3,0);
		else
			execl(s1,s1,s2,0);
		ferror("Bad fork");
	} else
		wait(&d);
}


max(a,b)
{
	return(a>b? a : b);
}

maktab()
{
	register	struct	otable	*op;
	register	int	k;
	extern		int	fout;

	k = creat("otable.m11",0644);
	if(k == -1)
		ferror("Cannot create otable");
	fout = k;
	printf("\n\n\t.title\totable\n\t.psect\totable,ovr\n");
	
	for(op = otable; op < opnt; op++) 
		printf("\t.word\t%o,%o,%o\n",
			op->oblk,
			op->orem,
			op->ocnt);

	printf("\n\n\t.psect\tobuff,con\n");
	printf("\t.blkb\t%o\n",msize);
	printf("\n\t.end\n");

	flush();

	fout = 1;

	close(k);
	callsys(2,"../macro","-xs:10","otable.m11");
	callsys(2,"../link",root,"otable");
}
