#
#include "libr.h"
getcmd()
{
	register char *s;
	s = getitem(COMMAND);
	if(s == NIL)
		return(s);
	if(*s++ != '-') {
		printf("%s",--s);
		ferror(": expecting command");
	}
	switch(*s++) {
	
	case 'g':	return(GLOBAL);
	case 'd':	return(DELETE);
	case 'i':	return(INSERT);
	case 'r':	return(REPLACE);
	case 'a':	return(APPEND);
	case 'l':	return(LIST);
	case 'c':	return(CREF);
	default:	printf("%s",s-2);
			ferror(": unrecognized command");

	}
}

int *getarg()
{
	register char *s;
	static int radraw[2];
	register int r50;
	int cc;
	int w;
	char c,*ss;

	ss = s = getitem(ARGUMENT);

	if(s == NIL)
		return(NIL);

	w = 0;
	do {
		r50 = 0;
		cc = 3;
		do {
			c = *s++;
			r50 =* 050;
			if( c == 0) {
				--s;
				continue;
			}
			if(c == ' ')
				continue;
			if(c >= 'a' && c <= 'z') {
				r50 =+ c - 'a' + 1;
				continue;
			}
			if(c == '$') {
				r50 =+ 27;
				continue;
			}
			if(c == '.') {
				r50 =+ 28;
				continue;
			}
			if(c >= '0' && c <= '9') {
				r50 =+ c - '0' + 30;
				continue;
			}
			printf("%s",ss);
			ferror(": bad radix 50");
		} while(--cc);
		radraw[w++] = r50;
	} while(w < 2);
	return(radraw);
}

struct file *getfile()
{
	register char *s1,*s2;
	register int cc;
	struct file *fp;
	s1 = getitem(ARGUMENT);
	if(s1 == NIL)
		return(NIL);
	fp = getcore(S_FILE);
	s2 = fp->fn;
	cc = 64;
	while(cc-- && *s1)
		*s2++ = *s1++;
	*s2++ = 0;
	return(fp);
}

char *getcore(n)
{
	register char *s;
	while(memlow + n >= memhigh) {
		if(sbrk(GOBBLE) == -1 ) 
			ferror("Core allocation failure");
		memhigh =+ GOBBLE;
	}
	s = memlow;
	memlow =+ n;
	return(s);
}

getrec(bpp)
struct buf *bpp;
{
	register struct buf *bp;
	int c;

	bp = bpp;
	c = 0;
	while(movb(bp,&c,1) && c == 0);
	if(c == NIL)
		return(NIL);
	movb(bp,&c,1);
	movb(bp,&bcount,2);
	movb(bp,&c,2);
	bcount =- 6;
	movb(bp,binbuf,bcount + 1);
	bpoint = binbuf;
	return(c);
}

getgsd()
{
	register char *r1,*r2;
	register int r3;
	if(bcount >= sizeof gsd) {
		r1 = &gsd;
		r2 = bpoint;
		r3 = sizeof gsd;
		do
			*r1++ = *r2++;
		while(--r3);
		bpoint =+ sizeof gsd;
		bcount =- sizeof gsd;
		return(gsd.ft);
	}
	return(-1);
}

movb(bpp,cpp,cnt)
struct buf *bpp;
char *cpp;
int cnt;
{
	register char *rw,*rq;
	register struct buf *bp;
	int rc;
	bp = bpp;
	rw = cpp;
	rc = cnt;
l0:	rq = bp->nxtfree;
	if(rc <= bp->nonused) {
		bp->nonused =- rc;
		bp->nxtfree =+ rc;
		do
			*rw++ = *rq++;
		while(--rc);
		return(cnt);
	}
	rc =- bp->nonused;
	while(bp->nonused--)
		*rw++ = *rq++;
	bp->nxtfree = bp->buff;
	bp->nonused = read(bp->fildes,bp->buff,BUFSIZ);
	if(bp->nonused >= rc)
		goto l0;
	return(NIL);
}

pass2()
{
	register struct mod *mm;
	register struct file *fp;
	register struct glist *gx;

	char *cp;
	int gflag;
	int t;

	creato();

	for(mm = command; mm != NIL; mm = mm->mf) {
		fp = mm->mff;
		switch(mm->ma) {

		case ACT_INF:
			fp->fbb = openi(fp);
			if(fp->fbb == -1) {
				fileout(fp);
				ferror(": cannot open?");
			}
			break;

		case ACT_CLS:
			closei(fp->fbb);
			break;

		case ACT_DEL:
			while(getrec(fp->fbb) != EMOD);
			break;

		case ACT_PAS:
			bcount = 0;
			gflag = NIL;
			bpoint = binbuf;
			for(gx = mm->mg; gx != NIL; gx = gx->gf) {
				cp = gx->gn;
				t = 4;
				do
					*bpoint++ = *cp++;
				while(--t);
				bcount =+ 4;
				if(bcount == 32) {
					prtrec(LMOD);
					bcount = 0;
					gflag++;
					bpoint = binbuf;
				}
			}
			if(bcount != 0 || gflag == NIL)
				prtrec(LMOD);
			do {
				t = getrec(fp->fbb);
				if(t != LMOD)
					prtrec(t);
			} while(t != EMOD);
			
			break;

		}
	}
	closeo();
}

creato()
{
	inbuf.fildes = creat("libr1.tmp",0644);
	if(inbuf.fildes == -1)
		ferror("Cannot create temporary file");
	inbuf.nonused = 512;
	inbuf.nxtfree = inbuf.buff;
}

closeo()
{
	fflush(&inbuf);
	close(inbuf.fildes);
	execl("/bin/mv","mv","libr1.tmp",libfile->fn,0);
}

prtrec(t)
int t;
{
	register int cc;
	register char *cp;
	register int chksum;
	cc = bcount;
	cp = binbuf;
	putw(1,&inbuf);
	putw(cc+6,&inbuf);
	putw(t,&inbuf);
	chksum = 1 + 6 + cc + t + cc>>8 + t>>8;
	while(cc--) {
		putc(*cp,&inbuf);
		chksum =+ *cp++;
	}
	putc( -chksum & 0377,&inbuf);
}


crefout()
{
	int	lcount;
	register char *rr1,*rr2,*rr3;
	char	*smemlow;
	char	*c1;
	struct	und	*undlist;
	struct	imp	*implist;


	if(!creff)
		return;

	printf("\n\nCross Reference\n\nModule\tReferences\n\n");
	for(rr1 = command; rr1 != NIL; rr1= rr1->mf)
		if(rr1->ma == ACT_PAS) {
			radixout(rr1->mn);
			putchar('\t');
			lcount = 6;
			for(rr2 = rr1->mr; rr2 != NIL; rr2 = rr2->gf) {
				radixout(rr2->gn);
				putchar('\t');
				if(--lcount == 0) {
					printf("\n\t");
					lcount = 6;
				}
			}
			if(lcount != 6)
				putchar('\n');
			putchar('\n');
		}

	printf("\n\n\nModule\tImplies\n\n");
	smemlow = memlow;

	for(rr1 = command; rr1 != NIL; rr1 = rr1-> mf) 
		if(rr1->ma == ACT_PAS) {
			memlow = smemlow;
			implist = NIL;
			undlist = NIL;
			for(rr2 = rr1->mr; rr2 != NIL; rr2 = rr2->gf)
				switch(c1 = loc(rr1->mf, rr2->gn, implist)) {

				case 0:	rr3 = getcore(4);
					rr3->undg = rr2->gn;
					rr3->undund = undlist;
					undlist = rr3;

				case 1:	break;


				default:	
					rr3 = getcore(4);
					rr3->impmod = c1;
					rr3->impimp = implist;
					implist = rr3;

				}

			radixout(rr1->mn);
			putchar('\t');
			rlout(implist);
			if(undlist) {
				printf("\nundef:\t");
				rlout(undlist);
			}
			printf("\n\n");
		}

	memlow = smemlow;
	for(rr1 = memlow; rr1 < memhigh; *rr1++ = 0);
}

char *loc(modp, namp, impp)
struct mod *modp;
struct imp *impp;
int *namp;
{
	register char *rr1,*rr2,*rr3;

	rr2 = namp;
	for(rr1 = modp; rr1 != NIL; rr1 = rr1->mf)
		if(rr1->ma = ACT_PAS)
			for(rr3 = rr1->mg; rr3 != NIL; rr3 = rr3->gf)
				if(req(rr3->gn,rr2)) {
					for(rr3 = impp; rr3 != NIL; rr3 = rr3->impimp)
						if(req(rr3->impmod,rr1->mn))
							return(1);
					return(rr1->mn);
				}

	return(0);
}


rlout(ll)
struct und *ll;
{
	register char *rr1;
	register int rc;

	rc = 6;
	for(rr1 = ll; rr1 != NIL; rr1 = rr1->undund) {
		radixout(rr1->undg);
		putchar('\t');
		if(--rc == 0) {
			printf("\n\t");
			rc = 6;
		}
	}

	if(rc != 6)
		putchar('\n');
}

