#

/*
 *	TRANSFORMATION MODULE OF GPAC
 */

#include "../gpac.h"
#include "../error_codes.h"

screentouser(ix, iy, ax, ay)
	int ix, iy;
	double *ax, *ay;
	{
	double x, y;
	double det, t;

	x = (ix-Gvcx)*Gwsx/Gvsx+Gwcx;
	y = (iy-Gvcy)*Gwsy/Gvsy+Gwcy;
	det = Gctma*Gctme-Gctmb*Gctmd;
	t = (Gctme*x-Gctmb*y+(Gctmb*Gctmf-Gctmc*Gctme))/det;
	*ay = (-Gctmd*x+Gctma*y-(Gctma*Gctmf-Gctmc*Gctmd))/det;
	*ax = t;
	GOOD_RETURN;
	}
