#

/*
 *	TRANSFORMATION MODULE OF GPAC
 */

#include "../gpac.h"
#include "../error_codes.h"

pushmat()
	{
	register i;

	if((i = alloc(sizeof *Gctm_sp)) == -1)
		return(Gerror(ALLOC_ERR, "pushmat"));
	i->nxt_ctm = Gctm_sp;
	Gctm_sp = i;
	Gctm_sp->a = Gctma;
	Gctm_sp->b = Gctmb;
	Gctm_sp->c = Gctmc;
	Gctm_sp->d = Gctmd;
	Gctm_sp->e = Gctme;
	Gctm_sp->f = Gctmf;
	Gctm_sp->ctm_mod = Gctm_mod;
	GOOD_RETURN;
	}


popmat()
	{
	register i;

	if(Gctm_sp == 0)
		return(Gerror(POP_EMPTY, "popmat"));
	Gctm_pu++;
	Gctma = Gctm_sp->a;
	Gctmb = Gctm_sp->b;
	Gctmc = Gctm_sp->c;
	Gctmd = Gctm_sp->d;
	Gctme = Gctm_sp->e;
	Gctmf = Gctm_sp->f;
	Gctm_mod = Gctm_sp->ctm_mod;
	i = Gctm_sp->nxt_ctm;
	free(Gctm_sp);
	Gctm_sp = i;
	GOOD_RETURN;
	}


initmat()
	{
	register i;

	Gctma = Gctme = 1.0;
	Gctmb = Gctmc = Gctmd = Gctmf = 0.0;
	while(Gctm_sp != 0)
		{
		i = Gctm_sp->nxt_ctm;
		free(Gctm_sp);
		Gctm_sp = i;
		}
	Gctm_mod = 0;
	GOOD_RETURN;
	}
