#

	/*
	 *	GPAC Interp CHARS routine
	 */

#include "../gpac.h"
#include "../error_codes.h"
#define MAGIC_FONT_NUMBER	0407
#define CONTROL_FLAG 	0210
#define TERMINATE	0210
#define TERM1	0
#define	ION	1
#define	IOFF	2
#define	ICOM	3
#define	IOF1	4
#define	IOF2	5
#define	IOF3	6
#define	IALT	7
ichars(string)
	char *string;
{
	char c, byte;
	char cbuff[50];
	char *str;
	double dx, dy;
	register unblank, alternate, ifdes;
	int blankdur, addr;

	if((ifdes = open(Gconcat(cbuff, "/usr/font/", Gfont), 0)) < 0)
		return(Gerror(OPEN_ERR, Gfont));
	str = string;
	while((c = *str++) != '\0')
	{
		alternate = blankdur = 0;
		unblank = 1;
		seek(ifdes,16,0);
		seek(ifdes,2*c,1);
		read(ifdes,&addr,2);
		seek(ifdes,addr - 2*(c+1),1);
		while(read(ifdes,&byte,1)==1 && (byte & 0377) != 0200 && (byte & 0377) != TERMINATE
			&& byte != 0177600)
		{
			if((byte & 0370) == CONTROL_FLAG)
			{
				switch(byte & 07)
				{
					case TERM1:
						break;
					case ION:
						alternate = 0;
						unblank = 1;
						break;
					case IOFF:
						alternate = 0;
						unblank = 0;
						blankdur = 0;
						break;
					case ICOM:
						alternate = 0;
						unblank = !unblank;
						blankdur = 0;
						break;
					case IOF1:
						alternate = 0;
						unblank = 0;
						blankdur = 1;
						break;
					case IOF2:
						alternate = 0;
						unblank = 0;
						blankdur = 2;
						break;
					case IOF3:
						alternate = 0;
						unblank = 0;
						blankdur = 3;
						break;
					case IALT:
						unblank = 0;
						blankdur = 0;
						alternate = 1;
						break;
					default:
						break;
				}
			}
			else
			{
				dx = ((byte<<8)>>12);
				dy = ((byte<<12)>>12);
				if(unblank)
				{
					if(byte!=0)
					{
						line(dx, dy);
					}
				}
				else
				{
					move(dx, dy);
					if(--blankdur == 0)
						unblank = 1;
				}
				if(alternate)
					unblank = !unblank;
			}
		}
	}
	close(ifdes);
}


Gconcat(addr, st1, st2)
	char *addr, *st1, *st2;
	{
	register char *a, *s1, *s2;

	a = addr;
	s1 = st1;
	s2 = st2;
	while(*s1)
		*a++ = *s1++;
	while(*s2)
		*a++ = *s2++;
	*a++ = '\0';
	return(addr);
	}
