#


	/*
	 * FILM ROUTINES OF GPAC
	 */


#include "../gpac.h"
#include "../error_codes.h"

#define PLAYBACK_FILE "/dev/playback"
#define GW 0
#define GW_TERM 0100000
#define MAGIC_FILM_NUM 0422


struct film
	{
	int ffd;
	int nframeblks;
	int curr_frame;
	int duration;
	int startframeblk;
	int lastsfb;
	char *font;
	int *frame_buf;
	int *frame_ptr;
	int once_thru;
	} Gfilm;


beginfilm(film_file)
	char *film_file;
	{
	register i;

	if(film_file == 0)
		film_file = PLAYBACK_FILE;	/*  default if pointer is zero  */
	if((Gfilm.ffd = creat(film_file, 0766)) < 0)
		return(Gerror(OPEN_ERR, "beginfilm", film_file));
	Gfilm.curr_frame = 0;
	Gfilm.nframeblks = 0;
	Gfilm.startframeblk = 0;
	Gfilm.lastsfb = 0;
	Gfilm.font = Gfont;
	if((i = alloc(512)) == -1)
		return(Gerror(ALLOC_ERR, "beginfilm"));
	Gfilm.frame_ptr = Gfilm.frame_buf = i;
	Gfilm.once_thru = 0;
	GOOD_RETURN;
	}


frame(duration)
	int duration;
	{

	if(Gfilm.once_thru)
		Gfilm_term();	/*  Device dependent frame terminator  */
	if(Gfilm.frame_buf != Gfilm.frame_ptr)
		{
		seek(Gfilm.ffd, Gfilm.nframeblks++, 3);
		if(write(Gfilm.ffd, Gfilm.frame_buf, 512) < 512)
			{
			Gerror(FILM_WRITEERR);
			exit();
			}
		Gfilm.frame_ptr = Gfilm.frame_buf;
		}
	if(Gfilm.once_thru)
		Gsize_update(Gfilm.nframeblks-Gfilm.startframeblks, duration);
	Gfilm.curr_frame =+ Gfilm.duration;
	if(duration < 0)
		return(Gerror(FRAME_NEGDURERR, duration));
	Gfilm.duration = duration;
	Gfilm.startframeblk = Gfilm.nframeblks;
	Gcopy_header();
	Gfilm.once_thru++;
	return(Gfilm.curr_frame);
	}

include(n)
	int n;
	{
	register *ptr, *next_seg;
	register i;

	valid_segment;
	i = n;
	if(Gseg_table[i].start_address)
		{
		next_seg = Gnxt_seg(Gseg_table[i].end_address);
		ptr = Gseg_table[i].start_address;
		do
			{
			Gblk_copy(ptr);
			ptr = Gnxt_blk(ptr);
			}  while(ptr != next_seg);
		GOOD_RETURN;
		}
	   else
		return(Gerror(NOEXIST_ERR, "include", n));
	}


Gframe_insert(code)
	int code;
	{

	*Gfilm.frame_ptr++ = code;
	if(Gfilm.frame_ptr >= Gfilm.frame_buf+256)
		{
		seek(Gfilm.ffd, Gfilm.nframeblks++, 3);
		if(write(Gfilm.ffd, Gfilm.frame_buf, 512) < 512)
			{
			Gerror(FILM_WRITEERR);
			exit();
			}
		Gfilm.frame_ptr = Gfilm.frame_buf;
		}
	}


endfilm()
	{

	frame(1);	/* write out current frame   */
	close(Gfilm.ffd);
	free(Gfilm.frame_buf);
	return(Gfilm.curr_frame);
	}


Gsize_update(size, ndur)
	char size;
	int ndur;
	{

	seek(Gfilm.ffd, Gfilm.startframeblk, 3);
	seek(Gfilm.ffd, 6, 1);
	write(Gfilm.ffd, &ndur, 2);
	write(Gfilm.ffd, &size, 2);	/*  next size is zero  */
	if(Gfilm.once_thru > 1)
		{
		seek(Gfilm.ffd, Gfilm.lastsfb, 3);
		seek(Gfilm.ffd, 9, 1);
		write(Gfilm.ffd, &size, 1);
		Gfilm.lastsfb = Gfilm.startframeblk;
		}
	}


Gcopy_header()
	{
	register i;
	register j;

	Gframe_insert(MAGIC_FILM_NUM);
	Gframe_insert(Gfilm.curr_frame);
	Gframe_insert(Gfilm.duration);
	Gframe_insert(Gfilm.duration);
	Gframe_insert(0);		/*  dont know size yet  */
	for(j = 0; j < 2; j++)
		for(i = 0; i < 7; i++)
			Gframe_insert(Gfilm.font[2*i] | (Gfilm.font[2*i+1]<<8));
	}
