#

	/*
	 *	TECKTRONICS DAEMON
	 */


#define cycle for(;;)

#define NOP 0
#define SET_VALUE 1
#define SET_COLOUR_THICK 2
#define ESCAPE 7

#define END_OF_DATA 0
#define UPDATE 8
#define CLEAR_SCREEN 2
#define SET_RGB 3
#define CHARACTERS 4
#define SET_FONT 5
#define CLEAR_VIEWPORT 1
#define INPUT_TEK_COMMAND 14
#define ERROR 15

#define ENTER_GRAPH 035
#define ENTER_ALPHA 037
#define FINISH 015
#define ENTER_GIN1 033
#define ENTER_GIN2 032
#define CLEAR1 033
#define CLEAR2 014

#define HIY 040
#define LOY 0140
#define HIX 040
#define LOX 0100

#define STANDARD_FORMAT_MAGIC_NUMBER 046033

int xabs, yabs;
char lhiy, lloy, lhix, llox;

main()
	{
	register w1, w2, args;

	if(getw() != STANDARD_FORMAT_MAGIC_NUMBER)
		exit();
	initialize();
	cycle
		switch(((w1 = getw())>>12) & 07)
			{
			case NOP :
			case SET_VALUE :
				w2 = getw();
				mlto(w1, w2);
				break;
			case SET_COLOUR_THICK :
				break;
			case ESCAPE :
				switch((w1>>8)&017)
					{
					case END_OF_DATA :
						finish();
						exit();
					case UPDATE :
						putchar(ENTER_ALPHA);
						putchar('\n');
						break;
					case CLEAR_SCREEN :
						clear();
						break;
					case SET_RGB :
						break;
					case CHARACTERS :
						putchar(ENTER_ALPHA);
						args = w1 & 0377;
						for(w1 = 0; w1 < args; w1++)
							{
							w2 = getw();
							putchar(w2&0377);
							putchar((w2>>8) & 0377);
							}
						moveto(xabs, yabs);
						break;
					case CLEAR_VIEWPORT :
					case SET_FONT :
						args = w1&0377;
						for(w1 = 0; w1 < args; w1++)
							getw();
						break;
					case INPUT_TEK_COMMAND :
						input();
						while(((getw()>>8) & 017) != INPUT_TEK_COMMAND);
						lhix = lhiy = -1;
						moveto(xabs, yabs);
					}
			}
	}


mlto(word1, word2)
	int word1, word2;
	{
	register x, y;

	x = (word1 & 01777);
	y = (word2 & 01777);
	if(y > 779)
		y = 779;
	if(x == xabs && y == yabs)
		return;
	if(word1 < 0)
		moveto(x, y);
	   else
		lineto(x, y);
	}


moveto(x, y)
	int x, y;
	{

	putchar(ENTER_GRAPH);
	lineto(x, y);
	}


lineto(x, y)
	int x, y;
	{
	register hix, hiy;
	register codes;
	int loy, lox;

	hix = (x>>5) | HIX;
	hiy = (y>>5) | HIY;
	lox = (x&037) | LOX;
	loy = (y&037) | LOY;
	codes = 0;
	if(hix != lhix)
		codes =| 016;
	if(hiy != lhiy)
		codes =| 01;
	if(lox != llox)
		codes =| 010;
	if(loy != lloy)
		codes =| 012;
	if(codes&01)
		putchar(hiy);
	if(codes&02)
		putchar(loy);
	if(codes&04)
		putchar(hix);
	if(codes&010)
		putchar(lox);
	if(!codes)
		putchar(lox);
	lhiy = hiy;
	lloy = loy;
	lhix = hix;
	llox = lox;
	xabs = x;
	yabs = y;
	}


input()
	{

	putchar(ENTER_GIN1);
	putchar(ENTER_GIN2);
	}


finish()
	{

	putchar(FINISH);
	}


clear()
	{

	putchar(CLEAR1);
	putchar(CLEAR2);
	sleep(3);
	moveto(0, 0);
	}


getw()
	{
	int buf;
	

	if(read(0, &buf, 2) != 2)
		{
		finish();
		exit();
		}
	return(buf);
	}


extern int fout;

initialize()
	{

	close(1);
	close(2);
	fout = open("/dev/tty", 2);
	clear();
	}
