#

	/*
	 *	GPAC TEK ROUTINES
	 */


#include "../gpac.h"
#include "../error_codes.h"
#include "tek.h"

displace(n, dx, dy)
	int n;
	double dx, dy;
	{
	double ax, ay;
	register *a;

	valid_segment;
	if(Gseg_table[n].start_address)
		{
		a = Gseg_table[n].start_address+1;	
		while((*a & 0170000) != 0100000)
			a++;
		screentouser((*a & 07777)>>2, (*(a+1) & 07777)>>2, &ax, &ay);
		reposition(n, ax+dx, ay+dy);
		}
	   else
		return(Gerror(NOEXIST_ERR, "displace", n));
	GOOD_RETURN;
	}


reposition(n, x, y)
	int n;
	double x, y;
	{
	register dx, dy;
	register *a;
	int *addr, *nxt_seg;
	int mode, charc;

	valid_segment;
	if(Gseg_table[n].start_address)
		{
		if(Gctm_mod)
			Gctm_trans(&x, &y);
		if(Gwv_mod)
			Gwv_trans(&x, &y);
		a = addr = Gseg_table[n].start_address;
		a++;
		while((*a & 0170000) != 0100000)	/*  Search for a moveto  */
			a++;
		dx = x*4-(*a & 07777);
		dy = y*4-(*(a+1));
		nxt_seg = Gnxt_seg(Gseg_table[n].end_address);
		mode = MLTO;
		do
			{
			for(a = addr+1; *a != TERM; a++)
				if(mode == CHAR)
					{
					if((charc =- 2) <= 0)
						mode = MLTO;
					}
				   else
					if((*a & 0177400) == CHARACTER_COMMAND)
						{
						goto out;
/*
 *	Well folks to make the bugs the same in both versions
 *		only up to the first character string will be repositioned.
						mode = CHAR;
						charc = (*a & 0377) << 1;
*/
						}
					   else
						{
						*a = ((*a & 07777) + dx) | (*a & 0170000);
						*(++a) =+ dy;
						}
			} while((addr = Gnxt_blk(addr)) != nxt_seg);
	out :
		Gpda_table[n] =| UPDATABLE;
		GOOD_RETURN;
		}
	   else
		return(Gerror(NOEXIST_ERR, "reposition", n));
	}
