#

	/*
	 *	GPAC TABLET GW ROUTINES
	 */


#include "../gpac.h"
#include "../error_codes.h"
#include "tab.h"
#include "tek.h"

#define STOP 0
#define START 1

ink()
	{
	register err_flag;
	register struct event *rep;
	register state;

again :
	Gcodep = Gtablet.buf_addr+1;
	Gblksize = Gtablet.curr_ink_size;
	clearink();
	state = STOP;
	while((rep = Ginput())->status != '3' && Gblksize >= 3)
		switch(rep->status)
			{
		   case '1' :
			Gadd_queue(BPOINT, rep->x, rep->y);
			Gflushout();
			state = START;
			break;
		   case '2' :
			Gevent.type = INKING;
			goto again;
		   case 'z' :
			if(state == START)
				{
				Gadd_queue(VECTOR, rep->x, rep->y);
				Gflushout();
				break;
				}
			}
	if(Gdissa_ink() == ERROR)
		ERROR_RETURN;	
	Gevent.type = INKING;
	return(&Gevent);
	}


Gflushout()
	{

	Ggenerate(Gq_ptr);
	Glhix = Glhiy = -1;
	Gtekmoveto(Gtxabs, Gtyabs);
	Gtekout(*(Gcodep-2));
	Gtekout(*(Gcodep-1));
	}
