#
/*
 | Definitions for the
 |     VT-11 Graphic Scope
 */

/*
 | this structured is initialized/modified by
 | the vt-11 driver.
 */
struct DFILE {
	char v_stat;	/* status */
	char v_flag;	/* flags */
	int  v_ptr;	/* rel. addr of error or
			   light pen hit. */
	int  v_xpos;	/* light pen hit: x position */
	int  v_ypos;	/*   "    "   "   y     "    */
	int  v_subn;	/*   "    "   "   subroutine nbr */
	int  v_addr;	/* real address of disp. file */
	int  v_start;	/* start of display file proper */
	int  v_size;	/* size (bytes) of disp. file */
			/* the display file
			 | starts here.
			 */
};

struct dfdata {
	int f_fdesc;	/* vt file descriptor */
	int f_sda;	/* virtual (user mode) address of the
			   shared data area */
	int f_rfile;	/* real address of the d file */
	int *f_file;	/* virtual address of the d file */
	int *f_lwa;	/* last word address of display file */
} dfdata;

#define Isync (dfdata.f_lwa-3)	/* address of d_sync */
#define ISYNC (dfdata.f_lwa-2)	/* address of d_SYNC */
#define IJUMP (dfdata.f_lwa-1)	/* address of d_jump at the
				   end of the d file */
#define Iaddr (dfdata.f_lwa)

/*
 | Set graphic mode
 */

#define d_char     0100000             /* character mode */
#define d_shortv   0104000             /* short vector mode */
#define d_longv    0110000             /* long vector mode */
#define d_point    0114000             /* point mode */
#define d_graphx   0120000             /* graphplot X mode */
#define d_graphy   0124000             /* graphplot Y mode */
#define d_relatv   0130000             /* relative point mode */

#define            d_int0    02000     /* intensity 0(dimmest) */
#define            d_int1    02200     /*     " 1 */
#define            d_int2    02400     /*     " 2 */
#define            d_int3    02600     /*     " 3 */
#define            d_int4    03000     /*     " 4 */
#define            d_int5    03200     /*     " 5 */
#define            d_int6    03400     /*     " 6 */
#define            d_int7    03600     /*     " 7 (brightest) */

#define            d_lpoff   0100      /* light pen off */
#define            d_lpon    0140      /* light pen on */

#define            d_blkoff  020       /* blink off */
#define            d_blkon   030       /* blink on */

#define            d_line0   04        /* solid line */
#define            d_line1   05        /* long dash */
#define            d_line2   06        /* short dash */
#define            d_line3   07        /* dot dash */

#define d_JUMP     0160000        /* absolute jump
                                   |   .+2 --> absolute address
                                   */
#define d_dnop     0164000        /* display no operation */

#define d_statsa   0170000        /* load status reg. A */
#define d_SYNC     0170004        /* sync with line freq. */
#define d_stop     0173400        /* display stop and interrupt */

/*
 | vers. 6.6 -- unix interfacing commands
 */
#define d_sync     d_stop         /* syncronize with user */
#define d_retn     (d_stop|01)    /* return from subroutine */
#define d_halt     (d_stop|02)    /* halt the dpu */
#define d_call     (d_stop|010)   /* display subroutine call
                                   |   .+2 --> subroutine #
                                   |   .+2 --> relative addr. see note
                                   */
#define d_jump     (d_stop|011)   /* display jump
                                   |   .+2 --> relative addr. see note
                                   */
/* note
 | absolute address =
 |     rel. addr + absolute address of display file + sizeof dfl
 */

/*
 | further load status register a assignements
 */
#define d_lplite 0200
#define d_lpdark 0300

#define d_ital0 040
#define d_ital1 060

#define d_statsb   0174000        /* load status reg. B */

#define d_incr     0100           /* graphplot increment */

/*
 | vector/point mode.
 */

#define d_intx     040000         /* intensify vector or point */

#define d_maxx     01777          /* max delta X */
#define d_maxy     01777          /* max delta Y */

#define d_minusx   020000         /* delta x is negative */
#define d_minusy   020000         /* delta y is negative */
#define d_minus	   020000

/*
 | short vector mode
 */

#define d_maxsx    017600         /* max delta x */
#define d_maxsy    000077         /* max delta y */

#define d_misvx    020000         /* delta x is negative */
#define d_misvy    000100         /* delta y is negative */
