#
#include	"rt.h"
char		LOCAL	1;	/*zero for no sync;non-zero for sync*/

extern int	errno;

char *		progname;

int		fid;		/*channel from which sync word is read*/

main(argc,argv)
int	argc;
char *	argv[];
	{
	register char * cp;
	register int	x;
	register char * ep;
	struct dirseg	dirseg;
	int		rtnm[3];
	int		mode;	/*READ if reading; WRITE if writing*/
	int		sector;
	int		start;
	int		length;
	char		buf[512];
	int		wfid;
	char		getcbuf[518];

	progname = argv[0];
	if	(argc != 3 || argv[1][1] != '\0' ||
		argv[1][0] != 'r' && argv[1][0] != 'w')
		error(EINVAL);
	mode = argv[1][0] == 'r' ? READ : WRITE;
	cp = argv[2];
	while	(*cp != '\0')
		cp++;
	while	(cp > argv[2] && *--cp != '/');
	if	(cp == argv[2])
		error(EINVAL);
	*cp++ = '\0';
/*
	meaning that future references to argv[2]
	will ignore whatever followed the last slash.
*/
	if	(fnm2rt(cp,rtnm))
		error(EINVAL);
	if	((fid = open(argv[2],READ)) < 0 ||
		mode == WRITE && (wfid = open(argv[2],WRITE)) < 0)
		error(errno);
	setuid(getuid());
	dirseg.d_nextseg = FIRSTDIRSEG;
	do	{
		sector = DIROFFSET + (dirseg.d_nextseg - 1) * DIRSEGSC;
		if	(seek(fid,sector,3))
			error(errno);
		if	(read(fid,&dirseg,sizeof dirseg) != sizeof dirseg)
			error(errno);
		start = dirseg.d_start;
		x = ENTRYBC + dirseg.d_xtraby;
		for	(ep = dirseg.d_entries;
			(ep->e_status & S_ENDSEG) == 0;
			ep =+ x)
			if	(ep->e_name[0] == rtnm[0] &&
				ep->e_name[1] == rtnm[1] &&
				ep->e_name[2] == rtnm[2] &&
				ep->e_status & S_PERMANENT)
				{
				length = ep->e_length;
				goto found;
				}
			else	start =+ ep->e_length;
		}
		while	(dirseg.d_nextseg != NULLDIRSEG);
	if	(rtnm[0] || rtnm[1] || rtnm[2])
		error(ENOENT);
	length = start;
	start = 0;
found:
	if	(mode == READ)
		{
		if	(seek(fid,start,3))
			error(errno);
		while	(length-- > 0)
			if	(read(fid,buf,sizeof buf) != sizeof buf ||
				write(1,buf,sizeof buf) != sizeof buf)
				error(errno);
		}
	if	(mode == WRITE)
		{
		if	(seek(wfid,start,3))
			error(errno);
		cp = buf;
		while	((x = getc(getcbuf)) >= 0)
			{
			if	(length <= 0)
				error(ENOSPC);
			*cp++ = x;
			if	(cp >= buf + sizeof buf)
				{
				rtwait();
				if(write(wfid,buf,sizeof buf) != sizeof buf)
					error(errno);
				length--;
				cp = buf;
				}
			}
		while	(length-- > 0)
			{
			while	(cp < buf + sizeof buf)
				*cp++ = 0;
			rtwait();
			if	(write(wfid,buf,sizeof buf) != sizeof buf)
				error(errno);
			cp = buf;
			}
		}
	exit(0);
	}

rtwait()
	{
	static long int lasttime;	/*last time sync word was checked*/
	static int	oldsync;	/*sync word at last check*/
	long int	now;
	int		newsync;
	register int	count;

	if	(LOCAL == 0)
		return;
	if	(lasttime == 0)
		if	(seek(fid,5,3) || read(fid,&oldsync,2) != 2)
			error(errno);
	time(&now);
	if	(now - lasttime >= 5)
		{
		count = 0;
		do	{
			if	(seek(fid,5,3) || read(fid,&newsync,2) != 2)
				error(errno);
			if	(newsync != oldsync)
				{
				oldsync = newsync;
				time(&lasttime);
				return;
				}
			sleep(3);
			}
			while	(++count < 100);	/*giving five minutes*/
		error(EPIPE);
		}
	}

error(arg)
int	arg;
	{
	errno = arg;
	perror(progname);
	exit(errno ? errno : -1);
	}
