.Ds
.Fd addch ch \*m
char	ch;

.Fd waddch win\*,ch
WINDOW	*win;
char	ch;
.De
Add the character
.Vn ch
on the window
at the current \*y.
\*(Es
.Ds
.Fd addstr str \*m
char	*str;

.Fd waddstr win\*,str
WINDOW	*win;
char	*str;
.De
Add the string pointed to by
.Vn str
on the window at the current \*y.
\*(Es
In this case, it will put on as much as it can.
.Ds
.Fd box win\*,vert\*,hor
WINDOW	*win;
char	vert\*,hor;
.De
.Pp
Draws a box around the window using
.Vn vert
as the character for drawing the vertical sides, and
.Vn hor
for drawing the horizontal lines.
If scrolling is not allowed,
and the window encompasses the lower right-hand corner of the terminal,
the corners are left blank to avoid a scroll.
.Ds
.Fd clear "" \*m

.Fd wclear win
WINDOW	*win;
.De
Resets the entire window to blanks.
If
.Vn win
is a screen,
this sets the clear flag,
which will cause a clear-screen sequence to be sent
on the next
.Fn refresh
call.
.Ds
.Fd clearok scr\*,boolf \*m
WINDOW	*scr;
bool	boolf;
.De
Sets the clear flag for the screen
.Vn scr .
If
.Vn boolf
is TRUE,
this will force a clear-screen to be printed on the next
.Fn refresh
or
.Fn wrefresh ,
or stop it from doing so if
.Vn boolf
is FALSE.
This only works on screens,
and,
unlike
.Fn clear ,
does not alter the contents of the screen.
If
.Vn scr
is
.Vn curscr ,
the next
.Fn refresh
call will cause a clear-screen,
even if the window passed to
.Fn refresh
is not a screen.
.Ds
.Fd clrtobot "" \*m

.Fd wclrtobot win
WINDOW	*win;
.De
Wipes the window clear from the current \*y to the bottom.
This does not force a clear-screen sequence on the next refresh
under any circumstances.
\*(Nm
.Ds
.Fd clrtoeol "" \*m

.Fd wclrtoeol win
WINDOW	*win;
.De
Wipes the window clear from the current \*y to the end of the line.
\*(Nm
.Ds
.Fd erase "" \*m

.Fd werase win
WINDOW	*win;
.De
Erases the window to blanks without setting the clear flag.
This is analgous to
.Fn clear ,
except that it never causes a clear-screen sequence to be generated
on a
.Fn refresh .
\*(Nm
.Ds
.Fd move y\*,x \*m
int	y\*,x;

.Fd wmove win\*,y\*,x
WINDOW	*win;
int	y\*,x;
.De
Change the current \*y of the window to
.Vn y\*,x ). (
\*(Es
.Ds
.Fd overlay win1\*,win2
WINDOW	*win1\*,*win2;
.De
Overlay
.Vn win1
on
.Vn win2 .
The contents of
.Vn win1 ,
insofar as they fit,
are placed on
.Vn win2
at their starting \*y.
This is done non-destructively,
i.e., blanks on
.Vn win1
leave the contents of the space on
.Vn win2
untouched.
.Ds
.Fd overwrite win1\*,win2
WINDOW	*win1\*,*win2;
.De
Overwrite
.Vn win1
on
.Vn win2 .
The contents of
.Vn win1 ,
insofar as they fit,
are placed on
.Vn win2
at their starting \*y.
This is done destructively,
i.e., blanks on
.Vn win1
become blank on
.Vn win2 .
.Ds
.Fd printw fmt\*,arg1\*,arg2\*,...
char	*fmt;

.Fd wprintw win\*,fmt\*,arg1\*,arg2\*,...
WINDOW	*win;
char	*fmt;
.De
Performs a
.Fn printf
on the window starting at the current \*y.
It uses
.Fn addstr
to add the string on the window.
It is often advisable to use the field width options of
.Fn printf
to avoid leaving things on the window from earlier calls.
\*(Es
.Ds
.Fd refresh "" \*m

.Fd wrefresh win
WINDOW	*win;
.De
Synchronize the terminal screen with the desired window.
If the window is not a screen,
only that part covered by it is updated.
\*(Es
In this case, it will update whatever it can
without causing the scroll.
