#

#include        "../h/param.h"
#include        "../h/buf.h"
#include        "../h/dir.h"
#include        "../h/user.h"

/* Comment out for a full duplex connection */
/* TWOWIRE code has never been tested */
/* #define TWOWIRE      1 /**/

/* #define TESTLOOP     1 /**/

#define NTOUTS  3
#define INTVAL  5*HZ

#define DQADDR  ((struct device *) 0160010)

/*      One of many assumptions is that we won't need
        the UNIBUS map, because all I/O is into the
        kernel area.

        The first write request sets up the protocol
        registers, without doing any I/O.
        The request consists of as many word pairs
        as there are to be active protocol registers.
        The first word of each pair is the character
        detect word, the second is the corresponding
        sequence word.
*/

struct {
        int     rxstat;
        int     txstat;
        union { int  w;
                struct { char lo, hi;};
        }       regerr;
        int     secreg;
};

/* rxstat */
#define RXGO    01
#define RXSACT  04
#define HDX     010
#define RXDNIE  040
#define RXDNP   0200
#define RXDNS   0100
#define RXACTIVE        010000

/* txstat */
#define TXGO    01
#define IDLEMODE        02
#define TXSACT  04
#define ERRIE   010
#define DSIE    020
#define TXDNIE  040
#define TXDNP   0200
#define TXDNS   0100
#define RTS     0400
#define DTR     01000
#define CARRIER 010000
#define CTS     020000
#define DSFLAG  0100000

/* reg/err */
/* log latency and NXM errors */
#define LOGERR  074
/* to be used in the hi byte  */
#define WEXTENB 020
#define EXITT   040

#define ERROR   0100000

/* secondary registers */
#define RXBA    0
#define RXCC    1
#define TXBA    2
#define TXCC    3

#define CHARDET 8
#define SYNCREG 9
#define MISCREG 10
#define SEQREG  12
#define POLYREG 15

/* secondary register values */
#define SYNC    062
#define MCLEAR  040
#define BITS8   04000
#define CRC16   0120001

#define setsec(n, m)    DQADDR->regerr.hi= (n); DQADDR->secreg= (m)

struct secinit {
        int     reg, val;
} dqsecinit[] {
        SYNCREG, SYNC|(SYNC<<8),
        POLYREG, CRC16,
        MISCREG, BITS8,
        0
};

/* don't make it positive ! */
#define DQPRI   (PZERO-1)

struct {
        struct buf      *bufp;
        char    stat, toutrun;
        int     error;
        int     clock;
#ifdef TESTLOOP
        int     test;
        int     cts;
#endif
} dq;

/* stat codes; CLOSED must be 0 */
#define CLOSED  0
#define FIRST   1
#define WCTS    2
#define WRITING 3
#define READING 4
#define INACT   5
#define LOOP    31

#ifdef TWOWIRE
#define RXSTATF HDX|RXDNIE
#define TXSTATF ERRIE|DSIE|TXDNIE|DTR
#else
#define RXSTATF RXDNIE
#define TXSTATF ERRIE|TXDNIE|RTS|DTR
#endif

dqopen()
{
        if(dq.stat == CLOSED) {
                dq.stat= FIRST;
                dq.bufp= geteblk();
                        /* no need to raise the priority */
                if(!dq.toutrun) {
                        dq.toutrun++;
                        dqtout();
                }
        } else
                u.u_error= ENXIO;
}

dqclose()
{
        dq.stat= CLOSED;
        setsec(MISCREG, MCLEAR);
        brelse(dq.bufp);
}

dqrint()
{
        if(dq.stat == READING) {
                dq.error= 0;
                dq.stat= INACT;
                wakeup(&dq);
        }
}

dqxint()
{
        register  r;

        r= DQADDR->regerr.w;
        if(r & ERROR) {
                if(r & LOGERR) {
                        printf("dq errint %o\n", r);
                        printf("dq logic");
                } else {
                        if(dq.stat == INACT)
                                printf("dq parity late\n");
                        else {
                                dq.error= EIO;
                                dq.stat= INACT;
                                wakeup(&dq);
                        }
                }
        }
#ifdef TWOWIRE
        else if((dq.stat == WCTS) && (DQADDR->txstat & CTS)) {
                dq.cts++;
                wakeup(&dq);
        }
#endif
        else if(dq.stat == WRITING) {
                dq.error= 0;
                dq.stat= INACT;
                wakeup(&dq);
        }
}

dqtout()
{
        if((dq.stat == WRITING) ||
           ((dq.stat == READING) && ((DQADDR->rxstat & RXACTIVE) == 0))) {
                dq.clock++;
                if(dq.clock >= NTOUTS) {
                        DQADDR->rxstat= RXSTATF;        /* negate RXGO */
                        dq.error= ETOUT;
                        wakeup(&dq);
                        dq.stat= INACT;
                }
        }
        if(dq.stat != CLOSED)
                timeout((caddr_t)dqtout, 0, INTVAL);
        else
                dq.toutrun= 0;
}

dqwrite()
{
        register  i, j;
        register struct secinit  *k;

        if(dq.stat == FIRST) {
#ifdef TESTLOOP
                dqloop();
#endif
                /* clear CC's and BA's */
                for(i= 7; i>= 0; i--) {
                        setsec(i|WEXTENB, 0);
                }
                /* character protocol registers */
                for(i= 0; i < 16; i++) {
                        DQADDR->rxstat.hi= i;
                        j= cpass();
                        setsec(CHARDET, j|(cpass()<<8));
                        j= cpass();
                        setsec(SEQREG, (j == -1 ? 0: j|(cpass()<<8)));
                }
                for(k= &dqsecinit; k->reg; k++) {
                        setsec(k->reg, k->val);
                }
                DQADDR->rxstat= RXSTATF;
                DQADDR->txstat= TXSTATF;
                dq.stat= INACT;
#ifdef TESTLOOP
                dqloop();
#endif
        } else {
                dqdma(TXBA, DQADDR->txstat);
                if(u.u_error)
                        return;
                iomove(dq.bufp->b_un.b_addr, u.u_count, B_WRITE);
                if(u.u_error)
                        return;
#ifdef TESTLOOP
                dqloop();
#endif
                spl6();
#ifdef TWOWIRE
                dq.stat= WCTS;
                DQADDR->txstat= TXSTATF|RTS;
                sleep(&dq, DQPRI);
#endif
                dq.clock= 0;
                dq.stat= WRITING;
                DQADDR->txstat= TXSTATF|TXGO|RTS;
                sleep(&dq, DQPRI);
                spl0();
                u.u_error= dq.error;
#ifdef TWOWIRE
                wtics(2);
                DQADDR->txstat= TXSTATF;
#endif
#ifdef TESTLOOP
                dqloop();
#endif
        }
}

dqread()
{
        register  r;

        dqdma(RXBA, DQADDR->rxstat);
        if(u.u_error)
                return;
#ifdef TESTLOOP
        dqloop();
#endif
        spl6();
        dq.clock= 0;
        dq.stat= READING;
        DQADDR->rxstat= RXSTATF|RXGO;
        sleep(&dq, DQPRI);
        spl0();
        u.u_error= dq.error;
        DQADDR->regerr.hi= RXCC;
        iomove(dq.bufp->b_un.b_addr, u.u_count+DQADDR->secreg, B_READ);
#ifdef TESTLOOP
        dqloop();
#endif
}

dqdma(wr, cs)
{
        register i, j;

        if(u.u_count > BSIZE) {
                u.u_error = E2BIG;
                return;
        }
        i= wr+1;
        if(cs & TXSACT)
                i=+ 4;
        for(j= wr+4; j >= 0; j=- 4) {
                setsec(j|WEXTENB|(dq.bufp->b_xmem<<5), dq.bufp->b_un.b_addr);
        }
        for(j= wr+5; j >= 0; j=- 4) {
                setsec(j, (i == j ? -u.u_count: 0));
        }
}

#ifdef TESTLOOP
dqloop()
{
        register  x;

        if(!dq.test)
                return;
        x= dq.stat;
        dq.stat= LOOP;
        while(dq.stat == LOOP)
                wtics(25);
        dq.stat= x;
}
#endif
