# tr/mkdev - install trace driver for kernel debugging

DEVDIR=/dev
. /usr/lib/shell_lib.sh
COMMAND_NAME=$0
source_path $0 "HOME_DIR="
parent_of $HOME_DIR "CONF_DIR="
. $CONF_DIR/bin/conf_lib.sh

###############
# Main logic.
#
# Configure driver.
# If driver enabled
#   configure hard drive devices
###############

# Enable/disable tr device driver.
echo "\nTrace device"
set_enable_status tr

# Hardware configuration of tape drive.

while : ; do

	tune TRACE_BUF_LEN_SPEC "Number of bytes in trace ring buffer"

	read_input "Is this correct" ANS "y" require_yes_or_no || continue
	is_yes $ANS && break

done

# Make device nodes.
#
# Major number is 6.
# Minor number is 0.

/etc/mknod -f $DEVDIR/trace c 6 0
/bin/chmog 444 bin bin $DEVDIR/trace

exit 0
