.ds TL "X Clients"
.NH "X Windows Clients"
.PP
This chapter introduces the clients and utilities
included with X Windows for \*(CO.
.PP
.II client
.II utility
.II application
Strictly speaking, a
.I client
is a program that registers with, and runs under, the X server.
``Client'' often is used as a synonym for the term
.IR application .
This manual uses the term
.I utility
to refer to a program that helps you to manage and run the X Window System
itself; and the term
.I client
to refer to a program with which you can perform some task under
the X Window System (e.g., edit a file or play a game).
.PP
This chapter introduces the utilities and clients
included with X Windows for \*(CO.
It then gives examples of how to modify an application's appearance or
behavior by changing its resources.
.SH "X Utilities"
.PP
.II utility
.II "X^utilities"
A utility helps you to run the X Window System itself.
X Windows for \*(CO includes utilities to help run every aspect of the X system.
The following introduces them by category.
.Sh "Bit Maps"
.PP
.II "bit map"
A
.I "bit map"
is an image that is composed of black and white pixels within a defined space.
X uses bit maps extensively; for example, the shapes of the mouse cursor,
fonts of alphabetic characters, buttons, and icons are all bit maps.
.PP
.II xlogo32
X stores a bit map in the form of a array.
For example, the file
.BR /usr/X11/include/X11/bitmaps/xlogo32 ,
which is a bit map of the X logo, consists of the following:
.DM
	#define xlogo32_width 32
	#define xlogo32_height 32
	static char xlogo32_bits[] = {
	   0xff, 0x00, 0x00, 0xc0, 0xfe, 0x01, 0x00, 0xc0, 0xfc, 0x03, 0x00, 0x60,
	   0xf8, 0x07, 0x00, 0x30, 0xf8, 0x07, 0x00, 0x18, 0xf0, 0x0f, 0x00, 0x0c,
	   0xe0, 0x1f, 0x00, 0x06, 0xc0, 0x3f, 0x00, 0x06, 0xc0, 0x3f, 0x00, 0x03,
	   0x80, 0x7f, 0x80, 0x01, 0x00, 0xff, 0xc0, 0x00, 0x00, 0xfe, 0x61, 0x00,
	   0x00, 0xfe, 0x31, 0x00, 0x00, 0xfc, 0x33, 0x00, 0x00, 0xf8, 0x1b, 0x00,
	   0x00, 0xf0, 0x0d, 0x00, 0x00, 0xf0, 0x0e, 0x00, 0x00, 0x60, 0x1f, 0x00,
	   0x00, 0xb0, 0x3f, 0x00, 0x00, 0x98, 0x7f, 0x00, 0x00, 0x98, 0x7f, 0x00,
	   0x00, 0x0c, 0xff, 0x00, 0x00, 0x06, 0xfe, 0x01, 0x00, 0x03, 0xfc, 0x03,
	   0x80, 0x01, 0xfc, 0x03, 0xc0, 0x00, 0xf8, 0x07, 0xc0, 0x00, 0xf0, 0x0f,
	   0x60, 0x00, 0xe0, 0x1f, 0x30, 0x00, 0xe0, 0x1f, 0x18, 0x00, 0xc0, 0x3f,
	   0x0c, 0x00, 0x80, 0x7f, 0x06, 0x00, 0x00, 0xff};
.DE
The manifest constants
.B xlogo32_width
and
.B xlogo32_height
give the width and height of the image, in pixels.
The zero-bits within the array represent white pixels, whereas the non-zero
bits represent black pixels.
.PP
If you wish, you can draw new bit maps or edit existing bitmaps.
X Windows for \*(CO includes the following tools for working with
bit maps:
.DS
.ta 0.5i 1.5i
	\fBbitmap\fR	Bit map editor
	\fBatobm\fR	Convert ASCII to an X bit-mapped image
	\fBbmtoa\fR	Convert an X bit-mapped image to ASCII
.DE
.II bitmap
.B bitmap
is a bit-map editor.
With it you can draw a bit-mapped image using the mouse.
It also has tools for copying or inverting regions of the bit map,
drawing geometric shapes, rotating bit maps, and the like.
.PP
.B bmtoa
converts a bit map to an ASCII format that you can edit with an ordinary
text editor.
For example, the command
.DM
	bmtoa /usr/X11/include/X11/bitmaps/xlogo32
.DE
turns the bit map shown above into the following:
.DM
	########----------------------##
	-########---------------------##
	--########-------------------##-
	---########-----------------##--
	---########----------------##---
	----########--------------##----
	-----########------------##-----
	------########-----------##-----
	------########----------##------
	-------########--------##-------
	--------########------##--------
	---------########----##---------
	---------########---##----------
	----------########--##----------
	-----------#######-##-----------
	------------#####-##------------
	------------####-###------------
	-------------##-#####-----------
	------------##-#######----------
	-----------##--########---------
	-----------##--########---------
	----------##----########--------
	---------##------########-------
	--------##--------########------
	-------##---------########------
	------##-----------########-----
	------##------------########----
	-----##--------------########---
	----##---------------########---
	---##-----------------########--
	--##-------------------########-
	-##---------------------########
.DE
By default,
.B bmtoa
represents a white pixel with a hyphen `-' and a black pixel with a
pound sign `#'.
.PP
Finally,
.B atobm
turns an ASCII image into a bit map that X can use.
You could, for example, use a text editor to edit the image generated by
.BR bmtoa ,
then use
.BR atobm
to re-compile the image into bit-map format.
.PP
.II xsetroot
As a side note, you can use a bit map to ``tile'' the root window of your
screen \(em simply invoke the command
.B xsetroot
with its option
.BR bitmap .
For example, the command
.DM
	xsetroot -bitmap /usr/X11/include/X11/bitmaps/xlogo32
.DE
tiles the root window with the X logo.
.Sh "Colors"
.PP
.II color
X Windows for \*(CO includes the following utilities for manipulating colors:
.DS
.ta 0.5i 1.5i
	\fBshowrgb\fR	Un-compile an RGB color-name data base
	\fBxcmsdb\fR	Manipulate xlib screen-color characterization data
	\fBxstdcmap\fR	X standard color-map utility
.DE
.II showrgb
.B showrgb
names the colors that the server recognizes.
.II rgb.txt
The file
.B /usr/X11/lib/rgb.txt
gives an example of its output,
and also shows colors that the X color server recognizes by default.
.PP
.II xcmsdb
.II xstdcmap
.B xcmsdb
and
.B xstdcmap
let you display and manipulate color information
within widgets and the server.
Using these utilities requires a detailed knowledge of X internals.
For details, see the entry in the Lexicon for each utility.
.Sh "Fonts"
.PP
.II font
A
.I font
is a set of bit-mapped images that form the letters of the alphabet
and commonly used punctuation marks.
X Windows for \*(CO includes the following utilities for manipulating text
fonts:
.DS
.ta 0.5i 1.5i
	\fBbdftopcf\fR	Generate a PCF font from a BDF file
.\"	\fBfs\fR	X font server
.\"	\fBfsinfo\fR	Display information about a font server
.\"	\fBfslsfonts\fR	Display a list of available fonts
.\"	\fBfstobdf\fR	BDF font generator
	\fBmkfontdir\fR	Create file fonts.dir from directory of font files
.\"	\fBshowfont\fR	Dump a font for the X font server
	\fBxfd\fR	Display all the characters in an X font
	\fBxfontsel\fR	Interactively select X11 fonts
	\fBxlsfonts\fR	List fonts being used on a server
.DE
.\"Because fonts vary in so many ways \(em for example,
.\"by style, weight, slant, size, and character set \(em a set of fonts for X
.\"can consume quite a bit of disk space.
.\".II fs
.\"Rather than have each machine reproduce all fonts, the X system uses the
.\"utility
.\".BR fs ,
.\"which is a font server.
.\".B fs
.\"receives requests for fonts from all of the X systems on a network, and returns
.\"the font in question.
.\".II "font^scalable"
.\".B fs
.\"can also turn a scalable font, which is kept in the form of a logical
.\"description rather than a bit map, into a normal set of bit-mapped images
.\"at a requested size, and return the bit-mapped font to the requester.
.\".PP
.\"Because X Windows for \*(CO does not yet support networking, you probably
.\"seldom need to invoke
.\".BR fs .
.\"You will need to do so, however, if you wish to change fonts on the fly,
.\"rather than just use the fonts that are invoked when the server comes up.
.\".PP
.\".II fsinfo
.\".II fslsfonts
.\".II showfont
.\".B fsinfo
.\"gives information about the font server to which your server is connected.
.\".B fslsfonts
.\"displays the fonts available to the font sever.
.\".B showfont
.\"displays a font via the font server.
.\"Normally, these utilities do
.\"nothing because you normally will not be running a font server.
.\".PP
.II Xconfig
.II FontPath
X reads fonts from the directories named in its
.BR FontPath ,
which is set in the file
.BR /usr/X11/lib/Xconfig .
.II fonts.dir
Each directory in the
.B FontPath
contains a file named
.BR fonts.dir ,
which gives the full, 14-part name of each font in the directory
and the file that holds it.
This is done because font files normally are compressed, and uncompressing
and searching all of the files in a directory to see if a given font was
available would be unacceptably time-consuming.
Thus, when you copy a new font into a font directory, you must modify
.BR fonts.dir ,
or X will not be able to find the font.
.II mkfontdir
The utility
.B mkfontdir
reads the fonts in a given font directory and rebuilds
.BR fonts.dir
automatically.
.PP
.II xlsfonts
The utility
.B xlsfonts
displays the full, 14-part of each font that is currently available to the
X server.
.PP
.II xfontsel
The utility
.B xfontsel
lets you select a font interactively.
It uses a series of 14 drop-down menus to help you build a font name, based
on the fonts that are available to your system.
The Lexicon entry for this utility also explains just what the elements of
a font name mean.
.PP
.II bdftopcf
.II "font^bitmap distribution format"
.II "font^portable compiled format"
.II "bitmap distribution format"
.II "portable compiled format"
.II BDF
.II PCF
Fonts can be encoded in a number of different ways.
X Windows for \*(CO uses fonts that are in the portable compiled format
(PCF).
Fonts, however, often are shipped in the bitmap distribution format (BDF).
The utility
.B bdftopcf
converts a BDF font into PCF so you can use it on your system.
.PP
.II xfd
Finally, the utility
.B xfd
displays a font.
For example, the command
.DM
	xfd -fd 6x10 -center
.DE
displays the font kept in file
.BR /usr/X11/lib/fonts/misc/6x10.pcf.Z .
When you click on a cell of the display,
.B xfd
displays detailed information about the character in that cell.
For an example of a displayed font (albeit a special font), see the entry for
.B xfd
in this manual's Lexicon.
.Sh "Manipulating the Console"
.PP
The following utilities let you modify the console's appearance:
.DS
.ta 0.5i 1.5i
	\fBxrefresh\fR	Refresh all or part of an X screen
	\fBxset\fR	Set preferences for the display
	\fBxsetroot\fR	Set preferences for the root window
.DE
.II xrefresh
.B xrefresh
redraws a given window or the entire screen, whichever you prefer.
You can use this to redraw a window or the screen, should it become
cluttered with stuff from other, non-X processes, or should it somehow
become confused.
.PP
.II xsetroot
.II "root window"
.II "screen^background"
.B xsetroot
lets you modify the appearance of the root window \(em that is, the window
that forms the background of the screen.
You can change the window to a solid color, a pair of stippled colors, a gray
scale, or tile it with a bit-mapped image.
It also lets you change the mouse cursor that is displayed against the
root window.
.PP
.II xset
Finally, the utility
.B xset
lets you set parameters for the display, and for other input devices.
For example,
.B xset
lets you set the acceleration rate for the mouse, and the loudness of both
the key click and the bell.
To set the key click to 50% of its maximum volume, type:
.DM
	xset c 50
.DE
Note that not every computer lets you reset the volume of the keyclick or bell.
For details, see the Lexicon entry for
.BR xset .
.Sh "Programming Tools"
.PP
X Windows for \*(CO includes the following tools for remaking X utilities:
.DS
.ta 0.5i 1.5i
	\fBimake\fR	C preprocessor interface to the \fBmake\fR utility
	\fBmakedepend\fR	Create dependencies in \fBmakefile\fRs
	\fBmkdirhier\fR	Make a directory hierarchy
	\fBxmkmf\fR	Create a \fBMakefile\fR from an \fBImakefile\fR
.DE
None of these tools interact with the X server; if you wish,
you can use them with your ordinary, character-based applications as well
as on X applications.
.PP
.II make
.II imake
.B imake
is a superset of the \*(CO utility
.BR make .
It understands a more complex set of dependencies than those encompassed by
.BR make 's
grammar.
These dependencies include widgets, operating system, and microprocessor.
.B imake
reads an
.BR Imakefile ,
which contains dependencies plus C-preprocessor directives.
You can define constants on the
.B imake
command line to determine what the resulting program will look like.
Note that you will seldom, if ever, need to invoke
.B imake
directly.
Usually, you will invoke it via the script
.BR xmkmf ,
which is described below.
.PP
.II makedepend
.B makedepend
reads a set of C source files and header files, and builds a table of
dependencies from them.
From this table, you can construct a
.B makefile
or an
.BR Imakefile .
.PP
.II mkdirhier
.B mkdirhier
creates a directory hierarchy.
That is, if the parent directories of a target directory do not exist,
.B mkdirhier
creates them first, then creates the directory you requested.
.PP
Finally,
.II xmkmf
.B xmkmf
is a script that invokes
.B imake
to build
.B Makefile
from an
.BR Imakefile .
It passes appropriate arguments to
.B imake
to ensure that it builds a
.B Makefile
that runs correctly on your system.
.PP
These utilities are discussed at greater length in the next chapter.
.Sh "Resources and Properties"
.PP
The following utilities help you examine and manage resources and properties:
.DS
.ta 0.5i 1.5i
	\fBappres\fR	List an application's resource data base
	\fBeditres\fR	Resource editor for X Toolkit applications
	\fBlistres\fR	List resources in widgets
	\fBviewres\fR	Graphical class browser for \fBXt\fR
	\fBxprop\fR	Display the X server's properties
	\fBxrdb\fR	Read/set the X server's resource data base
.DE
.II resource
.II appres
.B appres
prints on the standard output the resources that an application uses.
The following gives a portion of the output of the command
.BR "appres XTerm" :
.DM
	*VT100*color2:	green
	*VT100*font5:	9x15
	*VT100*color6:	cyan
		...
	*VT100*font1:	nil2
	*VT100*font4:	7x13
	*VT100*color5:	magenta
	*tekMenu*vtshow*Label:	Show VT Window
		...
	*tekMenu*tektext3*Label:	#3 Size Characters
	*tekMenu.Label:	Tek Options
	*fontMenu*font5*Label:	Large
	*fontMenu*font6*Label:	Huge
	*fontMenu*font2*Label:	Tiny
		...
	*mainMenu.Label:	Main Options
	*vtMenu*hardreset*Label:	Do Full Reset
	*vtMenu*scrollbar*Label:	Enable Scrollbar
	*vtMenu*scrollkey*Label:	Scroll to Bottom on Key Press
	*vtMenu*scrollttyoutput*Label:	Scroll to Bottom on Tty Output
		...
	*vtMenu*autolinefeed*Label:	Enable Auto Linefeed
	*vtMenu*altscreen*Label:	Show Alternate Screen
	*vtMenu*appcursor*Label:	Enable Application Cursor Keys
	*vtMenu*softreset*Label:	Do Soft Reset
	*vtMenu*appkeypad*Label:	Enable Application Keypad
		...
	*tek4014*fontSmall:	6x10
.DE
Resources are discussed in more detail below.
.PP
.B editres
is an interactive program that lets you edit an application's resources
on the fly.
By selecting options from buttons and menus, you can add or delete resources
from an application, or change a resource's value, then view the result and
dump the altered resources into a file.
In effect,
.B editres
gives you a way to edit an application's resource file interactively.
Playing with
.B editres
is a good way to learn about resources.
.PP
.II listres
.B listres
lists resources used in a widget.
For example
.DM
	listres -all
.DE
prints information about all known widgets.
.PP
.II property^definition
.II xprop
In the context of X, the term
.I property
means a string that holds information about an application,
such as its color or the size of its window.
Properties are stored within the server,
so they can be read by all other clients, including the window manager.
.B xprop
displays the properties associated with a given client.
The following gives the output of
.B xprop
when invoked for the X client
.BR xclock :
.DM
	WM_STATE(WM_STATE):
			window state: Normal
			icon window: 0x0
	WM_PROTOCOLS(ATOM): protocols  WM_DELETE_WINDOW
	WM_CLASS(STRING) = "xclock", "XClock"
	WM_HINTS(WM_HINTS):
			Client accepts input or input focus: False
			Initial state is Normal State.
			bitmap id # to use for icon: 0x1000001
			bitmap id # of mask for icon: 0x1000003
	WM_NORMAL_HINTS(WM_SIZE_HINTS):
			user specified location: 15, 26
			user specified size: 135 by 141
			window gravity: NorthWest
	WM_CLIENT_MACHINE(STRING) = "chelm"
	WM_COMMAND(STRING) = { "xclock", "-geometry", "135x141+15+26", \e
			"-fg", "blue", "-chime", "-update", "1" }
	WM_ICON_NAME(STRING) = "xclock"
	WM_NAME(STRING) = "xclock"
.DE
.II xrdb
.II RESOURCE_MANAGER
.II SCREEN_RESOURCES
Finally, the utility
.B xrdb
reads and sets the X server's resource data base.
It manipulates the contents of the properties
.B RESOURCE_MANAGER
and
.BR SCREEN_RESOURCES .
Applications read these properties to obtain resources that
are common to all resources under a given server.
Note that the contents of these properties usually override what an application
may read from its defaults file.
These properties are also read by applications that do not normally read
a defaults file (e.g.,
.BR xbiff ),
and so can be used to modify them.
.PP
.B xrdb
is of particular use in a networked environment.
It lets you embed resources within your machine's server, so that every
client that appears on your machine, regardless of the machine it originates
from, conforms to the way you want it to appear.
This spares you from having to store a defaults file on every
machine from which you might invoke a client.
.PP
.B xrdb
is invoked by default by the X display manager
.BR xdm ,
which is not included with X Windows for \*(CO.
If you wish to set defaults with
.BR xrdb ,
you should call it from within the file
.BR $HOME/.xinitrc .
The next sections gives some examples of how to use
.B xrdb
to set resources.
.Sh "System Monitoring"
.PP
The following utilities help you keep an eye on your system:
.DS
.ta 0.5i 1.5i
	\fBxauth\fR	Display/edit authorization information
	\fBxdpyinfo\fR	Display information about an X server
	\fBxev\fR	Print contents of X events
	\fBxlsatoms\fR	List atoms defined on server
	\fBxlsclients\fR	List client applications running on a display
	\fBxwininfo\fR	Display information about a window
.DE
.II xauth
.B xauth
lets you create or edit an authorization file.
This file determines who from what system can execute what clients on your
system.
This utility is used mainly in networked environments, where the
question of system security becomes very important.
.PP
.II xdpyinfo
.B xdpyinfo
displays information about the X server running on your system.
The following gives a portion of its output:
.DM
	name of display:    :0.0
	version number:    11.0
	vendor string:    Ready-to-Run Software, Inc.
	vendor release number:    5000
	maximum request size:  262140 bytes
	motion buffer size:  0
	bitmap unit, bit order, padding:    8, MSBFirst, 32
.DE
If your server were handling more than one display, information would be
shown for each.
.PP
.II event
An
.I event
is something that occurs on your system that sends a signal to the X server.
For example, the mouse sliding on your desk is an event, because the server
must reposition the mouse cursor.
Events are generated every time you press a mouse button,
press a key on the keyboard, or in any other way interact with your system.
.II xev
The X utility
.B xev
displays a small window on the screen, and then displays information about
every events received by the server.
.PP
.II atom
In the context of X, an
.I atom
is an elemental portion of the server that is available to clients.
For example, properties are atoms, as are the names of fonts, some static
strings, and other information.
.II xlsatoms
The X utility
.B xlsatoms
lists your server's atoms.
The following gives a portion of its output:
.DM
	1	PRIMARY
	2	SECONDARY
	3	ARC
	4	ATOM
		...
	9	CUT_BUFFER0
		...
	126	-Misc-Fixed-Medium-R-Normal--10-100-75-75-C-60-ISO8859-1
	127	EditresComm
		...
	134	-Misc-Fixed-Bold-R-Normal--13-120-75-75-C-80-ISO8859-1
.DE
.II xlsclients
The utility
.B xlsclients
displays information about all of the clients currently running under your
server.
.PP
.II xwininfo
Finally,
.B xwininfo
displays information about a window.
The following gives a sample of its output:
.DM
	xwininfo: Window id: 0x1000009 "xclock"
.sp \n(pDu
	  Absolute upper-left X:  18
	  Absolute upper-left Y:  29
	  Relative upper-left X:  0
	  Relative upper-left Y:  0
	  Width: 135
	  Height: 141
	  Depth: 1
	  Visual Class: StaticGray
	  Border width: 0
	  Class: InputOutput
		...
	  Corners:  +18+29  -647+29  -647-430  +18-430
	  -geometry 135x141+15+26
.DE
.Sh "Miscellaneous Utilities"
.PP
The following utilities do not fit neatly into any of the above categories.
These miscellaneous utilities, however, include some of the most useful and
interesting programs shipped with X Windows for \*(CO:
.DS
.ta 0.5i 1.5i
	\fBresize\fR	Set environmental variables to show window size
	\fBsessreg\fR	Manage utmp/wtmp entries for non-init clients
	\fBstartx\fR	Initiate an X session
	\fBtwm\fR	Tab Window Manager for the X Window System
	\fBxclipboard\fR	Hold multiple selections for later retrieval
	\fBxcmstest\fR	XCMS test program
	\fBxcutsel\fR	Copy text between the cut buffer and the primary selection
	\fBxinit\fR	Initiate the X Window System
	\fBxkill\fR	Kill an X client
	\fBxmodmap\fR	Modify X keymaps
.DE
.II startx
.II twm
.II xinit
.BR startx ,
.BR twm ,
and
.B xinit
were introduced in the previous chapter.
.PP
.II resize
The utility
.B resize
reads the size of the current
.B xvt
window, then prints onto the standard output
a shell script that, when run, sets the environmental variables
.B ROWS
and
.B COLUMNS
to reflect the size of the window.
These variables can be read by programs that run within that window,
such as screen editors, so they can size themselves properly.
.II MicroEMACS
.II vi
Note that most \*(CO programs, such as MicroEMACS and
.BR vi ,
cannot yet resize themselves.
.PP
.II sessreg
.II utmp
.B sessreg
assists with logging within the system file
.B /etc/utmp
all X clients that run under the X server.
It does nothing unless you have enabled process logging.
.PP
.II xclipboard
.II cut
.II paste
X includes a system-wide facility for cutting and pasting text.
With this, you can cut text from one window and paste it into another.
Normally, X has only one buffer into which you can store cut text.
The utility
.B xclipboard
stores an indefinite number of text ``cuttings'', and retrieve them for
repasting an indefinite number of times.
For more information on cutting and pasting, see the entry for
.B xclipboard
in this manual's Lexicon.
.PP
.II property^PRIMARY
.II PRIMARY
Earlier releases of X did not use the property
.B PRIMARY
to store cut text; rather, they stored cuttings only in a cut buffer.
If you cut and paste text between an up-to-date X client and an older one,
you may find that the older one does not reset the property
.B PRIMARY
correctly, and thus does not produce what you think it will when you cut
text under it.
.II xcutsel
.B xcutsel
copies text between a cut buffer and the property
.BR PRIMARY ,
to help keep different generations of applications synchronized.
All of the utilities and clients included with X Windows for \*(CO support
the latest implementation of X; therefore, you should not need this
utility unless you import an obsolete application from elsewhere.
.PP
.II xkill
.B xkill
kills an X program.
Note that a killed program often leaves debris in memory and on the file
system, so you should use
.B xkill
only in the direst extremity.
.PP
.II xmodmap
.II "keyboard^mapping"
The X server has its own internal keyboard mapping.
For most users, this does not create a problem, because both they
and the X server use the default U.S. keyboard mapping; however, if
you have used the \*(CO driver
.B nkb
to load a foreign keyboard or to customize a keyboard to your preferences,
this behavior of the server's can create serious difficulty.
The utility
.B xmodmap
lets you modify the mappings that the X server recognizes for the keyboard
and the mouse.
With this program, you can (for example) exchange the left mouse button with
the right mouse button, switch the
.B <ctrl>
key with the
.B <CapsLock>
key, and perform other tasks to help your system work as you prefer.
The file
.B /usr/X11/lib/.Xmodmap.ger
gives an example script that remaps the keyboard for X; in this case,
it remaps the keyboard to the German standard.
For details, see the entry for
.B xmodmap
in this manual's Lexicon.
.PP
This concludes our introduction of the utilities included with
X Windows for \*(CO.
The next section introduces clients.
.SH Clients
.PP
.II client
X Windows for \*(CO includes a selection of
\fIclients\fR \(em that is, programs that run under the X server and let
you do something that is not necessarily related to the running of X itself.
It is in the wealth of clients available for it that the true power, and
usefulness, of X becomes apparent.
.Sh "Games"
.PP
.II games
The following are just for fun:
.DS
.ta 0.5i 1.5i
	\fBico\fR	Animate an icosahedron or other polyhedron
	\fBmaze\fR	Create and solve a random maze
	\fBpuzzle\fR	The X scrambled-number game
	\fBxeyes\fR	Display two roving eyes
	\fBxgas\fR	Animated simulation of an ideal gas
	\fBxtetris\fR	Wildly amusing implementation of Tetris
.DE
.II ico
.B ico
draws a polyhedron, and bounces it around the screen.
The object can be either a wire-frame outline, or solid.
Note that unless you have a very robust system, the animation will
be rather jerky, and
.B ico
will ``suck up'' practically all of your system's computation cycles.
.PP
.II maze
.B maze
draws, and then solves, a random maze.
You cannot play this game interactively,
but it does appear exciting on the screen.
.PP
.II puzzle
.B puzzle
implements a scrambled-tile game.
It displays a window divided into 16 cells.
Fifteen of the cells contain numbered tiles, the 16th is empty.
Clicking one button scrambles the tiles.
When you click a tile, it (or its row or column) slides into the empty cell,
if possible; by maneuvering the tiles, you can un-scramble them.
When you give up, you can click another button and have
.B puzzle
un-scramble itself.
.PP
.II xeyes
.B xeyes
displays a pair of ``eyes'' on the screen.
The pupils of the ``eyes'' move to follow the mouse cursor around the screen.
.PP
.II xgas
.B xgas
models the random motion of gas molecules in a heated, divided chamber.
By setting command-line options, you can set parameters of the molecules'
movement, such as the degree of randomness with which they bounce off the
chamber's walls.
By dragging sliders, you can change the temperature of either of the
two sides of the chamber.
.PP
.II xtetris
Finally,
.B xtetris
is a implements the popular game Tetris.
.Sh "Observing the System"
.PP
In addition to the utilities that help you monitor the operation of X itself,
X Windows for \*(CO also includes two clients to help you observe your
\*(CO system:
.DS
.ta 0.5i 1.5i
	\fBxbiff\fR	Notify the user that mail has arrived
	\fBxload\fR	Display your system's load average
.DE
.II xbiff
.B xbiff
displays a bit map of an old-fashioned mailbox.
When you receive mail, the flag on the mailbox pops up.
.PP
.II xload
.B xload
displays a histogram \(em that is, a bar graph \(em
that shows the load on your system.
Every few seconds,
it measures activity on your system and adds a new bar to the graph.
You can use client to measure roughly how much in the way of system
resources a given program consumes.
.Sh "Pretty Pictures"
.PP
The following clients show some of the graphics capabilities of X:
.DS
.ta 0.5i 1.5i
	\fBxlogo\fR	Display the X Window System logo
	\fBxmag\fR	Magnify a part of the screen
	\fBxgc\fR	X graphics demonstration
.DE
.II xlogo
.B xlogo
simply displays the X logo in a window.
This is not a bit-mapped image, because when you resize the window, the
X logo changes size to match it.
.PP
.II xmag
.B xmag
magnifies part of the screen.
It translates each pixel of the magnified portion of the screen into a cell
in a grid.
With
.BR xmag ,
you can see exactly how an image is built of a pixel map.
.PP
.II xgc
Finally,
.B xgc
demonstrates X graphics.
It displays a screen with a great number of buttons and sliders on it.
By pressing buttons, you can construct images and play with X's graphics
capabilities.
Playing with
.B xgc
is a good way to learn about X graphics.
.Sh "Timepieces"
.PP
X helps you keep track of the time:
.DS
.ta 0.5i 1.5i
	\fBoclock\fR	Display an analogue clock
	\fBxclock\fR	Display a clock
.DE
.II xclock
.II oclock
Both of these clients display a clock on the screen, which
displays the time as your system understands it.
These clients differ mainly in the shape of their windows, and in the fact that
.B xclock
offers some extra features \(em it can display a digital clock,
and ``chime'' on the hour and half-hour, if you wish.
Most users permanently display either
.B oclock
or
.B xclock
on their X screen.
.Sh "Tools"
.PP
Finally, the following clients do not fall into any of the above categories.
These include some of the most useful and interesting of the X programs
included with X Windows for \*(CO:
.DS
.ta 0.5i 1.5i
	\fBxcalc\fR	Scientific calculator for X
	\fBxedit\fR	Simple text editor for X
	\fBxpr\fR	Print a dump of an X window
	\fBxterm\fR	Terminal emulator for X
	\fBxvt\fR	VT100 emulator
	\fBxwd\fR	Dump an image of an X window
	\fBxwud\fR	Un-dump a window image
.DE
.II xcalc
.II "Texas Instruments"
.II "Hewlett-Packard"
.II calculator
.B xcalc
displays a picture of a scientific calculator, either a
Texas Instruments 30 or a Hewlett-Packard 10C, whichever you prefer.
You can use the mouse to press the buttons on the calculator and so perform
computations, just as with a real calculator.
The virtual calculator implements most of the features of a real
scientific calculator \(em although clicking virtual buttons with a mouse
is more difficult than pressing real buttons with your fingers.
.PP
.II xedit
.B xedit
is a simple text editor for X.
Its default keystrokes closely resemble those used by \*(ME,
with the exception that
.B xedit
supports only one window and buffer at a time.
(Of course, under X this is not much of a restriction, because you can
invoke multiple
.B xedit
sessions and cut-and-paste among the windows.)
.PP
.II xvt
.II VT-100
.B xvt
emulated a DEC VT-100 terminal.
It opens a window, logs into your system from it via a pseudo-tty,
while emluating a VT-100 terminal.
Normally, you will run a shell in this window, although you can invoke
.B xvt
to run a \*(CO program (such as an editor or a data-entry program)
instead of shell \(em just as if you were logging in from another terminal.
On a networked X system, you can have, on one screen, multiple
.B xvt
windows, each logged into a different system.
You can also use X's cut-and-paste facility to cut text from one terminal
window and paste it into another.
.PP
.II xterm
.B xterm
is an expanded \(em and more robust \(em version of
.BR xvt .
It emulates a Tektronix terminal as well as a VT-100.
It also includes a number of features that let you set colors and features
more easily.
Note that unlike
.BR xvt ,
.B xterm
emulates the VT-100's graphics characters; thus, you can display such
\*(CO programs as
.B vsh
and have them appear the same (or almost the same) as they do when shown
through the ordinary, non-X console interface.
.PP
.II xwd
.II xwud
.B xwd
dumps an image of a window into a file.
You can select a window by name, or dump the root window \(em which, in effect,
saves an image of the entire screen (including menus).
The program
.B xwud
un-dumps a dumped image, by displaying it in a window.
.PP
.II xpr
.B xpr
prints an image dumped by
.BR xwd .
By default, it generates PostScript, although you can instruct it to generate
code for a variety of other printers as well.
.PP
For what it's worth, the images in this manual were captured with
.BR xwd ,
then post-processed with
.BR xpr .
The PostScript output of
.B xpr
was edited slightly by hand, then patched into the manual's
.B troff
sources by using a set of specially written
.B troff
macros.
.SH "Customizing X Programs"
.PP
As noted in the previous chapter, you can customize an X application through
any of three ways:
(1) by setting command-line options, (2) by modifying its defaults file, or
(3) by modifying the X server's resource data base.
.PP
.II resource
The Lexicon entry for an application describes the command-line options that
are available with that application.
These work in exactly the same way as with any other \*(CO application,
and are largely self-explanatory.
Methods 2 and 3, however, depend upon setting
.IR resources ,
which can be rather tricky.
.Sh "Resources"
.PP
.II widget
As explained in the previous chapter, most X applications are constructed
in whole or in part from
.IR widgets .
A widget bundles a a graphical image with a routine that
invokes an action when a selected event occur.
For example, a widget may dictate that when a button (the graphical
image) is clicked (the event), a menu appears (the invoked action).
.PP
.II "widget class"
Widgets often are built out of other widgets.
A widget that comprises part of one or more other widgets is called a
.IR "widget class" .
.PP
.II resource^definition
A
.I resource 
is an aspect of a widget, such as its color, size, or shape.
The syntax of a resource string mirrors the structure of a widget, as follows:
.DS
	\fB[\fIapp\^\fB]*|.[\fIclass\fB*|.[...*|. ...]]*|.[\fIresource\^\fB]:\fIvalue\fR
.DE
.I app
names the application in question.
If no application is named and the resource is in the X server's resource
data base, then it applies to all applications.
If, however, no application is named and the resource is in an application's
defaults file, the resource applies only to the application in question.
.PP
.I class
names a widget class.
A widget class can itself be built out of other widget classes, so a
resource string can be an indefinite number of classes.
.PP
.I resource
names the particular resource being set.
.PP
Finally,
.I value
gives the value to which you are setting
.IR resource .
This can be a Boolean setting (\fBTrue\fR or \fBFalse\fR), a number, or a
string, depending on the aspect being modified.
.PP
The elements of a resource are linked by either a period `.' or an asterisk `*'.
A period binds tightly:
that is, no widget classes can intervene between two classes named in the
resource.
An asterisk binds loosely:
that is, an indefinite number of widget classes can come between the two
widget classes so named.
.PP
.II XCalc
For example, the following gives two lines from the file
.BR /usr/X11/lib/app-defaults/XCalc :
.DM
	*Font:                  -*-helvetica-medium-r-normal--*-100-*-*-*-*-*-*
	*bevel.screen.LCD.Font: -*-helvetica-bold-r-normal--*-120-*-*-*-*-*-*
.DE
The first line sets the
.B Font
for every widget (as indicated by the single preceding asterisk)
to ten-point Helvetica medium.
The second line overrides this default to set the
.B Font
within the widget
.B bevel.screen.LCD
(which is the liquid-crystal display within calculator's ``screen'')
to 12-point Helvetica bold.
A
.B Font
widget naturally must be set to a string.
.PP
The following gives two more resources from
.BR XCalc :
.DM
	*ti.bevel.screen.LCD.width:	108
	*hp.bevel.screen.LCD.width:	180
.DE
The first line sets the width of the virtual liquid-crystal display for the
Texas Instruments calculator; the second gives the same for the
Hewlett-Packard calculator.
Here, the use of the period to bind tightly the classes of widget
ensures that the dimensions are exactly on the correct virtual calculator.
As you can see, a
.B width
resource requires a dimension, usually pixels.
.Sh "Modifying Applications"
.PP
Before we begin, the following examples involve editing files that define
how X functions.
Before you edit any file, \fImake a backup copy!\fR
.II cul-de-sac
This will let you back out of any \fIcul-de-sac\fR you may get yourself into
through error or mishap.
.PP
.II xbiff
To begin, you will recall that the client
.B xbiff
displays on the screen a small window that contains
a bit map of an old-fashioned mailbox.
When new mail arrives, the bit map changes to one with the flag popped up
that is displayed in reverse video.
.PP
X Windows for \*(CO comes with many bit-mapped images that you can use
with existing applications.
.II mailfull
.II mailempty
Two, named
.B mailfull
and
.BR mailempty ,
respectively show a full and empty mail in-tray, much like you may have
on your desk.
Suppose, for the sake of argument, that you wanted to use these bit-mapped
images in place of the default mailboxes.
You can do this by resetting the appropriate resources, and commanding
.B xbiff
to use them instead of its built-in defaults.
.PP
The first step is to check the Lexicon entry for
.BR xbiff .
Among other things, this names the resources that
.BR xbiff
uses.
This entry shows, among many others, the following resources:
.IP "\fBfullPixmap(\fRclass \fBPixmap)\fR"
Name the bit map to display when mail arrives.
.IP "\fBfullPixmapMask(\fRclass \fBPixmapMask)\fR"
Name the mask for the bit map to display when mail arrives.
.IP "\fBemptyPixmap(\fRclass \fBPixmap)\fR"
Name the bit map to display when no new mail is present.
.IP "\fBemptyPixmapMask(\fRclass \fBPixmapMask)\fR"
Name the mask for the bit map to display when no new mail is present.
.PP
.II PixMap
These look like the ones we need to modify.
The first part of each entry names the widget; its class is given in
parentheses.
.PP
The next step is to write the resources that we want to use.
These are as follows:
.DM
	xbiff*fullPixmap:mailfull
	xbiff*fullPixmapMask:mailfullmsk
	xbiff*emptyPixmap:mailempty
	xbiff*emptyPixmapMask:mailemptymsk
.DE
The prefix
.B xbiff
indicates that these settings are to apply only to this application.
The asterisk `*' means that an indefinite number of widget classes can
occur between the name of the application and the widget in which we are
interested; this spares us the trouble of having to build the entire
widget tree \(em and having to rebuild the tree should the designers of
.B xbiff
decide in the future to insert another layer or two into the widget hierarchy.
Finally, value names the file in directory
.B /usr/X11/include/X11/bitmaps
that holds the bit map we want.
.PP
.B xbiff
does not read a defaults file out of
.BR /usr/X11/lib/app-defaults ;
but we can still make
.B xbiff
use our new resources by using the X utility
.B xrdb
to load them into the X server's resources data base.
We save these resources into a file \(em we will use the conventional file
\fB$HOME/.Xdefaults\fR,
although the name of this file doesn't really matter \(em then type the
following command:
.DM
	xrdb -merge < $HOME/.Xdefaults
.DE
This command merges the contents of
.B $HOME/.Xdefaults
into the X server's resource data base.
So, the next time you invoke
.BR xbiff ,
you see:
.PH 1 1 \*(XD/xbiffnew.eps
instead of the old-fashioned mailbox.
.PP
To extend this example, the documentation for
.B xbiff
also mentions the following two resources:
.IP "\fBshapeWindow(\fRclass \fBShapeWindow)\fR"
Specify whether to shape the window to the
.B fullPixmapMask
and
.BR emptyPixmapMask .
The default is false.
.IP "\fBflip(\fRclass \fBFlip)\fR"
Invert the image when new mail arrives.
The default is true.
.PP
To change these defaults, insert the following lines into
.BR $HOME/.Xdefaults :
.DM
	xbiff*shapeWindow:True
	xbiff*flip:False
.DE
Then, type:
.DM
	xrdb -merge < $HOME/.Xdefaults
.DE
The next time you invoke
.BR xbiff ,
its window will be shaped that of the bit-mapped mask; and it will not
pop into reverse video when mail arrives.
.PP
If an application uses a defaults file, you can simply edit that file to
change a resource.
For example, the application
.B xclock
reads the defaults file
.BR /usr/X11/lib/app-defaults/XClock ,
which consists of exactly one line:
.DM
	XClock.input: false
.DE
Note that because this resource is in a defaults file, the resource
.DM
	*input: false
.DE
would behave exactly the same.
If you wanted, for whatever reason, to permit a user to type input into
.BR xclock ,
edit this line to read:
.DM
	XClock.input: true
.DE
As noted earlier, the resources in the X server's resource data base
take precedence over the contents of a defaults file.
For example, the X client
.B xgas
reads the default file
.BR /usr/X11/lib/app-defaults/XGas ,
which (among many others) contains the following resource:
.DM
	*quit.label: Quit
.DE
This resource defines the text that appears on the ``quit'' button.
If you decide that you want this button to be labelled
.BR FOO ,
you can insert the following resource into
.BR $HOME/.Xdefaults:
.DM
	xgas*quit.label:FOO
.DE
Then, type the command:
.DM
	xrdb -merge < $HOME/.Xdefaults
.DE
The next time you invoke
.BR xgas ,
the ``quit'' button will be labelled
.BR FOO ,
thus overriding the setting in
.BR XGas .
.Sh "Modifying a Font Resource"
.PP
.II resource^font
.II font^choose
Fonts are an important aspect of X.
A font incorporates textual information; thus, a well-selected font
can make your system much more useful.
.PP
For example, the defaults file
.B /usr/X11/lib/app-defaults/XTerm
sets a number of different fonts for using in different situations.
The default font is called
.BR fixed .
If you wish to change this to a larger font, try the following:
.IP \(bu 0.3i
.B cd
to directory
.BR /usr/X11/lib/fonts .
This directory holds the fonts available to the X system.
These are kept two sub-directories:
.B misc
and
.BR 75dpi .
The former holds ``miscellaneous'' fonts, such as the
.B cursor
font; the latter holds fancier fonts built in a 75 dots-per-inch format.
Most of the commonly used fonts are in
.BR misc .
.IP \(bu
.B cd
to
.BR misc .
Read file
.BR fonts.alias .
This gives the commonly used aliases for fonts used on the system.
As you can see, the font named
.B fixed
is actually the font:
.DM
	-misc-fixed-medium-r-semicondensed--13-120-75-75-c-60-iso8859-1
.DE
When you look further in
.BR fonts.alias ,
you will see that this is the same as the font named
.BR 6x13 .
The alias indicates that the font is 13 pixels high and 6 pixels wide.
(For information on how to interpret the full, 14-field font name,
see the Lexicon entry for
.BR xfontsel .)
To select a larger font, pick one whose height is greater than 13 pixels
or whose width is greater than six.
For example, the font whose alias is
.B 8x13
is the same height as the
.B fixed
font, but is two pixels wider.
.IP \(bu
Close
.BR fonts.alias .
Then edit your
.B .Xdefaults
file to insert the following entry:
.DM
	xvt*font:8x13
.DE
This sets the font resource for
.B xvt
to the font with the alias
.BR 8x13 .
.IP \(bu
Type:
.DM
	xrdb -merge < $HOME/.Xdefaults
.DE
This merges your new resource setting into the X server's
resource data base.
.PP
That's all there is to it.
The next time you invoke
.BR xvt ,
it will use font
.BR 8x13 ,
which is slightly larger and more legible.
Because the geometry of the
.B xvt
window is set to 80\(mu25 (that, 80 columns by 25 rows), the window will be
resized automatically to use the new font.
.PP
Note, by the way, that an
.B xvt
window using the
.B 8x13
font will not completely fit onto a 640\(mu480 screen \(em the last column
slips off the right edge of the screen.
If you find this to be a real problem, try using a narrower font.
.SH "Where To Go From Here"
.PP
This concludes our introduction to X applications and how to customize them.
We could only scratch the surface of resources, widgets, and the
internals of X; however, we hope that you now know enough to make minor
modifications to your system, and to begin to learn more about X.
.PP
For more information on a given application, see its entry in the Lexicon.
The books referenced in the introduction will also give you more information.
.PP
The next chapter discusses how to recompile X applications under
X Windows for \*(CO.
