.TH REFONT 1
.SH NAME
refont - changes the notation used for fonts
.SH SYNOPSIS
\fBrefont\fP [\fIflags\fP] \fIfiles\fP...
.SH DESCRIPTION
\fIRefont\fP reads a text file which contains font selection codes embedded
within it,
and it writes the same text with a different notation for fonts.
.PP
For example, the Elvis documentation uses Epson-compatible escape sequences
to select different fonts.
You could use the command "refont -b elvis.doc >elvis.cr" to make a file
that uses overtyping to implement boldface or underlined text.
.SH OPTIONS
.IP \fB-b\fP
Emit text which uses the "backspace" notation for fonts.
.IP \fB-c\fP
Emit text which uses the "carriage-return" notation for fonts.
.IP \fB-d\fP
Emit text which uses nroff-style "dot" commands for fonts.
This doesn't work very well.
.IP \fB-e\fP
Emit text using Epson-compatible escape sequences for fonts.
.IP \fB-f\fP
Emit text which uses nroff's "\\fX" notation for fonts.
Underlined text is denoted by "\\fU".
This is somewhat useful in conjunction with Elvis' "charattr" option.
.IP \fB-x\fP
Emit text which has had all font information stripped out.
.IP \fB-I\fP
When reading text, \fB-I\fP tells \fIrefont\fP to accept any of the above
notations for fonts.
Without \fB-I\fP it will ignore the "dot" command and "\\fX" notations;
they will be treated as normal text.
In other words, without \fB-I\fP the only things that could be recognized as
font changes are control-character sequences.
.IP \fB-F\fP
This causes \fIrefont\fP to insert formfeed characters between input files.
.SH BUGS
Support for the nroff-style "dot" commands is not very good.
.PP
If you mix the \fB-I\fP and \fB-f\fP/\fB-d\fP flags, the resulting output
may not be translatable back into its original format.
This is because the original text may have included, for example, strings
that looked like \\fX strings which were not meant to cause font changes.
.PP
With \fB-b\fP/\fB-c\fP, both underlining and italics are implemented by
overtyping the underscore character with a text character.
Since they are represented the same way, the distinction between underlining
and italics is lost.
.SH AUTHOR
.nf
Steve Kirkendall
kirkenda@cs.pdx.edu
\&...uunet!tektronix!psueea!eecs!kirkenda
