#
# Code to do ups_tag 
#
GLOBALS	 "globals0.4gl"

#
# tag's menu
# 
FUNCTION ups_tag()

	OPEN FORM tag_form FROM "ups_tag"
	DISPLAY FORM tag_form

	MESSAGE ""

	MENU ""
	
	COMMAND "Find" "Find tag's row"
		CALL tag_find() 
		IF chosen = 1 THEN 
			NEXT OPTION "Modify"
		END IF

	COMMAND "Modify" "Modify tag's entry"
		IF chosen = 1 THEN
			CALL tag_modify()
		ELSE
			MESSAGE "No entry has been chosen"
			NEXT OPTION "Find"
		END IF

	COMMAND "Delete" "Delete tag's entry"
		IF chosen = 1 THEN
			CALL tag_delete()
		ELSE
			MESSAGE "No entry has been chosen"
		END IF
		NEXT OPTION "Find"

	COMMAND "Report" "General tag report"
		CALL tag_report()
		NEXT OPTION "Exit"

	COMMAND "Exit" "Leave tag's menu"
		CLOSE FORM tag_form
		CLEAR SCREEN	
		EXIT MENU
	END MENU

END FUNCTION

#
# To add UPS call tag information
#
FUNCTION tag_add()

	INPUT BY NAME p_call.tag_no, p_call.why THRU p_call.rec_date

	AFTER FIELD tag_no
		IF p_call.tag_no IS NULL THEN
			MESSAGE "Enter tag number "
			NEXT FIELD tag_no
		END IF

		SELECT call_tag.why INTO tbl FROM call_tag
		   WHERE tag_no = p_call.tag_no
	
		IF status <> NOTFOUND THEN
			MESSAGE "Duplicate tag's number"
			NEXT FIELD tag_no
		END IF

		MESSAGE ""

	AFTER FIELD why
		IF p_call.why IS NULL THEN
			MESSAGE "Explain why. Could be any reason"
			NEXT FIELD why
		END IF

	BEFORE FIELD issue_date
		LET p_call.issue_date = TODAY
		DISPLAY p_call.issue_date TO issue_date

	AFTER FIELD issue_date
		IF p_call.issue_date IS NULL THEN
			MESSAGE "Enter issue date "
			NEXT FIELD issue_date
		END IF

	END INPUT

	LET p_call.invoice_no = p_pickup.invoice_no
	INSERT INTO call_tag VALUES (p_call.*) 
END FUNCTION

#
# Find tag's entry
#
FUNCTION tag_find()
		
	CLEAR FORM
	MESSAGE ""

	CONSTRUCT query1 ON call_tag.invoice_no, tag_no, issue_date, rec_date
	   FROM invoice_no, tag_no, issue_date, rec_date

	LET p_invoice.cust_no = NULL

	LET s1 = "SELECT * FROM call_tag, OUTER invoice WHERE ",
		"call_tag.tag_no = tag_no AND ",
		"invoice.invoice_no = call_tag.invoice_no AND ",
		 query1 CLIPPED

	PREPARE s_1 FROM s1
	DECLARE tag_cursor CURSOR FOR s_1

	LET p_invoice.cust_no = NULL

	FOREACH tag_cursor INTO p_call.*, p_invoice.*

		IF p_invoice.cust_no IS NOT NULL THEN
			SELECT * INTO p_cust.*, s_address.* 
			  FROM customer, address
			  WHERE customer.cust_no = p_invoice.cust_no AND
				address.cust_no = p_invoice.cust_no AND
				address.add_type <> "b"
		ELSE
		    	LET p_cust.contact = NULL 
			LET s_address.line1 = NULL
			LET s_address.city = NULL
			LET s_address.state = NULL
			LET s_address.country = NULL
			LET s_address.zipcode = NULL
		END IF

		LET p_pickup.address = s_address.line1

		DISPLAY BY NAME p_cust.contact, p_pickup.address,
			s_address.city, s_address.state, s_address.country,
			s_address.zipcode

		DISPLAY BY NAME p_call.*

		CALL yn("Select this row <y/n> ? ") RETURNING answer
		
		IF answer = "y" THEN
			LET chosen = 1
			CLOSE tag_cursor
			RETURN
		ELSE
			LET chosen = NULL
		END IF
	END FOREACH

	CLEAR FORM
	CLOSE tag_cursor
	MESSAGE "There are no more tag's entries"
END FUNCTION

#
# Modify tag's entry
#
FUNCTION tag_modify()
	MESSAGE ""

	INPUT BY NAME p_call.tag_no, p_call.why THRU p_call.rec_date
	   WITHOUT DEFAULTS

	AFTER FIELD tag_no
		IF p_call.tag_no IS NULL THEN
			MESSAGE "Enter tag number "
			NEXT FIELD tag_no
		END IF

	AFTER FIELD why
		IF p_call.why IS NULL THEN
			MESSAGE "Explain why. Could be any reason"
			NEXT FIELD why
		END IF

	AFTER FIELD issue_date
		IF p_call.issue_date IS NULL THEN
			MESSAGE "Enter issue date "
			NEXT FIELD issue
		END IF
	END INPUT
  
	DELETE FROM call_tag
	   WHERE tag_no = p_call.tag_no

	INSERT INTO call_tag VALUES (p_call.tag_no, p_invoice.invoice_no,
			p_call.why THRU p_call.rec_date) 

	LET chosen = NULL
	MESSAGE "Row was modified"

END FUNCTION

#
# Delete tag
#
FUNCTION tag_delete()

	MESSAGE ""
	CALL yn("Are you sure ?<y/n> ") RETURNING answer
	IF answer = "y" THEN
		UPDATE pickup_line
		   SET cll = NULL
		   WHERE invoice_no = p_call.invoice_no AND closed = "o"

		DELETE FROM call_tag
		   WHERE tag_no = p_call.tag_no

		MESSAGE "Row deleted"
		LET chosen = NULL
	ELSE
		MESSAGE "Row was not deleted"
	END IF
END FUNCTION

#
# General tag's report
#
FUNCTION tag_report()
	CLEAR FORM
	MESSAGE ""

	CONSTRUCT query1 ON call_tag.invoice_no, tag_no, issue_date, rec_date
	   FROM invoice_no, tag_no, issue_date, rec_date

	LET p_invoice.cust_no = NULL

	LET s1 = "SELECT * FROM call_tag, OUTER invoice WHERE ",
		"call_tag.tag_no = tag_no AND ",
		"invoice.invoice_no = call_tag.invoice_no AND ",
		 query1 CLIPPED

	PREPARE r_1 FROM s1
	DECLARE rep_cursor CURSOR FOR r_1

	LET p_invoice.cust_no = NULL

	START REPORT gen_rep
 	FOREACH rep_cursor INTO p_call.*, p_invoice.*

		IF p_invoice.cust_no IS NOT NULL THEN
			SELECT * INTO p_cust.*, s_address.* 
			  FROM customer, address
			  WHERE customer.cust_no = p_invoice.cust_no AND
				address.cust_no = p_invoice.cust_no AND
				address.add_type <> "b"
		ELSE
		    	LET p_cust.contact = NULL 
			LET s_address.line1 = NULL
			LET s_address.city = NULL
			LET s_address.state = NULL
			LET s_address.country = NULL
			LET s_address.zipcode = NULL
		END IF

		LET p_pickup.address = s_address.line1

		OUTPUT TO REPORT gen_rep(  p_call.invoice_no,  p_cust.contact, 
			 p_pickup.address,    s_address.city, s_address.state, 
			s_address.country, s_address.zipcode,   p_call.tag_no,
			       p_call.why,    p_call.action, p_call.issue_date,
			p_call.rec_date)
	END FOREACH

	FINISH REPORT gen_rep

END FUNCTION

#
# Print general report
#
REPORT gen_rep(invoice_no, cont, address, city, state, country, zipcode,
   tag_no, why, action, issue_date, rec_date)
	DEFINE address		CHAR(38)
	DEFINE invoice_no	INTEGER
	DEFINE cont		CHAR(38)
	DEFINE city		CHAR(20)
	DEFINE state		CHAR(4)
	DEFINE country		CHAR(14)
	DEFINE zipcode		CHAR(11)
	DEFINE tag_no		INTEGER
	DEFINE why		CHAR(70)
	DEFINE action		CHAR(70)
	DEFINE issue_date	DATE
	DEFINE rec_date		DATE

	OUTPUT 
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80
		
	ORDER BY tag_no

	FORMAT
	
	PAGE HEADER
		PRINT COLUMN 20, "General tag's report"
		SKIP 2 LINES

	ON EVERY ROW
		PRINT "Invoice number ", invoice_no USING "######", 
		"  Tag number ", tag_no USING "#########"
		PRINT "Contact        ", cont 	
		PRINT "Address        ", address
		PRINT "City           ", city, "  State   ", state, 
					       "  Zipcode ", zipcode
		PRINT "Country        ", country
		PRINT "Why            ", why
		PRINT "Action         ", action
		PRINT "Issue date     ", issue_date,"  Recieve date ", rec_date 
		SKIP 2 LINES
END REPORT
