#
# Code to add new entry to UPS report
# 
GLOBALS	 "globals0.4gl"

FUNCTION ups_add()

DEFINE 	custno 		INTEGER,
	tmp_weight	DECIMAL(6, 2)

	CLEAR FORM

	CALL msgs("Enter invoice number")
	
	INPUT BY NAME p_pickup.invoice_no

	LET p_invoice.invoice_no = p_pickup.invoice_no

	# Select customer number. This number is necessary to find
	# all shipping stuff.
	SELECT invoice.cust_no, invoice.ship_no, invoice.itotal, invoice.term_no
        	INTO custno, p_invoice.ship_no, p_invoice.itotal, 
		 p_invoice.term_no
		FROM invoice
		WHERE invoice_no = p_invoice.invoice_no

	IF status = NOTFOUND THEN

		CALL msgs("")
		CALL yn("Invoice not found. Insert this customer <y/n> ?")
			RETURNING answer

		IF answer = "n" THEN 
			LET chosen = 0
			CALL msgs("Inquiry canceled")
			RETURN
		ELSE
			CALL ups_handl() # prepare entry without invoice
			RETURN
		END IF

	END IF
	
	IF p_invoice.term_no = 11 THEN	# Magic COD number
		LET p_pickup.cod_chrg = 3.30 	# UPS cod charges
		LET p_pickup.cod_amt = p_invoice.itotal
	ELSE
		LET p_pickup.cod_chrg = NULL
		LET p_pickup.cod_amt = NULL
	END IF

	# Ok, if we are here that means we know cust_no and can find 
	# shipping address
	SELECT customer.contact, address.line1, address.city, address.state,
		address.country, address.zipcode
		INTO p_cust.contact, s_address.line1, s_address.city,
		     s_address.state, s_address.country, 
		     s_address.zipcode
		FROM customer, address
		WHERE customer.cust_no = custno AND address.cust_no = custno
		  AND address.add_type <> "b"

	# On the same invoice could be few dif. products.
	# According to Nancy all stuff will be sent in the one box
	
	LET tmp_weight = 0.0

	IF p_invoice.ship_no < 4 THEN
		LET p_wzp.commer = 1
	ELSE 
		IF p_invoice.ship_no = 12 THEN
			LET p_wzp.commer = 0
		ELSE
			CALL msgs("Was not shipped by UPS")
			RETURN
		END IF
	END IF

	DECLARE inv_curs CURSOR FOR
	SELECT * FROM inv_line WHERE invoice_no = p_invoice.invoice_no

	FOREACH inv_curs INTO p_line.*
		CALL msgs("")

		IF p_line.quantity = 0 OR p_line.quantity IS NULL THEN
			LET p_line.quantity = 1
		END IF
		IF p_line.pack_no = 0 OR p_line.pack_no is NULL THEN
			LET p_line.pack_no = p_line.quantity
		END IF

		# Lets try to find UPS stuff
		CALL ups_weight() 	# Find weight
		LET tmp_weight = tmp_weight + p_product.weight

		LET p_wzp.weight = (tmp_weight + 0.99)

	END FOREACH

	CLOSE inv_curs

	CALL ups_zone() 	# Find zone number
	CALL ups_displ()		

	IF p_wzp.zone = 0 THEN
		INPUT BY NAME p_wzp.zone
	END IF

	CALL ups_price(p_wzp.commer)  # Find charge 

	WHILE p_wzp.price = 0 OR p_wzp.zone = 0
		IF p_wzp.weight IS NULL THEN
			LET p_wzp.weight = 0
		END IF
		IF p_wzp.weight < 0 OR p_wzp.weight > 70 THEN
			CALL msgs("Enter weight")
			INPUT BY NAME p_wzp.weight
			CALL ups_price(p_wzp.commer)
			CONTINUE WHILE
		END IF
		CALL msgs("Enter zone number")
		INPUT BY NAME p_wzp.zone
		CALL ups_price(p_wzp.commer)  # Find charge
	END WHILE

	CALL msgs("")

	LET p_pickup.charge = p_wzp.price

	DISPLAY BY NAME p_pickup.charge

	CALL ups_displ()
	CALL yn("Prepare this entry for UPS report <y/n>? ") RETURNING answer

	IF answer = "y" THEN
		CALL ups_insert()
	ELSE
		CALL msgs(" Canceled")
	END IF	
END FUNCTION

#
# Add row in pickup_line table (UPS report)
#
FUNCTION ups_insert()

DEFINE ch_pickup RECORD LIKE pickup_line.*

	LET p_pickup.closed = "o"

	SELECT pickup_line.* INTO ch_pickup.* FROM pickup_line
		WHERE invoice_no = p_line.invoice_no AND
		      charge = p_wzp.price AND
		      closed = p_pickup.closed

	IF status = NOTFOUND THEN

		INSERT INTO pickup_line(
			pickup_line.invoice_no, pickup_line.contact, 
			pickup_line.address, 	pickup_line.city, 
			pickup_line.state, 	pickup_line.country, 
			pickup_line.zipcode, 	pickup_line.weight, 
			pickup_line.zone,	pickup_line.charge, 
			pickup_line.commer,
			pickup_line.cod_amt,	pickup_line.cod_chrg,
			pickup_line.pack_no,	pickup_line.closed,
			pickup_line.ship_loc
		) VALUES (
			p_line.invoice_no,	p_cust.contact, 
			s_address.line1,	s_address.city, 
			s_address.state,	s_address.country, 
			s_address.zipcode,	p_wzp.weight,
			p_wzp.zone,		p_wzp.price,
			p_wzp.commer,
			p_pickup.cod_amt,	p_pickup.cod_chrg, 
			1,			p_pickup.closed,
			shiploc
		)	# package number is 1 current report is 'o'
		
		CALL msgs("Row added")
	ELSE
		CALL msgs("Duplicate entry")
	END IF

END FUNCTION	

#
# If somebody does not have invoice we can do report by hands
#
FUNCTION ups_handl()

 	DEFINE ch_pickup RECORD LIKE pickup_line.*

	INPUT BY NAME p_pickup.invoice_no THRU p_pickup.cll

	AFTER FIELD state
		IF p_pickup.state IS NOT NULL THEN
			NEXT FIELD zipcode
		END IF

	AFTER FIELD weight
		IF p_pickup.weight IS NULL THEN
			LET p_pickup.weight = 0
		END IF

		LET p_wzp.weight = p_pickup.weight

	AFTER FIELD zone
		LET p_wzp.zone = p_pickup.zone
		CALL ups_price(p_pickup.commer)
		IF p_wzp.price = 0 THEN
			CALL msgs("Weight or zone number wrong")
			NEXT FIELD weight
		END IF

	AFTER FIELD dec_value
		IF p_pickup.dec_value IS NOT NULL AND 
		       	p_pickup.dec_value < 100.01 THEN
		       	CALL msgs("Declare value should be > $100 or nothing")
		       	NEXT FIELD dec_value
		END IF

	AFTER FIELD aod
		IF p_pickup.aod <> "x" AND p_pickup.aod IS NOT NULL THEN
			CALL msgs("aod could be 'x' or nothing")
			NEXT FIELD aod
		END IF

	AFTER FIELD cll
		IF p_pickup.cll <> "x" AND p_pickup.cll IS NOT NULL THEN
			CALL msgs("Call tag could be 'x' or nothing")
			NEXT FIELD cll
		END IF
		
		IF p_pickup.cll = "x" THEN
			LET p_call.invoice_no = p_invoice.invoice_no
			CALL tag_add()
		END IF

	END INPUT

	LET p_pickup.charge = p_wzp.price
	LET p_pickup.pack_no = 1    # All stuff sent in one package

	IF p_pickup.invoice_no IS NULL THEN
		LET p_pickup.invoice_no = 1 # Defaults without invoice
	END IF
	
	SELECT pickup_line.* INTO ch_pickup.* FROM pickup_line
		WHERE invoice_no = p_pickup.invoice_no AND
		      charge = p_wzp.price AND 
		      closed = "o"
		
	IF status = NOTFOUND THEN
		LET p_pickup.closed = "o"
		LET p_pickup.ship_loc = shiploc
		INSERT INTO pickup_line VALUES(p_pickup.*)

		DISPLAY BY NAME p_pickup.charge

		CALL msgs(" Row was added")
	ELSE 
		CALL msgs("Duplicate entry")
	END IF

END FUNCTION
