#
# Print users with special workf status
#
DATABASE mwc

MAIN
	DEFINE	c RECORD LIKE customer.*
	DEFINE  a RECORD LIKE address.*
	DEFINE  d DATE

	DECLARE curs CURSOR FOR
	 SELECT customer.*, address.*, invoice.invoice_date
	   FROM workf, customer, address, invoice
	  WHERE workf.tbl = 4
	    AND customer.cust_no = workf.cust_no
	    AND invoice.cust_no = workf.cust_no
	    AND address.cust_no = workf.cust_no
	    AND address.country IS NULL

	START REPORT mail_list

	FOREACH curs INTO c.*, a.*, d
		IF (c.cust_no mod 6) == 0 THEN # sample 1 in 6 to get about 1000
			OUTPUT TO REPORT mail_list(c.*, a.*, d)
		END IF
	END FOREACH

	FINISH REPORT mail_list

	CLOSE curs
END MAIN

REPORT mail_list(c, a, d)
	DEFINE  c RECORD LIKE customer.*
	DEFINE  a RECORD LIKE address.*
	DEFINE  d DATE

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY c.cust_no, d

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<", 5 SPACES,
			"Special Customer List", 5 SPACES, TODAY
		SKIP 1 LINE

	AFTER GROUP OF c.cust_no
		PRINT	c.contact, " ",
			c.cust_no USING "<<<<<<", " ",
			c.phone_no, " "
		PRINT	a.line1, " ",
			a.state, " ",
			d			
		SKIP 1 LINE
END REPORT
