DATABASE mwc

GLOBALS
	DEFINE tot, ext, tot1 MONEY(8, 2)
	DEFINE c RECORD LIKE customer.*
	DEFINE a RECORD LIKE address.*
	DEFINE i RECORD LIKE invoice.*
	DEFINE l RECORD LIKE inv_line.*
	DEFINE p RECORD LIKE product.*
	DEFINE ctr INTEGER
END GLOBALS

MAIN
	CALL i_stuff()
	CALL a_stuff()
	CALL l_stuff()
END MAIN

FUNCTION i_stuff()
	DECLARE i_curs CURSOR FOR SELECT * FROM invoice

	START REPORT i_report

	FOREACH i_curs INTO i.*
		OUTPUT TO REPORT i_report(i.*)
	END FOREACH

	FINISH REPORT i_report

	CLOSE i_curs
END FUNCTION

FUNCTION a_stuff()
	DECLARE a_curs CURSOR FOR SELECT * FROM address

	START REPORT a_report

	FOREACH a_curs INTO a.*
		OUTPUT TO REPORT a_report(a.*)
	END FOREACH
	
	FINISH REPORT a_report

	CLOSE a_curs
END FUNCTION

FUNCTION l_stuff()
	DECLARE l_cusr CURSOR FOR SELECT * FROM inv_line

	START REPORT m_report

	FOREACH l_cusr INTO l.*
		OUTPUT TO REPORT m_report(l.*)
	END FOREACH
	
	FINISH REPORT m_report

	CLOSE l_cusr
END FUNCTION

REPORT i_report(i)
	DEFINE i RECORD LIKE invoice.*

	OUTPUT
		REPORT TO PRINTER

	ORDER BY i.cust_no

	FORMAT
	ON EVERY ROW
		SELECT COUNT(*) INTO ctr FROM address
		 WHERE cust_no = i.cust_no AND add_type <> "b"

		IF ctr != 1 THEN
			PRINT 	i.invoice_no, " ",
				i.cust_no, ctr, " address records"
		END IF

		SELECT COUNT(*) INTO ctr FROM customer
		 WHERE cust_no = i.cust_no

		IF ctr != 1 THEN
			PRINT	i.invoice_no, " ",
				i.cust_no, ctr, " customer records"
		END IF

	PAGE HEADER
		PRINT	20 SPACES, "INVOICE MISMATCH REPORT"
		SKIP 2 LINES

	ON LAST ROW
		PRINT	"End of Report"
END REPORT

REPORT a_report(a)
	DEFINE a RECORD LIKE address.*
	DEFINE bsw, ssw SMALLINT

	OUTPUT
		REPORT TO PRINTER
		PAGE LENGTH 60

	ORDER BY a.cust_no

	FORMAT
	BEFORE GROUP OF a.cust_no
		LET bsw = 0
		LET ssw = 0

	ON EVERY ROW
		CASE
		WHEN a.add_type = "x"
			LET bsw = bsw + 1
			LET ssw = ssw + 1

		WHEN a.add_type = "b"
			LET bsw = bsw + 1

		WHEN a.add_type = "s"
			LET ssw = ssw + 1

		OTHERWISE
			PRINT "Bad type ", a.add_type, " ", a.cust_no
		END CASE

	AFTER GROUP OF a.cust_no
		IF bsw <> 1 OR ssw <> 1 THEN
			PRINT a.cust_no, " ", bsw, " ", ssw
		END IF

		LET c.cust_no = NULL
		SELECT cust_no  INTO c.cust_no FROM customer
		 WHERE cust_no = a.cust_no

		IF c.cust_no IS NULL THEN
			PRINT "Missing customer ", a.cust_no
		END IF

	PAGE HEADER
		PRINT	20 SPACES, "ADDRESS MISMATCH REPORT"
		SKIP 2 LINES

	ON LAST ROW
		PRINT	"End of Report"
END REPORT

REPORT m_report(l)
	DEFINE l RECORD LIKE inv_line.*

	OUTPUT
		REPORT TO PRINTER
		PAGE LENGTH 60

	ORDER BY l.invoice_no

	FORMAT
	BEFORE GROUP OF l.invoice_no 
		LET tot = 0
	
	ON EVERY ROW
		LET p.price = NULL

		SELECT price INTO p.price FROM product WHERE prod_no = l.prod_no
		
		LET ext = p.price * l.quantity
		IF ext IS NULL THEN
			PRINT	l.invoice_no, " Bad detail record"
		ELSE
			LET tot = tot + ext
		END IF
	
	AFTER GROUP OF l.invoice_no
		LET i.subtotal = NULL

		SELECT *
		  INTO i.*
		  FROM invoice
		 WHERE invoice.invoice_no = l.invoice_no

		LET tot1 = i.subtotal + i.taxes + i.ship_amt - i.discount
		IF i.itotal <> tot1 OR tot1 IS NULL THEN
			PRINT	l.invoice_no, " bad total"
		END IF
		IF i.invoice_date > TODAY OR
		   i.invoice_date IS NULL OR
		   i.ship_date > TODAY THEN
			PRINT	l.invoice_no, " ",
				i.invoice_date, " ",
				i.ship_date, " wierd date"
		END IF
		IF i.subtotal <> tot THEN
			PRINT	l.invoice_no, " ",
				tot,
				i.subtotal, " Mismatched total"
		END IF
	
	PAGE HEADER
		PRINT	20 SPACES, "DETAIL MISMATCH REPORT"
		PRINT	"Invoice     Detail total     record total"
		SKIP 2 LINES

	ON LAST ROW
		PRINT	"End of Report"
END REPORT
