#
# Code to do mailer file
#
GLOBALS "globals0.4gl"

FUNCTION mail_menu()
	DISPLAY FORM mail_form
	
	LET chosen = FALSE

	MESSAGE "Type the first letter of the option ",
		"you want to select."

	MENU "MAILER"
	COMMAND "Add" "Add a new mailer."
	        LET answer = "y"
	        WHILE answer = "y"
			CALL enter_mail(0)
       
			CALL yn("Enter another mailer <y/n>")
				RETURNING answer
		END WHILE
     
	COMMAND "Query" "Search for a mailer."
		CALL query_mail()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF
	
	COMMAND "Modify" "Modify a mailer."
		IF chosen THEN
			CALL change_mail()
		ELSE
			MESSAGE "No mailer has been chosen. ",
				"Use the Query option to select ",
				"a mailer."
			NEXT OPTION "Query"
      		END IF

	COMMAND "Delete" "Delete a mailer."
		IF chosen THEN
			CALL yn(
			"Are you sure you want to delete this mailer (y/n)")
				RETURNING answer

			IF answer = "y" THEN
				CALL delete_mail()
				LET chosen = FALSE
			END IF
		ELSE
			RUN "dupl_cust.4ge"
		END IF

	COMMAND "Call" "Callback report on mailers"
		CALL call_rpt()
		MESSAGE ""
		EXIT MENU

	COMMAND "Report" "Report on mailers"
		CALL mail_rpt()

	COMMAND "Exit" "Leave the mailer menu."
		MESSAGE ""
		EXIT MENU
	END MENU

	CLEAR SCREEN
END FUNCTION

#
# Mailing labels
#
FUNCTION mail_rpt()
	MESSAGE ""
	CLEAR FORM

	CONSTRUCT BY NAME query1
	       ON customer.cust_no, contact,
		  cust_date, user_id, all_nfo, inq_src,
	       	  address.line1, line2, line3,
		  city, state, country, zipcode

	CALL crunchcon(query1) RETURNING query1

	CALL yn("Mailers only <y/n> ") RETURNING answer

	IF answer == "y" THEN
		LET s1 = "SELECT * FROM customer, address ",
			 " WHERE all_nfo IS NOT NULL",
			 "   AND customer.cust_no = address.cust_no",
			 "   AND ", query1 CLIPPED
	ELSE
		CALL yn("Marked items <y/n> ") RETURNING answer

		IF answer == "y" THEN
		    LET s1 = "SELECT customer.*, address.*",
			 "  FROM marked, invoice, customer, address",
			 " WHERE marked.invoice_no = invoice.invoice_no",
			 "   AND customer.cust_no = invoice.cust_no",
			 "   AND address.cust_no = invoice.cust_no",
			 "   AND address.add_type <> \"s\""
		ELSE
			LET s1 = "SELECT * FROM customer, address",
				 " WHERE customer.cust_no = address.cust_no",
				 "   AND address.add_type <> \"s\"",
				 "   AND ", query1 CLIPPED
		END IF
	END IF

	PREPARE s_2 FROM s1

	DECLARE rp_curs CURSOR FOR s_2

	MESSAGE ""

	START REPORT mail_list

	FOREACH rp_curs INTO p_cust.*, s_address.*
		OUTPUT TO REPORT mail_list (p_cust.*, s_address.*)
	END FOREACH

	FINISH REPORT mail_list

	CLOSE rp_curs
END FUNCTION

#
# mailing labels
#
REPORT mail_list (p_cust, p_add)
	DEFINE p_cust RECORD LIKE customer.*
	DEFINE p_add  RECORD LIKE address.*

	OUTPUT
		REPORT TO PIPE "mform | lp"
#		REPORT TO "test.data"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY p_cust.cust_no

	FORMAT
	ON EVERY ROW		
		PRINT	p_cust.contact CLIPPED,
			p_cust.cust_no USING "######"
		PRINT	p_add.line1 CLIPPED
		PRINT	p_add.line2 CLIPPED
		PRINT	p_add.line3 CLIPPED
		CALL	addline(p_add.*) RETURNING s1
		PRINT	s1 CLIPPED
		PRINT	p_add.country CLIPPED

	ON LAST ROW
		SKIP 5 LINES
END REPORT

#
# Callback Report
#
FUNCTION call_rpt()
	MESSAGE ""

	CLEAR FORM

	CONSTRUCT BY NAME query1 ON cust_date

	CALL yn("Fax report <y/n>") RETURNING answer

	LET s1 = "SELECT * FROM customer, OUTER invoice",
		 " WHERE customer.cust_no = invoice.cust_no",
		 "   AND ", query1 CLIPPED

	PREPARE s_3 FROM s1

	DECLARE cb_curs CURSOR FOR s_3

	MESSAGE ""

	START REPORT call_list

	FOREACH cb_curs INTO p_cust.*, p_invoice.*
		IF p_invoice.invoice_no IS NULL AND
		   p_cust.all_nfo != "x" THEN
			IF p_cust.phone_no MATCHES "*fax*" THEN
				IF answer = "y" THEN
					OUTPUT TO REPORT call_list (p_cust.*)
				END IF
			ELSE
				IF answer != "y" THEN
					OUTPUT TO REPORT call_list (p_cust.*)
				END IF
			END IF
		END IF
	END FOREACH

	FINISH REPORT call_list

	CLOSE cb_curs
END FUNCTION

#
# Call back list
#
REPORT call_list(p_cust)
	DEFINE p_cust RECORD LIKE customer.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY p_cust.cust_date

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<", 20 SPACES,
			"Callback Report", 20 SPACES, TODAY
		PRINT	query1 CLIPPED
		SKIP 2 LINES

	BEFORE GROUP OF p_cust.cust_date
		IF p_cust.cust_date IS NOT NULL THEN
			PRINT	p_cust.cust_date
		END IF

	ON EVERY ROW
		PRINT	p_cust.cust_no USING "######", " ",
			p_cust.contact,
			p_cust.phone_no
		SKIP 1 LINE
END REPORT

FUNCTION enter_mail(regsw)
	DEFINE fsw, regsw INTEGER

	MESSAGE ""
	CLEAR FORM
	INPUT BY NAME	p_cust.contact,
			p_cust.phone_no,
			p_cust.all_nfo,
			p_cust.inq_src,
			s_address.line1,
			s_address.line2,
			s_address.line3,
			s_address.city,
			s_address.state,
			s_address.country,
			s_address.zipcode

	AFTER FIELD inq_src
		SELECT mag_name INTO p_mag.mag_name FROM magazines
		 WHERE magazines.inq_src = p_cust.inq_src 

		IF status = NOTFOUND THEN
			NEXT FIELD  inq_src
		END IF

		DISPLAY BY NAME p_mag.mag_name

	AFTER FIELD contact
		IF p_cust.contact IS NULL THEN
			NEXT FIELD contact
		END IF
	AFTER FIELD country
		CALL find_state(s_address.state, s_address.country)
			RETURNING fsw
		IF fsw = 0 THEN
			NEXT FIELD state
		END IF
	END INPUT

	IF regsw == 1 THEN
		LET p_cust.all_nfo= NULL
	END IF

	LET p_cust.cust_no =  0
	LET s_address.add_type = "x"
	LET p_cust.user_id = user_id
	LET p_cust.cust_date = TODAY

	CALL cruncher(p_cust.contact) RETURNING p_cust.crunch
	INSERT INTO customer VALUES (p_cust.*)

	LET p_cust.cust_no = SQLCA.SQLERRD[2]
	LET s_address.cust_no = p_cust.cust_no
	DISPLAY BY NAME p_cust.cust_no

	INSERT INTO address VALUES (s_address.*)

	MESSAGE "Row added."
END FUNCTION

FUNCTION query_mail()
	DEFINE  p_name CHAR(30),
		answer CHAR(1),
		exist SMALLINT

	MESSAGE ""
	CLEAR FORM

	INPUT BY NAME p_shipreg.ser_no

	IF p_shipreg.ser_no IS NOT NULL THEN
		LET s1 = "SELECT * FROM customer, address, shipreg ",
			 "WHERE shipreg.ser_no=\"",
			 p_shipreg.ser_no USING "<<<<<<<<<",
			 "\" AND customer.cust_no = shipreg.cust_no",
			 " AND address.cust_no = shipreg.cust_no"
	ELSE
		CONSTRUCT BY NAME query1
		       ON customer.cust_no, contact, cust_date,
		          phone_no, all_nfo, inq_src, user_id,
	       		  address.line1, line2, line3,
			  city, state, country, zipcode

		CALL crunchcon(query1) RETURNING query1

		LET s1 = "SELECT * FROM customer, address, ",
			 "OUTER shipreg WHERE ",
			 "customer.cust_no = address.cust_no AND ",
			 "shipreg.cust_no = customer.cust_no AND ",
			 query1 CLIPPED
	END IF

	PREPARE s_1 FROM s1

	DECLARE ma_curs CURSOR FOR s_1

	LET exist = FALSE
	LET chosen = FALSE

	FOREACH ma_curs INTO p_cust.*, s_address.*, p_shipreg.*
		LET exist = TRUE

		DISPLAY BY NAME p_cust.cust_no THRU p_cust.cust_date
		DISPLAY BY NAME s_address.line1 THRU s_address.zipcode
		DISPLAY BY NAME p_shipreg.ser_no

		SELECT mag_name INTO p_mag.mag_name FROM magazines
		 WHERE magazines.inq_src = p_cust.inq_src 

		DISPLAY BY NAME p_cust.inq_src, p_mag.mag_name

		LET s_address.cust_no = p_cust.cust_no
		LET s_address.add_type = "x"

		CALL yn("Enter 'y' to select this mailer")
			RETURNING answer

       	   	IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE ma_curs

	IF exist = FALSE THEN
		MESSAGE "No mailer rows found."
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "There are no more mailer rows."
		END IF
	END IF
END FUNCTION

FUNCTION change_mail()
	DEFINE fsw INTEGER

	MESSAGE ""
	INPUT BY NAME	p_cust.contact,
			p_cust.phone_no,
			p_cust.cust_date,
			p_cust.all_nfo,
			p_cust.inq_src,
			s_address.line1,
			s_address.line2,
			s_address.line3,
			s_address.city,
			s_address.state,
			s_address.country,
			s_address.zipcode	WITHOUT DEFAULTS

	AFTER FIELD inq_src
		SELECT mag_name INTO p_mag.mag_name FROM magazines
		 WHERE magazines.inq_src = p_cust.inq_src 

		IF status = NOTFOUND THEN
			NEXT FIELD  inq_src
		END IF

		DISPLAY BY NAME p_mag.mag_name

	BEFORE FIELD all_nfo
		MESSAGE "x to delete from mailing list"

	AFTER FIELD all_nfo
		MESSAGE ""

	AFTER FIELD contact
		IF p_cust.contact IS NULL THEN
			NEXT FIELD contact
		END IF
	AFTER FIELD country
		CALL find_state(s_address.state, s_address.country)
			RETURNING fsw
		IF fsw = 0 THEN
			NEXT FIELD state
		END IF
	END INPUT

	CALL cruncher(p_cust.contact) RETURNING p_cust.crunch
	UPDATE customer
		SET customer.* = p_cust.*
		WHERE cust_no = p_cust.cust_no

	UPDATE address
		SET address.* = s_address.*
		WHERE cust_no = p_cust.cust_no
END FUNCTION 

FUNCTION delete_mail()
	DELETE FROM customer WHERE cust_no = p_cust.cust_no
	DELETE FROM address  WHERE cust_no = p_cust.cust_no
	CLEAR FORM
END FUNCTION 
