#
# Code to handle the freight file
#
GLOBALS "globals0.4gl"

FUNCTION freight_menu()
	DISPLAY FORM freight_form

	LET chosen = FALSE

	MENU "TERMS"
	COMMAND "Add" "Add a new freight"
		LET answer = "y"
		WHILE answer = "y"
			CALL enter_freight(0)

			CALL yn("Enter another row <y/n>")
				RETURNING answer
		END WHILE

	COMMAND "Query" "Search for a freight"
		CALL query_freight()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF

	COMMAND "Modify" "Modify a freight"
		IF chosen THEN
			CALL enter_freight(1)
		ELSE
			MESSAGE "Use query first "
			NEXT OPTION "Query"
		END IF

	COMMAND "Delete" "Delete a freight"
		IF chosen THEN
			CALL yn("Are you sure <y/n>") RETURNING answer

			IF answer = "y" THEN
				CALL delete_freight()
				LET chosen = FALSE
			END IF
		ELSE
			MESSAGE "Use query first "
			NEXT OPTION "Query"
		END IF

	COMMAND "Report" "Print all MWC Freight Classes"
		DECLARE f_curs CURSOR FOR
		 SELECT * FROM freight

		MESSAGE ""

		START REPORT freight_rep

		FOREACH f_curs INTO p_freight.*
			OUTPUT TO REPORT freight_rep(p_freight.*)
		END FOREACH

		FINISH REPORT freight_rep

		CLOSE f_curs

	COMMAND "Exit" "Leave the freight menu"
		EXIT MENU
	END MENU

	CLEAR SCREEN
END FUNCTION

REPORT freight_rep(f)
	DEFINE f RECORD LIKE freight.*
	
	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY f.ship_no, f.dest_no, f.prod_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<", 10 SPACES,
			"MWC Freight Charge Constants",
			10 SPACES, TODAY
		PRINT	"Prod    Shipper    Dest     Const     per/lb"
		SKIP 2 LINES

	ON EVERY ROW
		PRINT	f.prod_no USING "####", 8 SPACES,
			f.ship_no USING "###", 5 SPACES,
			f.dest_no USING "###", 2 SPACES,
			f.const_cost USING "#,###.##", 3 SPACES,
			f.lb_cost USING "#,###.##"
END REPORT

FUNCTION enter_freight(sw)
	DEFINE sw SMALLINT

	MESSAGE ""
	CLEAR FORM

	IF sw = 0 THEN
		LET p_freight.prod_no = NULL
		LET p_freight.ship_no = NULL
		LET p_freight.dest_no = NULL
		LET p_freight.const_cost = NULL
		LET p_freight.lb_cost = NULL
	END IF
 
	INPUT BY NAME p_freight.* WITHOUT DEFAULTS
	BEFORE FIELD prod_no
		IF sw = 1 THEN
			NEXT FIELD const_cost
		END IF

	AFTER FIELD prod_no
		IF p_freight.prod_no IS NULL THEN
			NEXT FIELD prod_no
		END IF

		SELECT *
		  INTO p_product.*
		  FROM product
		 WHERE prod_no = p_freight.prod_no

		IF status = NOTFOUND THEN
			NEXT FIELD prod_no
		END IF

		DISPLAY BY NAME	p_product.prod_name,
				p_product.comment1

	AFTER FIELD ship_no
		IF p_freight.ship_no IS NULL THEN
			NEXT FIELD ship_no
		END IF

		SELECT *
		  INTO p_ship.*
		  FROM shippers
		 WHERE ship_no = p_freight.ship_no

		IF status = NOTFOUND THEN
			NEXT FIELD ship_no
		END IF

		DISPLAY BY NAME p_ship.ship_name

	AFTER FIELD dest_no
		IF p_freight.dest_no IS NULL THEN
			NEXT FIELD dest_no
		END IF

		SELECT *
		  INTO p_dest.*
		  FROM dests
		 WHERE dest_no = p_freight.dest_no

		IF status = NOTFOUND THEN
			NEXT FIELD dest_no
		END IF

		DISPLAY BY NAME p_dest.dest_name

		SELECT const_cost, lb_cost
		  INTO p_freight.const_cost, p_freight.lb_cost
		  FROM freight
		 WHERE prod_no = p_freight.prod_no
		   AND ship_no = p_freight.ship_no
		   AND dest_no = p_freight.dest_no

		IF sw = 0 THEN	# Adding record
			IF status != NOTFOUND THEN
				MESSAGE "Duplicate record exists"
				NEXT FIELD dest_no
			END IF
		ELSE
			IF status == NOTFOUND THEN
				MESSAGE "No record exists to modify"
				NEXT FIELD dest_no
			END IF
		END IF

	AFTER FIELD const_cost
		IF p_freight.const_cost IS NULL THEN
			LET p_freight.const_cost = 0
		END IF

	AFTER FIELD lb_cost
		IF p_freight.lb_cost IS NULL THEN
			LET p_freight.lb_cost = 0
		END IF
	END INPUT

	IF sw == 0 THEN
		INSERT INTO freight VALUES (p_freight.*)
		MESSAGE "Row added"
	ELSE
		UPDATE freight
		   SET freight.* = p_freight.*
		 WHERE prod_no = p_freight.prod_no
		   AND ship_no = p_freight.ship_no
		   AND dest_no = p_freight.dest_no
		MESSAGE "Row updated"
	END IF
END FUNCTION

FUNCTION query_freight()
	DEFINE exist SMALLINT,
	       answer CHAR(1)

	CLEAR FORM
	MESSAGE ""

	CONSTRUCT query1 ON freight.* FROM freight.*

	LET s1 = "SELECT * FROM freight WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE t_curs CURSOR FOR s_1

	LET exist = FALSE
	LET chosen = FALSE

	FOREACH t_curs INTO p_freight.*
		LET exist = TRUE

		DISPLAY BY NAME p_freight.*

		CALL yn("Enter 'y' to select this freight")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE t_curs

	IF exist = FALSE THEN
		MESSAGE "No freight rows found"
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "No more rows"
		END IF
	END IF
END FUNCTION

FUNCTION delete_freight()
	DELETE FROM freight
	 WHERE prod_no = p_freight.prod_no
	   AND ship_no = p_freight.ship_no
	   AND dest_no = p_freight.dest_no

	MESSAGE "Row deleted"

	CLEAR FORM
END FUNCTION
