#
# Informix 4GL program to eliminate duplicate entries
# By Vladimir Smelyansky of Mark Williams 10/19/90
#
GLOBALS	 "globals0.4gl"

MAIN

	OPTIONS MESSAGE LINE 22,
		PROMPT LINE 21,
		DELETE KEY CONTROL-K,
		NEXT KEY CONTROL-N,
		PREVIOUS KEY CONTROL-P

	CLEAR SCREEN

	OPEN FORM cur_form FROM "dupl_cust"
	DISPLAY FORM cur_form

	LET answer = "y"

	WHILE answer = "y"
		MESSAGE ""
		CALL ensert()
		MESSAGE ""
		CLEAR FORM
		CALL yn("Next customer <y/n> ") RETURNING answer
		IF answer <> "y" THEN
			EXIT WHILE
		END IF
	END WHILE
END MAIN

FUNCTION ensert()
	DEFINE b_cnt, sc_curr, pa_curr SMALLINT
	DEFINE wrong, correct, ctr INTEGER
	DEFINE nd_items ARRAY[2] OF RECORD
		cust_no LIKE customer.cust_no
	END RECORD
	DEFINE d_items ARRAY[2] OF RECORD
		contact LIKE customer.contact,
		line1	LIKE address.line1,
		line2	LIKE address.line2,
		line3	LIKE address.line3,
		city	LIKE address.city,
		state 	LIKE address.state,
		country LIKE address.country,
		zipcode LIKE address.zipcode,
		all_nfo LIKE customer.all_nfo	# really a fake
	END RECORD

	MESSAGE "Enter customers numbers"

	LET ctr = 0

	INPUT ARRAY nd_items FROM ns_items.*

	AFTER FIELD cust_no
		LET pa_curr = arr_curr()
		LET sc_curr = scr_line()
	
		IF nd_items[pa_curr].cust_no IS NULL THEN
			NEXT FIELD cust_no
		END IF

		SELECT contact
		  INTO d_items[pa_curr].contact
		  FROM customer
		WHERE customer.cust_no = nd_items[pa_curr].cust_no

		SELECT line1,	line2,	line3,	city,
		       state,	country,	zipcode
		   INTO
			d_items[pa_curr].line1,
			d_items[pa_curr].line2,
			d_items[pa_curr].line3,
			d_items[pa_curr].city,
			d_items[pa_curr].state,
			d_items[pa_curr].country,
			d_items[pa_curr].zipcode
		   FROM address
		WHERE address.cust_no = nd_items[pa_curr].cust_no AND
			address.add_type <> "s"
		
		IF status = NOTFOUND THEN
			EXIT INPUT
		END IF

		# Flag customer if backordered items
		LET d_items[pa_curr].all_nfo = NULL
		SELECT COUNT(*) INTO b_cnt FROM invoice
		 WHERE cust_no = nd_items[pa_curr].cust_no
		   AND back_flag = 1
		IF b_cnt IS NOT NULL AND b_cnt > 0 THEN
			LET d_items[pa_curr].all_nfo = "B"
		END IF

		DISPLAY d_items[pa_curr].contact,
			d_items[pa_curr].line1,
			d_items[pa_curr].line2,
			d_items[pa_curr].line3,
			d_items[pa_curr].city,
			d_items[pa_curr].state,
			d_items[pa_curr].country,
			d_items[pa_curr].zipcode,
			d_items[pa_curr].all_nfo
		     TO s_items[sc_curr].contact,
			s_items[sc_curr].line1,
			s_items[sc_curr].line2,
			s_items[sc_curr].line3,
			s_items[sc_curr].city,
			s_items[sc_curr].state,
			s_items[sc_curr].country,
			s_items[sc_curr].zipcode,
			s_items[sc_curr].all_nfo
		LET wrong = nd_items[1].cust_no
		LET correct = nd_items[2].cust_no
		LET ctr = ctr + 1
	END INPUT

	MESSAGE ""

	IF wrong == correct OR ctr != 2 THEN
		LET answer = "n"
		MESSAGE "Wrong customer's numbers "
	ELSE
		CALL yn1(wrong) RETURNING answer
	END IF

	IF answer = "y" THEN
		CALL do_job(wrong, correct)
	ELSE 
		CALL yn("Enter to continue") RETURNING answer
	END IF

	CLEAR FORM
END FUNCTION

#
# Remove duplicate entries
#
FUNCTION do_job(wrong, correct)
	DEFINE wrong, correct	INTEGER
	DEFINE loday DATE

	DELETE FROM customer WHERE cust_no = wrong

	DELETE FROM address WHERE cust_no = wrong

	UPDATE invoice
	   SET invoice.cust_no = correct
	   WHERE cust_no = wrong	

	UPDATE regcard
	   SET cust_no = correct
	   WHERE cust_no = wrong	

	UPDATE newreg
	   SET cust_no = correct
	   WHERE cust_no = wrong	

	SELECT MIN(invoice.invoice_date)
	  INTO loday
	  FROM invoice
	 WHERE invoice.cust_no = correct
	IF status != NOTFOUND THEN
		UPDATE regcard
		   SET reg_date = loday
		 WHERE cust_no = correct

		UPDATE newreg
		   SET reg_date = loday
		 WHERE cust_no = correct
	END IF

	UPDATE shipreg
	   SET shipreg.cust_no = correct
	   WHERE cust_no = wrong	

	UPDATE bad_disk
	   SET bad_disk.cust_no = correct
	   WHERE cust_no = wrong	

END FUNCTION

#
# Display a prompt and get a y or n
#
FUNCTION yn(msg)
	DEFINE msg CHAR(50)
	DEFINE ans CHAR(1)

	LABEL loop:
		PROMPT msg CLIPPED, " " FOR ans
		IF ans IS NULL THEN
			RETURN "n"
		END IF
		IF ans = "y" OR ans = "n" THEN
			RETURN ans
		END IF
	GOTO loop

END FUNCTION

#
# Display a prompt and get a y or n
#
FUNCTION yn1(wrong)
	DEFINE msg CHAR(50)
	DEFINE wrong INTEGER
	DEFINE ans CHAR(1)

	LABEL loop:
		PROMPT "Eliminate customer's number <y/n>: ", wrong FOR ans
		IF ans IS NULL THEN
			RETURN "n"
		END IF
		IF ans = "y" OR ans = "n" THEN
			RETURN ans
		END IF
	GOTO loop

END FUNCTION
