#
# Code for credit memos
#
GLOBALS "globals0.4gl"

MAIN
	OPTIONS MESSAGE LINE 22,
		PROMPT LINE 21,
		DELETE KEY CONTROL-V,
		NEXT KEY CONTROL-N,
		PREVIOUS KEY CONTROL-P

	CASE
	WHEN arg_val(1) = "credit"
		CALL credit_menu()
	WHEN arg_val(1) = "payment"
		CALL pay_menu()
	WHEN arg_val(1) = "auth"
		CALL auth_menu()
	END CASE
END MAIN

FUNCTION credit_menu()
	OPEN FORM cred_form FROM "credit"
	DISPLAY FORM cred_form

	LET chosen = FALSE

	MENU "CREDIT"
	COMMAND "Add" "Enter a credit memo."
	        LET answer = "y"
	        WHILE answer = "y"
			CALL enter_memo()
       
			CALL yn("Do you want to enter another credit memo <y/n>")
				RETURNING answer
		END WHILE
     
	COMMAND "Query" "Search for a credit memo."
		CALL query_memo()

		IF chosen THEN
			CALL mod_credit_menu()

			LET chosen = FALSE
		END IF

	COMMAND "Card" "Credit card batch"
		MESSAGE ""
		CLEAR FORM
		CALL card_bat()

	COMMAND "Report" "Report on all credit memos"
		CALL memo_report()

	COMMAND "Exit" "Leave the credit memo menu."
		EXIT MENU
	END MENU

	CLOSE FORM cred_form
	CLEAR SCREEN
END FUNCTION

FUNCTION mod_credit_menu()
	MENU "Modify"
	COMMAND "Modify" "Modify a credit memo."
		CALL change_memo()
		EXIT MENU


	COMMAND "Fix" "Enter a reference and batch number"
		IF user_id != "asia" AND
		   user_id != "chris" AND
		   user_id != "nancy" THEN
			MESSAGE "No permission"
			EXIT MENU
		END IF

		INPUT BY NAME	p_memo.batch_ix,
				p_memo.ref_no,
				p_memo.tym_flag	WITHOUT DEFAULTS
		AFTER FIELD batch_ix
			IF p_memo.batch_ix IS NOT NULL THEN
				SELECT *
				  INTO p_batch.*
				  FROM batch
				 WHERE batch_ix = p_memo.batch_ix

				IF status = NOTFOUND THEN
					MESSAGE "Batch not found"
					NEXT FIELD batch_ix
				END IF
			END IF
		END INPUT

		UPDATE	cmemo
		   SET	tym_flag = p_memo.tym_flag,
			ref_no = p_memo.ref_no,
			batch_ix = p_memo.batch_ix
		 WHERE	memo_no = p_memo.memo_no
		EXIT MENU

	COMMAND "Void" "Send a void message to tymnet"
		LET p_memo.tym_flag = 5
		DISPLAY BY NAME p_memo.tym_flag
		UPDATE cmemo
		   SET tym_flag = p_memo.tym_flag
		 WHERE memo_no = p_memo.memo_no
		EXIT MENU

	COMMAND "Resend" "Try a failed transaction again"
		CALL is_tnet() RETURNING i_no
		IF i_no = TRUE THEN
			LET p_memo.tym_flag = 1
			DISPLAY BY NAME p_memo.tym_flag

			UPDATE cmemo
			   SET tym_flag = p_memo.tym_flag
			 WHERE memo_no = p_memo.memo_no
		ELSE
			MESSAGE "Wrong terms for timenet"
		END IF
		EXIT MENU

	COMMAND "Delete" "Delete a credit memo."
		CALL yn("Are you sure you want to delete this <y/n>")
			RETURNING answer

		IF answer = "y" THEN
			CALL delete_memo()
		END IF
		EXIT MENU		

	COMMAND "Exit" "Don't modify memo"
		EXIT MENU		
	END MENU
END FUNCTION

#
# Credit card batch
#
FUNCTION card_bat()
	LET p_memo.memo_date = TODAY - 1
	LET p_memo.auth_no = 0
	LET p_memo.batch_ix = NULL

	WHILE 1=1
		INPUT BY NAME	p_memo.batch_ix,
				p_memo.auth_no,
				p_memo.memo_date WITHOUT DEFAULTS
		BEFORE FIELD batch_ix
			MESSAGE "Enter our batch number"
		BEFORE FIELD auth_no
			MESSAGE "Enter their batch number"
		BEFORE FIELD memo_date
			MESSAGE "Enter batch date" 
		AFTER FIELD batch_ix
			IF p_memo.batch_ix IS NOT NULL THEN
				SELECT *
				  INTO p_batch.*
				  FROM batch
				 WHERE batch.batch_ix = p_memo.batch_ix

				IF status = NOTFOUND THEN
					MESSAGE "Batch not found"
					NEXT FIELD batch_ix
				END IF

				LET p_memo.auth_no = p_batch.batch_no
				LET p_memo.memo_date = p_batch.batch_date
				DISPLAY BY NAME	p_memo.auth_no,
						p_memo.memo_date
				EXIT WHILE
			END IF

		AFTER FIELD auth_no
			IF p_memo.auth_no IS NULL OR
			   p_memo.auth_no = 0 THEN
				NEXT FIELD auth_no
			END IF

		AFTER FIELD memo_date
			IF p_memo.memo_date IS NULL THEN
				NEXT FIELD memo_date
			END IF

			SELECT *
			  INTO p_batch.*
			  FROM batch
			 WHERE batch_date = p_memo.memo_date
			   AND batch_no = p_memo.auth_no

			IF status = NOTFOUND THEN
				CALL yn("Start a new batch <y/n>")
					RETURNING answer
				IF answer = "n" THEN
					CONTINUE WHILE
				END IF

				INSERT INTO batch VALUES (
					0,
					p_memo.auth_no,
					p_memo.memo_date
				)
				LET p_batch.batch_ix = SQLCA.SQLERRD[2]
			END IF
			LET p_memo.batch_ix = p_batch.batch_ix
			DISPLAY BY NAME p_memo.batch_ix
			EXIT WHILE
		END INPUT
	END WHILE

	WHILE  1 = 1
		MESSAGE "Enter memo no 0 to exit"

		INPUT i_no FROM cmemo.invoice_no

		IF i_no = 0 THEN
			RETURN
		END IF

		SELECT *
		  INTO p_memo.*, p_invoice.*
		  FROM cmemo, invoice
		 WHERE memo_no = i_no
		   AND invoice.invoice_no = cmemo.invoice_no

		IF status = NOTFOUND THEN
			PROMPT i_no, " Not found " FOR answer
		ELSE
			DISPLAY BY NAME	p_invoice.card_no,
					p_invoice.exp_date,
					p_invoice.term_no,
					p_memo.amount

			UPDATE cmemo
			   SET batch_ix = p_batch.batch_ix
			 WHERE memo_no = i_no
		END IF
	END WHILE
END FUNCTION

FUNCTION memo_report()
	DEFINE sw INTEGER

	MENU  "REPORT"
	COMMAND "Account" "Accounting Report"
		CALL yn("print report <y/n>") RETURNING answer

		IF answer == "y" THEN
			LET sw = 0
		ELSE
			LET sw = 2
		END IF

		CONSTRUCT BY NAME query1 ON
			cmemo.memo_no, memo_date, invoice.term_no

		EXIT MENU

	COMMAND "Terms" "Credit memo by terms"
		LET sw = 3

		CONSTRUCT BY NAME query1 ON 
			cmemo.memo_no, memo_date

		EXIT MENU

	COMMAND "Memo" "Print memo sheets"
		WHENEVER ERROR GOTO no_sws
		LOCK TABLE sws IN EXCLUSIVE MODE
		WHENEVER ERROR STOP

		CONSTRUCT BY NAME query1 ON cmemo.memo_no, memo_date

		IF query1 CLIPPED == " 1=1" THEN
			MESSAGE "Inuput error"
			UNLOCK TABLE sws
			RETURN
		END IF

		LET s1 = "SELECT * FROM cmemo, invoice ",
			 " WHERE ", query1 CLIPPED,
			 "   AND cmemo.tym_flag IN (1, 2, 5, 8)",
			 "   AND invoice.invoice_no = cmemo.invoice_no"

		PREPARE s_6 FROM s1

		DECLARE z_curs CURSOR FOR s_6

		LET i_no = 0

		START REPORT y_rep

		FOREACH z_curs INTO p_memo.*, p_invoice.*
			LET i_no = i_no + 1
			LET p_invoice.invoice_no = p_memo.memo_no
			LET p_invoice.itotal = p_memo.amount
			LET p_invoice.tym_flag = p_memo.tym_flag
			LET p_invoice.ref_no = p_memo.ref_no

			CASE
			WHEN p_invoice.tym_flag = 2
				LET p_invoice.tym_flag = 1
			WHEN p_invoice.tym_flag = 8
				LET p_invoice.tym_flag = 5
			END CASE

			OUTPUT TO REPORT y_rep(p_invoice.*)
		END FOREACH

		CLOSE z_curs

		FINISH REPORT y_rep

		IF i_no > 0 THEN
			RUN "tmn -v"

			RUN "date >> TRAN.LOG"
			RUN "cat TBI.DAT >> TRAN.LOG"

			LET i_no = -1

			CALL tyme_in()

			IF i_no != 0 THEN
				PROMPT	"Incomplete session at ", i_no,
					" enter to continue"
				   FOR	answer

				EXIT PROGRAM
			END IF

			RUN "ph LOG.DAT"

			DISPLAY FORM cred_form
		END IF

		UNLOCK TABLE sws

		LET sw = 1

		EXIT MENU
	END MENU

	CLEAR FORM

	LET s1 = "SELECT * FROM cmemo, invoice ",
		 " WHERE ", query1 CLIPPED,
		 "   AND invoice.invoice_no = cmemo.invoice_no"

	PREPARE s_4 FROM s1

	DECLARE rc_curs CURSOR FOR s_4

	MESSAGE ""

	LET finTot[1] = 0
	LET finTot[2] = 0

	CASE
	WHEN sw = 0
		START REPORT memo_list

		FOREACH rc_curs INTO p_memo.*, p_invoice.*
			OUTPUT TO REPORT memo_list(p_memo.*, p_invoice.*)
		END FOREACH

		FINISH REPORT memo_list

	WHEN sw = 2
		START REPORT memo_file

		FOREACH rc_curs INTO p_memo.*, p_invoice.*
			OUTPUT TO REPORT memo_file(p_memo.*, p_invoice.*)
		END FOREACH

		FINISH REPORT memo_file
		run "doscp memo.dat /dev/fd0"

	WHEN sw = 1
		START REPORT memo_sheet

		FOREACH rc_curs INTO p_memo.*, p_invoice.*
			# 2 copys
			OUTPUT TO REPORT memo_sheet (p_memo.*, p_invoice.*)
			OUTPUT TO REPORT memo_sheet (p_memo.*, p_invoice.*)
		END FOREACH

		FINISH REPORT memo_sheet
	WHEN sw = 3
		START REPORT memo_terms

		FOREACH rc_curs INTO p_memo.*, p_invoice.*
			OUTPUT TO REPORT memo_terms (p_memo.*, p_invoice.*)
		END FOREACH

		FINISH REPORT memo_terms
	END CASE

	CLOSE rc_curs

	RETURN

LABEL no_sws:
	PROMPT "Tymenet connection in use " FOR answer
END FUNCTION

REPORT y_rep(i)
	DEFINE i RECORD LIKE invoice.*
	OUTPUT
		REPORT TO PIPE "unblank > IFT.DAT"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	FORMAT
	ON EVERY ROW
		CASE
		WHEN i.tym_flag = 1
			PRINT	"C"
			PRINT	i.invoice_no USING "<<<<<<<"
			PRINT	i.card_no USING "<<<<<<<<<<<<<<<<<"
			PRINT	i.exp_date CLIPPED
			PRINT	i.itotal USING "<<<<<<<<.##"

			UPDATE cmemo
			   SET tym_flag = 2
			 WHERE memo_no = i.invoice_no

		WHEN i.tym_flag = 5
			PRINT	"V"
			PRINT	i.invoice_no USING "<<<<<<<"
			PRINT	i.card_no USING "<<<<<<<<<<<<<<<<<"
			PRINT	i.exp_date CLIPPED
			PRINT	i.itotal USING "<<<<<<<<.##"
			PRINT	i.ref_no USING "<<<<<<<<<<<"

			UPDATE cmemo
			   SET tym_flag = 8
			 WHERE memo_no = i.invoice_no
		END CASE

	ON LAST ROW
		PRINT "B"	# request batch number
		PRINT "#####"
END REPORT

#
# Btymenet report in
#
FUNCTION tyme_in()
	DEFINE eofsw SMALLINT
	DEFINE tran_type CHAR(1)
	DEFINE inf_no CHAR(6)
	DEFINE cupt_code CHAR(6)
	DEFINE reference CHAR(8)
	DEFINE amount CHAR(12)
	DEFINE mess CHAR(80)

	SELECT *
	  INTO p_batch.*
	  FROM batch
	 WHERE batch_date = TODAY
	   AND batch_no = DAY(TODAY)

	IF status = NOTFOUND THEN
		LET p_batch.batch_no = DAY(TODAY)
		LET p_batch.batch_date = TODAY

		INSERT INTO batch VALUES (
			0, p_batch.batch_no, p_batch.batch_date
		)
		LET p_batch.batch_ix = SQLCA.SQLERRD[2]
	END IF

	START REPORT tym_rep
 
	WHILE 1 = 1
		CALL readfile("TBI.DAT")
			RETURNING eofsw, tran_type, inf_no, cupt_code,
				  reference, amount, mess
		IF eofsw == 0 THEN
			EXIT WHILE
		END IF

		OUTPUT TO REPORT
			tym_rep(tran_type, inf_no, cupt_code,
				reference, amount, mess)
	END WHILE

	FINISH REPORT tym_rep
END FUNCTION

REPORT tym_rep(tran_type, inf_no, cupt_code, reference, amount, mess)
	DEFINE tran_type CHAR(1)
	DEFINE inf_no CHAR(6)
	DEFINE cupt_code CHAR(6)
	DEFINE reference CHAR(8)
	DEFINE amount CHAR(12)
	DEFINE mess CHAR(80)
	DEFINE b_no, ct SMALLINT

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<", 10 SPACES,
			"Tymenet transaction report",
			10 SPACES, TODAY, " ", TIME
		SKIP 1 LINE

	ON EVERY ROW
		LET i_no = inf_no

		CASE
		WHEN tran_type == 'B'
			PRINT	"B ", i_no
			LET i_no = 0
			SKIP 1 LINE

		WHEN tran_type == 'v'
			SKIP 1 LINE

			SELECT *
			  INTO p_memo.*
			  FROM cmemo
			 WHERE cmemo_no = i_no

			CASE
			WHEN status = NOTFOUND
				PRINT	"v ", i_no, " NOT FOUND"
			WHEN p_memo.tym_flag != 8
				PRINT	"v ", i_no, " tym flag", 
					p_memo.tym_flag
			OTHERWISE
				UPDATE  cmemo
				   SET	tym_flag = 7
				 WHERE  memo_no = p_memo.memo_no

				PRINT	"v ",
					p_memo.memo_no,
					p_memo.amount
			END CASE
			PRINT	 mess

		WHEN tran_type == 'V'
			#
			# Voided transaction.
			# make 100% discount
			# change inv_line to no product shipped
			# comment is voided
			#
			SELECT *
			  INTO p_memo.*
			  FROM cmemo
			 WHERE memo_no = i_no

			UPDATE  cmemo
			   SET	tym_flag = 6,
				amount = 0,
				com2 = "VOIDED"
			 WHERE  memo_no = p_memo.memo_no

			PRINT	"V ", p_memo.memo_no, " ",
				p_memo.cap_no,
				p_memo.ref_no,
				p_memo.amount

		WHEN tran_type == 'c'
			SKIP 1 LINE

			SELECT *
			  INTO p_memo.*
			  FROM cmemo
			 WHERE memo_no = i_no

			CASE
			WHEN status = NOTFOUND
				PRINT	"c ", i_no, " NOT FOUND"

			WHEN p_memo.tym_flag != 2
				PRINT	"c ", i_no, " tym flag", 
					p_memo.tym_flag

			WHEN reference != "0"  # Duplicate
				SELECT COUNT(*)
				  INTO ct
				  FROM cmemo, invoice
				 WHERE cmemo.batch_ix = p_batch.batch_ix
				   AND invoice.invoice_no = cmemo.invoice_no
				   AND card_no = p_invoice.card_no

				IF ct IS NULL OR ct = 0 THEN
					UPDATE  cmemo
					   SET  cap_no = cupt_code,
						ref_no = reference,
						tym_flag = 3,
						batch_ix = p_batch.batch_ix
					 WHERE  memo_no = p_memo.memo_no

					PRINT	"C ",
						p_memo.memo_no,
						p_memo.invoice_no,
						p_memo.amount
				ELSE
					PRINT	"c ", i_no, " DUPLICATE"
				END IF 

			OTHERWISE
				UPDATE  cmemo
				   SET	tym_flag = 4
				 WHERE  memo_no = p_memo.memo_no

				PRINT	"c ", p_memo.memo_no, p_memo.invoice_no
			END CASE
			PRINT	 mess

		WHEN tran_type == 'C'
			SELECT *
			  INTO p_memo.*
			  FROM cmemo
			 WHERE memo_no = i_no

			CASE
			WHEN status = NOTFOUND
				PRINT	"C ", i_no, " NOT FOUND"

			WHEN p_memo.tym_flag != 2
				PRINT	"C ", i_no, " tym flag", 
					p_memo.tym_flag

			WHEN p_memo.amount != amount
				PRINT	"C ", i_no,
					" amount mismatch? Memo says ",
					p_memo.amount,
					" transaction says ",
					amount

			OTHERWISE
				UPDATE  cmemo
				   SET  cap_no = cupt_code,
					ref_no = reference,
					tym_flag = 3,
					batch_ix = p_batch.batch_ix
				 WHERE  memo_no = p_memo.memo_no

				PRINT	"C ", p_memo.memo_no,
					p_memo.invoice_no,
					p_memo.amount
			END CASE
		OTHERWISE
			PRINT	"Unknown transaction type ", tran_type
		END CASE
END REPORT

#
# credit memo sheets
#
REPORT memo_sheet (p_memo, p_invoice)
	DEFINE  p_memo RECORD LIKE cmemo.*,
		p_invoice RECORD LIKE invoice.*

	OUTPUT
		REPORT TO PIPE "cform | lp"
#		REPORT TO "test.dat"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY p_memo.memo_no

	FORMAT

	ON EVERY ROW
		SELECT * INTO p_cust.* FROM customer
		 WHERE  customer.cust_no = p_invoice.cust_no

		SELECT * INTO s_address.* FROM address
		 WHERE  address.cust_no = p_invoice.cust_no AND
			ADD_TYPE <> "b"

		PRINT	p_cust.contact CLIPPED
		PRINT	s_address.line1 CLIPPED
		PRINT	s_address.line2 CLIPPED
		PRINT	s_address.line3 CLIPPED
		CALL addline(s_address.*) RETURNING s1
		PRINT	s1 CLIPPED
		PRINT	s_address.country CLIPPED

		IF s_address.add_type = "s" THEN
			SELECT * INTO b_address.* FROM address
			  WHERE	cust_no = p_cust.cust_no AND
				add_type <> "s"

			PRINT	b_address.line1 CLIPPED
			PRINT	b_address.line2 CLIPPED
			PRINT	b_address.line3 CLIPPED
			CALL addline(b_address.*) RETURNING s1
			PRINT	s1 CLIPPED
			PRINT	b_address.country CLIPPED
		ELSE
			PRINT	"**-" # no bill to address
		END IF
		PRINT	p_invoice.invoice_date
		PRINT	p_invoice.invoice_no
		PRINT	p_invoice.card_no
		PRINT	p_invoice.exp_date
		PRINT	p_memo.tym_flag USING "&"
		PRINT	p_memo.ref_no USING "<<<<<<<<<<<"
		PRINT	p_memo.auth_no USING "<<<<<<<<<<"
		PRINT	p_memo.memo_no
		PRINT	p_memo.memo_date
		PRINT	p_memo.amount
		PRINT	p_memo.com1
		PRINT	p_memo.com2

	ON LAST ROW
		PRINT	"***"
END REPORT

#
# credit memo report
#
REPORT memo_list (p_memo, p_invoice)
	DEFINE  p_memo RECORD LIKE cmemo.*,
		p_invoice RECORD LIKE invoice.*	

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80
		RIGHT MARGIN 70

	ORDER BY p_memo.invoice_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 16 SPACES,
			"CREDIT MEMO REPORT"
		PRINT	query1 CLIPPED
		PRINT	"memo     date    invoice   amount  terms"
		SKIP 2 LINES

	ON EVERY ROW
		SELECT * INTO p_term.* FROM terms
		 WHERE term_no = p_invoice.term_no

		PRINT	p_memo.memo_no USING "#####", " ",
			p_memo.memo_date, " ",
			p_memo.invoice_no USING "#####",
			p_memo.amount, " ",
			p_term.term_name

		LET finTot[1] = finTot[1] + p_memo.amount

	ON LAST ROW
		SKIP 1 LINE
		PRINT	"Total", 15 SPACES, finTot[1]
END REPORT

#
# credit memo report to disk
#
REPORT memo_file (p_memo, p_invoice)
	DEFINE  p_memo RECORD LIKE cmemo.*,
		p_invoice RECORD LIKE invoice.*	

	OUTPUT
		REPORT TO PIPE "macct"
#		REPORT TO "test.dat"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY p_memo.invoice_no

	FORMAT
	ON EVERY ROW
		SELECT * INTO p_term.* FROM terms
		 WHERE term_no = p_invoice.term_no

		LET p_memo.amount = - p_memo.amount
		PRINT	p_memo.memo_no USING "#####", " ",
			p_memo.memo_date, " ",
			p_memo.invoice_no USING "#####", " ",
			p_memo.amount USING "------.--", " ",
			p_term.term_name
	ON LAST ROW
		PRINT	"***"
END REPORT

#
# credit memo by terms report
#
REPORT memo_terms (p_memo, p_invoice)
	DEFINE  p_memo RECORD LIKE cmemo.*,
		p_invoice RECORD LIKE invoice.*	

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80
		RIGHT MARGIN 70

	ORDER BY p_invoice.term_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 4 SPACES,
			"CREDIT MEMO BY TERMS REPORT"
		PRINT	query1 CLIPPED
		SKIP 2 LINES

	ON EVERY ROW
		LET finTot[1] = finTot[1] + p_memo.amount

	AFTER GROUP OF p_invoice.term_no
		SELECT * INTO p_term.* FROM terms
		 WHERE term_no = p_invoice.term_no

		PRINT	finTot[1], " ", p_term.term_name

		LET finTot[2] = finTot[2] + finTot[1]
		LET finTot[1] = 0

	ON LAST ROW
		SKIP 1 LINE
		PRINT	finTot[2], " Total"
END REPORT

FUNCTION tell_em()
	MESSAGE ctotal, " Credits already on this invoice."
	CALL yn("continue <y/n>") RETURNING answer
	MESSAGE ""
END FUNCTION

FUNCTION show_pay()
	SELECT SUM(amount) INTO ptotal FROM payment
	 WHERE payment.invoice_no = p_invoice.invoice_no

	IF ptotal IS NULL THEN
		LET ptotal = 0
	END IF
END FUNCTION

FUNCTION enter_memo()
	MESSAGE ""
	CLEAR FORM

	# Clear all fields.
	LET p_memo.auth_no = NULL
	LET p_memo.invoice_no = NULL
	LET p_memo.memo_date = TODAY
	LET p_memo.amount = 0
	LET p_memo.com1 = NULL
	LET p_memo.com2 = NULL
	LET p_memo.batch_ix = NULL
	LET p_memo.ref_no = NULL
	LET p_memo.cap_no = NULL
	LET p_memo.tym_flag = NULL

	INPUT BY NAME	p_memo.auth_no,
			p_memo.invoice_no	WITHOUT DEFAULTS
	AFTER FIELD auth_no
		IF p_memo.auth_no IS NOT NULL THEN
			SELECT * INTO p_auth.* FROM auth
			 WHERE auth.auth_no = p_memo.auth_no
			IF status = NOTFOUND THEN
				MESSAGE "Invalid Auth no"
				NEXT FIELD auth_no
			END IF
			LET p_memo.invoice_no = p_auth.invoice_no
		END IF
			
	AFTER FIELD invoice_no
		CALL get_invoice(p_memo.invoice_no)
		IF p_invoice.cust_no IS NULL THEN
			NEXT FIELD invoice_no
		END IF

		SELECT SUM(amount) INTO ctotal FROM cmemo
		 WHERE cmemo.invoice_no = p_memo.invoice_no
		IF ctotal IS NULL THEN
			LET ctotal = 0
		END IF

		IF ctotal <> 0.0 THEN
			CALL tell_em()
			IF answer <> "y" THEN
				RETURN
			END IF
		END IF

		CALL show_pay()

		IF p_invoice.back_flag = 1 OR
		   p_invoice.tym_flag  = 1 THEN
			LET p_memo.amount = p_invoice.itotal - ctotal
		ELSE
			LET p_memo.amount = 	p_invoice.subtotal -
						ctotal - p_invoice.discount
		END IF

		LET p_memo.tym_flag = NULL
		CALL is_tnet() RETURNING i_no
		IF i_no = TRUE THEN
			CALL yn("Send this credit through timenet <y/n> ")
				RETURNING answer
			IF answer = "y" THEN
				LET p_memo.tym_flag = 1
			END IF
		END IF
 
		DISPLAY BY NAME	p_memo.amount,
				p_invoice.bounce,
				p_invoice.term_no,
				p_invoice.card_no,
				p_invoice.exp_date,
				ptotal
	END INPUT

	CALL get_address(1)

	INPUT BY NAME	p_memo.memo_date,
			p_memo.amount,
			p_memo.com1,
			p_memo.com2 WITHOUT DEFAULTS

	LET p_memo.memo_no =  0
	LET p_memo.batch_ix = NULL

	INSERT INTO cmemo VALUES (p_memo.*)
	LET p_memo.memo_no = SQLCA.SQLERRD[2]

	IF p_memo.amount = p_invoice.itotal THEN
		IF p_invoice.back_flag == 1 THEN
			UPDATE invoice SET back_flag = NULL
	        	 WHERE invoice_no = p_invoice.invoice_no
		END IF
		IF p_invoice.tym_flag == 1 THEN
			UPDATE invoice SET tym_flag = NULL
	        	 WHERE invoice_no = p_invoice.invoice_no
		END IF
	END IF

	IF p_memo.auth_no IS NOT NULL THEN
		UPDATE auth SET auth.return_date = p_memo.memo_date
		 WHERE auth.auth_no = p_memo.auth_no
	END IF

	CALL put_address(1)

	DISPLAY BY NAME p_memo.memo_no

	MESSAGE "Row added."
END FUNCTION

FUNCTION query_memo()
	DEFINE  exist SMALLINT

	CLEAR FORM

	CONSTRUCT BY NAME query1 ON
		cmemo.memo_no, auth_no, memo_date, cmemo.invoice_no, amount,
		com1, com2, customer.contact, cmemo.batch_ix, 
		cmemo.ref_no, cmemo.tym_flag

	LET s1 = "SELECT * FROM cmemo, invoice, customer, address",
		 " WHERE invoice.invoice_no = cmemo.invoice_no",
		 "   AND invoice.cust_no = customer.cust_no",
		 "   AND address.cust_no = customer.cust_no",
		 "   AND ", query1 CLIPPED

	PREPARE s_5 FROM s1

	DECLARE qm_curs CURSOR FOR s_5

	LET exist  = FALSE
	LET chosen = FALSE
	
	FOREACH qm_curs INTO p_memo.*, p_invoice.*, p_cust.*, s_address.*
		IF s_address.add_type = "b" THEN
			CONTINUE FOREACH
		END IF
		LET exist = TRUE

		CALL show_pay()

		DISPLAY BY NAME p_memo.memo_no,
				p_memo.auth_no,
				p_memo.memo_date,
				p_memo.invoice_no,
				p_memo.amount,
				p_memo.com1,
				p_memo.com2,
				p_memo.batch_ix,
				p_memo.ref_no,
				p_memo.tym_flag,
				p_cust.contact,
				p_invoice.bounce,
				p_invoice.term_no,
				p_invoice.card_no,
				p_invoice.exp_date,
				ptotal

		DISPLAY BY NAME s_address.line1 THRU s_address.zipcode

		CALL yn("Enter 'y' to select this credit memo ")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE qm_curs

	IF exist = FALSE THEN
		MESSAGE "No credit memo found"
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "No more credit memos."
		END IF
	END IF
END FUNCTION

FUNCTION change_memo()
	MESSAGE ""
	CLEAR FORM
	INPUT BY NAME p_memo.memo_date THRU p_memo.batch_ix
		WITHOUT DEFAULTS

	AFTER FIELD auth_no
		IF p_memo.auth_no IS NOT NULL THEN
			SELECT * INTO p_auth.* FROM auth
			 WHERE auth.auth_no = p_memo.auth_no
			IF status = NOTFOUND THEN
				MESSAGE "Auth no not found"
				NEXT FIELD auth_no
			END IF
		END IF
			
	AFTER FIELD invoice_no
		CALL get_invoice(p_memo.invoice_no)
		IF p_invoice.cust_no IS NULL THEN
			NEXT FIELD invoice_no
		END IF
	END INPUT

	CALL get_address(1)

	UPDATE cmemo SET cmemo.* = p_memo.*
	 WHERE cmemo.memo_no = p_memo.memo_no

	CALL put_address(1)

	DISPLAY BY NAME p_memo.memo_no

	MESSAGE "Row changed."
END FUNCTION 

FUNCTION delete_memo()
	DELETE FROM cmemo WHERE cmemo.memo_no = p_memo.memo_no
	CLEAR FORM
END FUNCTION 
