DATABASE mwc

MAIN

	DEFINE
		customer_no	INTEGER,
		product_no	SMALLINT,
		inv_no		INTEGER

	WHENEVER ERROR CONTINUE
		DROP TABLE cprodlst
	WHENEVER ERROR STOP

	CREATE TABLE cprodlst (
		cust_no		INTEGER,
		invoice_no	INTEGER,
		prod_no		SMALLINT
	)


	DECLARE my_curs CURSOR FOR

		SELECT invoice.cust_no, invoice.invoice_no,inv_line.prod_no
		INTO customer_no, inv_no, product_no
		FROM invoice, inv_line
		WHERE inv_line.invoice_no = invoice.invoice_no
		ORDER BY invoice.cust_no

	FOREACH my_curs

		INSERT INTO cprodlst
			VALUES (customer_no, inv_no, product_no)

	END FOREACH


	CREATE INDEX i_cprod ON cprodlst(cust_no ASC)
	CREATE INDEX i_cinv  ON cprodlst(invoice_no)

END MAIN
