#
# Bad media system. Release 2
#
GLOBALS "globals0.4gl"

FUNCTION bad_disk()
	DISPLAY FORM bad_disk

	LET chosen = FALSE

	MENU ""
	COMMAND "Find" "Find customer"
		CALL find_customer()
		IF chosen THEN
			IF p_bad.baddisk_no IS NOT NULL THEN
				NEXT OPTION "Modify"
			ELSE
				NEXT OPTION "Add"
			END IF
		ELSE
			MESSAGE "No customer has been chosen"
		END IF

	COMMAND "Add" "Add new row in bad media database"
		IF chosen THEN
			CALL add_baddisk()
			LET chosen = FALSE
		ELSE
			MESSAGE "No entry has been shosen. Use find to select."
			NEXT OPTION "Find"
		END IF

	COMMAND "Modify" "Modify information about bad media"
		IF chosen AND p_bad.baddisk_no IS NOT NULL THEN
			CALL modify_row()
			LET chosen = FALSE
		ELSE
			MESSAGE "No entry has been shosen. Use find to select."
			NEXT OPTION "Find"
		END IF

	COMMAND "Delete" "Delete row"
		IF chosen THEN
			CALL del_row()
			LET chosen = FALSE
		ELSE
			MESSAGE "No entry has been shosen. Use find to select."
			NEXT OPTION "Find"
		END IF

	COMMAND "Reports" "Reports about bad media"
		CALL report_menu()
	COMMAND "Exit" "Exit from bad media database"
		EXIT MENU

	END MENU

	CLEAR FORM
END FUNCTION

#
# find customer
#
FUNCTION find_customer()
	DEFINE  exist 	SMALLINT,
		sh   	SMALLINT,
		answer 	CHAR(1)

	CLEAR FORM
	MESSAGE ""

	INPUT BY NAME p_shipreg.ser_no

	IF p_shipreg.ser_no IS NOT NULL THEN

		LET s1 = "SELECT * FROM customer, invoice, shipreg, address",
			 ", OUTER bad_disk WHERE shipreg.ser_no =\"",
			 p_shipreg.ser_no,
			 "\" AND customer.cust_no = shipreg.cust_no",
			 " AND invoice.cust_no = shipreg.cust_no",
			 " AND address.cust_no = shipreg.cust_no",
			 " AND address.add_type <> \"b\"",
			 " AND bad_disk.cust_no = shipreg.cust_no"
	ELSE
		CONSTRUCT query1 ON
			invoice.invoice_no, contact, invoice.cust_no,
			phone_no, zipcode, line1, line2, line3, city, 
			state, country, invoice_date, ship_date
		FROM
			invoice.invoice_no, contact, invoice.cust_no,
			phone_no, zipcode, line1, line2, line3, city, 
			state, country, invoice_date, ship_date

		CALL crunchcon(query1) RETURNING query1

		LET s1 = "SELECT * FROM customer, invoice, OUTER shipreg, ",
			 "address, OUTER bad_disk WHERE ", 
			 "invoice.cust_no = address.cust_no AND ",
			 "customer.cust_no = invoice.cust_no AND ",
			 "shipreg.cust_no = customer.cust_no AND ",
			 "bad_disk.cust_no = customer.cust_no AND ",
			 "address.add_type <> \"b\" AND ",
			 query1 CLIPPED
	END IF

	PREPARE s_1 FROM s1

	DECLARE r_curs CURSOR FOR s_1 

	LET exist  = FALSE
	LET chosen = FALSE
	LET p_bad.ship_no = NULL
	
	FOREACH r_curs INTO p_cust.*, p_invoice.*, p_shipreg.*, s_address.*, 
	 							 	p_bad.*
		LET exist = TRUE

		IF p_bad.ship_no IS NOT NULL THEN
			SELECT * INTO p_ship.* FROM shippers
			 WHERE	ship_no = p_bad.ship_no
		ELSE
		   	LET p_ship.ship_name = NULL
		END IF

		IF p_bad.prod_no IS NOT NULL THEN
			SELECT * INTO p_product.* FROM product
			 WHERE prod_no = p_bad.prod_no	
		ELSE
			LET p_product.prod_name = NULL
			LET p_product.comment1 = NULL
		END IF
	
		IF p_bad.call_d IS NULL THEN
			LET p_bad.call_d = TODAY
		END IF

		DISPLAY BY NAME p_invoice.invoice_no,
				p_cust.cust_no,
				p_cust.contact,
				p_cust.phone_no,
				p_invoice.invoice_date,
				p_invoice.ship_date,
				p_bad.ship_no,
				p_ship.ship_name,
				s_address.line1,
				s_address.line2,
				s_address.line3,
				s_address.city,
				s_address.state,
				s_address.country,
				s_address.zipcode,
				p_shipreg.ser_no,
				p_product.prod_name,
				p_product.prod_no,
				p_product.comment1,
				p_bad.call_d THRU p_bad.controller 
				
		CALL yn("Enter 'y' to select this invoice")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE r_curs

	IF exist = FALSE THEN
		MESSAGE "No invoice found"
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "No more invoices."
		END IF
	END IF
END FUNCTION

#
# To add row in bad_disk table
#
FUNCTION add_baddisk()
	
	LET p_bad.cust_no = p_cust.cust_no
	LET p_bad.ser_no = p_shipreg.ser_no

	INPUT BY NAME p_bad.ser_no THRU p_bad.i_msgs
	  WITHOUT DEFAULTS

	AFTER FIELD disk
		IF p_bad.disk IS NULL THEN
			MESSAGE "Enter disk number"
			NEXT FIELD disk
		END IF

	AFTER FIELD prod_no
		IF p_bad.prod_no IS NULL THEN
			MESSAGE "Enter number of product"
			NEXT FIELD prod_no
		END IF
	
		SELECT * INTO p_product.* FROM product
		 WHERE prod_no = p_bad.prod_no

		IF p_product.prod_name IS NULL THEN
			MESSAGE "Bad product number"
			NEXT FIELD prod_no
		END IF

		DISPLAY BY NAME p_product.prod_name, p_product.comment1

	AFTER FIELD ship_no
		IF p_bad.ship_no IS NOT NULL THEN
			SELECT * INTO p_ship.* FROM shippers
			 WHERE ship_no = p_bad.ship_no

			DISPLAY BY NAME p_ship.ship_name
		END IF

	END INPUT

	SELECT * FROM bad_disk
	 WHERE cust_no = p_cust.cust_no AND prod_no = p_bad.prod_no

	IF status = NOTFOUND THEN
		INSERT INTO bad_disk VALUES (0, p_shipreg.ser_no, 
			     p_invoice.cust_no, p_bad.call_d THRU p_bad.i_msgs)
		MESSAGE "Row added"
	ELSE
		MESSAGE "Duplicate entry."
	END IF 
END FUNCTION

#
# To modify information in bad_disk table
#
FUNCTION modify_row()
	MESSAGE ""

	INPUT BY NAME p_bad.ser_no THRU p_bad.i_msgs
		WITHOUT DEFAULTS

	AFTER FIELD disk
		IF p_bad.disk IS NULL THEN
			MESSAGE "Enter disk number"
		END IF
	AFTER FIELD prod_no
		IF p_bad.prod_no IS NULL THEN
			MESSAGE "Enter number of product"
			NEXT FIELD prod_no
		END IF
	
		SELECT * INTO p_product.* FROM product
		 WHERE prod_no = p_bad.prod_no

		IF p_product.prod_name IS NULL THEN
			MESSAGE "Bad product number"
			NEXT FIELD prod_no
		END IF

		DISPLAY BY NAME p_product.prod_name, p_product.comment1

	AFTER FIELD ship_no
		IF p_bad.ship_no IS NOT NULL THEN
			SELECT * INTO p_ship.* FROM shippers
			 WHERE ship_no = p_bad.ship_no

			DISPLAY BY NAME p_ship.ship_name
		END IF
	END INPUT

	UPDATE bad_disk
	 SET bad_disk.* = p_bad.*
	 WHERE baddisk_no = p_bad.baddisk_no

	MESSAGE "Row modified"
END FUNCTION

#
# Delete row
#
FUNCTION del_row()
	MESSAGE ""
	CALL yn("Delete this row ? ") RETURNING answer
	IF answer = "y" THEN
		DELETE FROM bad_disk
		 WHERE baddisk_no = p_bad.baddisk_no
	
		CLEAR FORM
	
		MESSAGE "Row deleted"
	END IF
END FUNCTION


