#
# Display and integrate aet namelist
#
GLOBALS "globals0.4gl"

MAIN
	OPEN FORM aet_form FROM "aet"
	DISPLAY FORM aet_form

	MENU "AES"
	COMMAND "show" "show aet records"
		CALL aet_show()
		EXIT MENU
	COMMAND "merge" "merge aet records"
		CALL aet_merge()
		EXIT MENU
	END MENU
END MAIN

#
# merge aet records with customer records
#
FUNCTION aet_merge()
	DEFINE p_aet RECORD LIKE aet.*
	DEFINE ct SMALLINT

	DECLARE curs CURSOR FOR
	 SELECT * FROM aet

	FOREACH curs INTO p_aet.*
		LET s_address.state = NULL
		IF p_aet.country IS NULL THEN
			LET s_address.country = "UK"
		ELSE
			SELECT COUNT(*)
			  INTO ct
			  FROM states
			 WHERE state = p_aet.country

			IF ct IS NULL OR ct == 0 THEN
				LET s_address.country = "UK"
			ELSE
				LET s_address.country = p_aet.country
			END IF
		END IF

		LET s_address.line2 = NULL
		LET s_address.line3 = NULL
		IF p_aet.line1 IS NULL THEN
			IF p_aet.line2 IS NULL THEN
				IF p_aet.line3 IS NULL THEN
					CONTINUE FOREACH
				ELSE
					LET s_address.line1 = p_aet.line3
				END IF
			ELSE
				LET s_address.line1 = p_aet.line2
				LET s_address.line2 = p_aet.line3
			END IF
		ELSE
			LET s_address.line1 = p_aet.line1
			LET s_address.line2 = p_aet.line2
			LET s_address.line3 = p_aet.line3
		END IF
		LET s_address.zipcode = p_aet.zip
		LET s_address.city = p_aet.line4
		LET s_address.add_type = "x"

		LET p_cust.cust_no = 0
		LET p_cust.contact = p_aet.contact
		LET p_cust.phone_no = p_aet.phone_no 
		LET p_cust.all_nfo = "n"
		LET p_cust.user_id  = "aet"
		LET p_cust.cust_date = TODAY
		CALL cruncher(p_cust.contact) RETURNING p_cust.crunch

		INSERT INTO customer VALUES (p_cust.*)

		LET s_address.cust_no = SQLCA.SQLERRD[2]
		INSERT INTO address VALUES (s_address.*)
	END FOREACH
END FUNCTION

#
# Show aet records off so I can write aet_merge()
#
FUNCTION aet_show()
	DEFINE p_aet RECORD LIKE aet.*
	DEFINE ans CHAR(1)

	CONSTRUCT BY NAME query1 ON aet.*	

	LET s1 = "SELECT * FROM aet WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE s_curs CURSOR FOR s_1

	FOREACH s_curs INTO p_aet.*
		DISPLAY by name p_aet.*

		PROMPT "Enter to continue " FOR ans
		IF ans == "n" THEN
			RETURN
		END IF
	END FOREACH
END FUNCTION
