/*
 * sound_dma.c
 * Original SB16 implementation done by Alex Nash.
 *
 * DSP DMA ugliness.
 *
 */

#include	<sys/coherent.h>

#include 	<sys/cred.h>
#include 	<sys/devices.h>
#include 	<sys/errno.h>
#include 	<sys/file.h>
#include 	<sys/sound.h>
#include 	<sys/stat.h>

/*--------------------------------------------------------------------------*/
/*	16-bit DMA controller ports												*/
/*--------------------------------------------------------------------------*/
#define 	DMA16_WR_SINGLE			0xD4
#define 	DMA16_FLIP_FLOP			0xD8
#define 	DMA16_MODE				0xD6
#define 	DMA16_CH5_PAGE			0x8B
#define 	DMA16_CH5_BASE			0xC4
#define 	DMA16_CH5_COUNT			0xC6
#define 	DMA16_CH6_PAGE			0x89
#define 	DMA16_CH6_BASE			0xC8
#define 	DMA16_CH6_COUNT			0xCA
#define 	DMA16_CH7_PAGE			0x8A
#define 	DMA16_CH7_BASE			0xCC
#define 	DMA16_CH7_COUNT			0xCE

/*--------------------------------------------------------------------------*/
/*	8-bit DMA controller ports												*/
/*--------------------------------------------------------------------------*/
#define 	DMA8_WR_SINGLE			0x0A
#define 	DMA8_FLIP_FLOP			0x0C
#define 	DMA8_MODE				0x0B
#define 	DMA8_CH0_PAGE			0x87
#define		DMA8_CH0_BASE			0x00
#define 	DMA8_CH0_COUNT			0x01
#define 	DMA8_CH1_PAGE			0x83
#define 	DMA8_CH1_BASE			0x02
#define 	DMA8_CH1_COUNT			0x03
#define 	DMA8_CH3_PAGE			0x82
#define 	DMA8_CH3_BASE			0x06
#define 	DMA8_CH3_COUNT			0x07

/*----------------------------------------------------------------------------
|	int
|	sound_init_dma ()
|
|	Initializes DMA I/O port variables internal to the driver.  The
|	variables set are:
|
|		1) Page register port
|		2) Base register port
|		3) Transfer count port
|
|   Then allocates DMA buffer.
|	Input args:  DMA buffer length in bytes, 8-bit DMA channel, 16-bit DMA
|					channel.
|	Output args: Address of DMA buffer,
|
|	Returns 0 on success, -1 if an invalid DMA channel has been specified.
----------------------------------------------------------------------------*/
#if __USE_PROTO__
int sound_init_dma (int dmaBufLen, int dma8chan, int dma16chan,
  char ** dmaBuffer, struct snd_dma_parms * sdpp)
#else
int
sound_init_dma (dmaBufLen, dma8chan, dma16chan, dmaBuffer, sdpp)
int						dmaBufLen;
int						dma8chan;
int						dma16chan;
char					** dmaBuffer;
struct snd_dma_parms	* sdpp;
#endif
{
	int	retCode	= 0;

	switch (sb16Dma8)
	{
		case 0:
			sb16dspDma8Page		= DMA8_CH0_PAGE;
			sb16dspDma8Base		= DMA8_CH0_BASE;
			sb16dspDma8Count	= DMA8_CH0_COUNT;
			break;

		case 1:
			sb16dspDma8Page		= DMA8_CH1_PAGE;
			sb16dspDma8Base		= DMA8_CH1_BASE;
			sb16dspDma8Count	= DMA8_CH1_COUNT;
			break;

		case 3:
			sb16dspDma8Page		= DMA8_CH3_PAGE;
			sb16dspDma8Base		= DMA8_CH3_BASE;
			sb16dspDma8Count	= DMA8_CH3_COUNT;
			break;

		default:
			retCode	= -1;	/* invalid DMA channel */
			break;
	}

	switch (sb16Dma16)
	{
		case 5:
			sb16dspDma16Page	= DMA16_CH5_PAGE;
			sb16dspDma16Base	= DMA16_CH5_BASE;
			sb16dspDma16Count	= DMA16_CH5_COUNT;
			break;

		case 6:
			sb16dspDma16Page	= DMA16_CH6_PAGE;
			sb16dspDma16Base	= DMA16_CH6_BASE;
			sb16dspDma16Count	= DMA16_CH6_COUNT;
			break;

		case 7:
			sb16dspDma16Page	= DMA16_CH7_PAGE;
			sb16dspDma16Base	= DMA16_CH7_BASE;
			sb16dspDma16Count	= DMA16_CH7_COUNT;
			break;

		default:
			retCode	= -1;	/* invalid DMA channel */
			break;
	}

	if (retCode != 0)
		cmn_err (CE_WARN, "SB16 : Invalid DMA channel");

	return(retCode);
}
	if (sb16dsp_init_dma_ports() != 0)
		return(-1);

	sb16dspDMABuffer = (char *)getDmaMem(SB16_DMA_BUFSIZE, 128 * 1024);

	if (sb16dspDMABuffer == NULL) {
		cmn_err (CE_WARN, "SB16 : Unable to allocate DMA buffer (PHYS_MEM)");
		return -1;
	}

	/* workaround 4.2.05 getDmaMem bug */
	pad = ((int) vtop((caddr_t)sb16dspDMABuffer)) % (128 * 1024);
	if (pad != 0)
		sb16dspDMABuffer += (128 * 1024) - pad;
XXX
/*--------------------------------------------------------------------------*/
/*	static variables														*/
/*--------------------------------------------------------------------------*/
static int	snd_Installed;

/*----------------------------------------------------------------------------
|	void
|	snd_open (dev_t dev, int mode)
|
|	dev			Device number
|	mode		Open mode
|
|	Opens the selected device if available.  The user's errno is set to
|	ENXIO if the driver was unable to initialize properly during load time.
----------------------------------------------------------------------------*/
#if __USE_PROTO__
static void snd_open(o_dev_t dev, int mode,
  int __NOTUSED(flags), __cred_t * __NOTUSED(credp))
#else
static void
snd_open (dev, mode, flags, credp)
o_dev_t		dev;
int			mode;
int			flags;
__cred_t	* credp;
#endif
{
	int	retCode;

	if (snd_Installed == 0)
	{
		set_user_error(ENXIO);
		return;
	}
	else
	{
		switch (minor(dev))
		{
			case SOUND_DSP_MINOR:
				retCode	= (*snd_dsp_ftp->open)();
				break;

			case SOUND_MIXER_MINOR:
				retCode	= 0;
				break;

			default:
				retCode	= ENODEV;
		}
	}

	if (retCode != 0)
		set_user_error(retCode);
}

/*----------------------------------------------------------------------------
|	void
|	snd_close (dev_t dev, int mode)
|
|	dev			Device number
|	mode		Mode the device was opened in
|
|	Closes the device.
----------------------------------------------------------------------------*/
#if __USE_PROTO__
static void snd_close(o_dev_t dev, int mode,
  int __NOTUSED(flags), __cred_t * __NOTUSED(credp))
#else
static void
snd_close(dev, mode, flags, credp)
o_dev_t		dev;
int			mode;
int			flags;
__cred_t	* credp;
#endif
{
	int	retCode;

	switch (minor(dev))
	{
		case SOUND_DSP_MINOR:
			retCode	= (*snd_dsp_ftp->close)();
			break;

		default:
			retCode	= 0;
			break;
	}

	if (retCode != 0)
		set_user_error(retCode);
}

/*----------------------------------------------------------------------------
|	void
|	snd_read (dev_t dev, IO *iop)
|
|	dev			Device number
|	iop			I/O request structure
|
|	Reads data from the device, or sets the user's errno to ENXIO if they
|	are attempting to read from the mixer.
----------------------------------------------------------------------------*/
#if __USE_PROTO__
static void snd_read(o_dev_t dev, IO * iop, __cred_t * __NOTUSED(credp))
#else
static void
snd_read(dev, iop, credp)
o_dev_t		dev;
IO			* iop;
__cred_t	* credp;
#endif
{
	int	retCode	= ENXIO;

	switch (minor(dev))
	{
		case SOUND_DSP_MINOR:
			retCode	= (*snd_dsp_ftp->read)(iop);
			break;

		default:
			break;
	}

	if (retCode != 0)
		set_user_error(retCode);
}

/*----------------------------------------------------------------------------
|	void
|	snd_write (dev_t dev, IO *iop)
|
|	dev			Device number
|	iop			I/O request structure
|
|	Writes data to the device, or sets the user's errno to ENXIO if they
|	are attempting to write to the mixer.
----------------------------------------------------------------------------*/
#if __USE_PROTO__
static void snd_write(o_dev_t dev, IO * iop, __cred_t * __NOTUSED(credp))
#else
static void
snd_write(dev, iop, credp)
o_dev_t		dev;
IO			* iop;
__cred_t	* credp;
#endif
{
	int	retCode	= ENXIO;

	switch (minor(dev))
	{
		case SOUND_DSP_MINOR:
			retCode	= (*snd_dsp_ftp->write)(iop);
			break;

		default:
			break;
	}

	if (retCode != 0)
		set_user_error(retCode);
}

/*----------------------------------------------------------------------------
|	void
|	snd_ioctl (dev_t dev, int cmd, char *data, int mode,
|			   cred_t credptr, int *retptr)
|
|	dev			Device number
|	cmd			IOCTL command
|	data		Pointer to user data
|	mode		Mode the device was opened with
|	credptr		Credentials pointer
|	retptr		Return value pointer
|
|	Dispatches ioctl commands to the DSP or mixer devices.
|
|	Returns 0 to the caller (through retptr) on success, or -1 on failure.
----------------------------------------------------------------------------*/
#if __USE_PROTO__
static void snd_ioctl(o_dev_t dev, int cmd, __VOID__ * par, int mode,
  __cred_t * __NOTUSED(credp), int * rvalp)
#else
static void
snd_ioctl (dev, cmd, par, mode, credp, rvalp)
o_dev_t		dev;
int			cmd;
char		* par;
int			mode;
__cred_t	* credp;
int			* rvalp;
#endif
{
	int	retCode;

	switch (minor(dev))
	{
		case SOUND_DSP_MINOR:
			retCode	= (*snd_dsp_ftp->ioctl)(cmd, par);
			break;

		case SOUND_MIXER_MINOR:
			retCode	= (*snd_mixer_ftp->ioctl)(cmd, par, mode);
			break;

		default:
			retCode	= ENODEV;
			break;
	}

	if (retCode != 0)
	{
		set_user_error(retCode);
		*rvalp	= -1;
	}
	else
		*rvalp	= 0;
}

/*----------------------------------------------------------------------------
|	void
|	snd_load ()
|
|	Prints an informational message describing the base I/O port, 8/16 bit
|	DMA channels, and IRQ.
----------------------------------------------------------------------------*/
#if __USE_PROTO__
static void snd_load (void)
#else
static void
snd_load ()
#endif
{
	snd_Installed	= 0;

	if ((*snd_dsp_ftp->init)() == 0 && (*snd_mixer_ftp->init)() == 0)
	{
		snd_Installed	= 1;
	}
}

/*----------------------------------------------------------------------------
|	void
|	snd_uload ()
|
|	Unload routine.
----------------------------------------------------------------------------*/
#if __USE_PROTO__
static void snd_uload (void)
#else
static void
snd_uload ()
#endif
{
}

/*--------------------------------------------------------------------------*/
/*	CON structure															*/
/*--------------------------------------------------------------------------*/
struct con soundcon	=
{
	DFCHR,						/* flags 		*/
	0,							/* device major	*/
	snd_open,					/* open			*/
	snd_close,					/* close		*/
	NULL,						/* block		*/
	snd_read,					/* read			*/
	snd_write,					/* write		*/
	snd_ioctl,					/* ioctl		*/
	NULL,						/* powerfail	*/
	NULL,						/* timeout		*/
	snd_load,					/* load			*/
	snd_uload,					/* unload		*/
	NULL						/* poll			*/
};
