.TH ncurses
.SH NAME
.PP
ncurses \- terminal-independent screen management package
.SH SYNOPSIS
.PP
#include <ncurses.h>
.br
.B cc
[ flags ] files
.B \-lncurses
[ libraries ]
.SH DESCRIPTION
.PP
These routines give the user a method
of updating screens with reasonable optimization and terminal independence.
They keep an image of the current screen,
and the user sets up an image of a new one.
Then the
.I refresh()
call tells the routines to make the current screen look
like the new one.
In order to initialize the routines,
the routine
.I initscr()
must be called before any of the other routines
that deal with windows and screens
are used.
The routine
.I endwin()
should be called before exiting.
.SH "SEE ALSO"
.PP
.I "The Curses Reference Manual",
Curtis
.br
terminfo
.SH AUTHOR
.PP
Pavel Curtis
.sp
.nf
Ported to Coherent by:
Udo Munk
Oberstr. 21
4040 Neuss 1
Germany
phone: +49 2131/275348
.fi
.SH FUNCTIONS
.PP
.nf
.ds w \fIwin\fR
.ds s \fIstdscr\fR
.ta 3i
addch(ch)	add a character to \*s
addstr(str)	add a string to \*s
attroff(at)	turn off video attributes on \*s
attron(at)	turn on video attributes on \*s
attrset(at)	set video attributes on \*s
baudrate()	return baudrate of current terminal
beep()	sound audible bell
box(win,vert,hor)	draw a box around a window
cbreak()	set cbreak mode
crmode()	set cbreak mode
clear()	clear \*s
clearok(scr,boolf)	set clear flag for \fIscr\fR
clrtobot()	clear to bottom on \*s
clrtoeol()	clear to end of line on \*s
delch()	delete a character
deleteln()	delete a line
delwin(win)	delete \*w
doupdate()	update the physical screen
echo()	set echo mode
endwin()	end window modes
erase()	erase \*s
erasechar()	return erase character of current terminal
fixterm()	set terminal into program mode
flash()	execute visible bell
flushinp()	flush outstanding input on current terminal
getch()	get a char through \*s
getcap(name)	get terminal capability \fIname\fR
getstr(str)	get a string through \*s
gettmode()	no-op
getyx(win,y,x)	get (y,x) coordinates
idlok(win,flag)	enable insert/delete lines operations
inch()	get char at current (y,x) coordinates
initscr()	initialize screens
insch(c)	insert a char
insertln()	insert a line
keypad(win,flag)	enable keypad-sequence mapping
killchar()	return kill character of current terminal
leaveok(win,boolf)	set leave flag for \*w
longname(termbuf,name)	get long name from \fItermbuf\fR
meta(win,flag)	enable use of the `meta' key
move(y,x)	move to (y,x) on \*s
mvcur(lasty,lastx,newy,newx)	actually move cursor
newterm(type,fp)	initialise a new terminal
newwin(lines,cols,begin_y,begin_x)\ 	create a new window
nl()	set newline mapping
nocbreak()	unset cbreak mode
nocrmode()	unset cbreak mode
nodelay(win,flag)	make getch() non-blocking
noecho()	unset echo mode
nonl()	unset newline mapping
noraw()	unset raw mode
overlay(win1,win2)	overlay win1 on win2
overwrite(win1,win2)	overwrite win1 on top of win2
printw(fmt,arg1,arg2,...)	printf on \*s
putp(string)	tputs() with affcnt=1 and outc=putchar
raw()	set raw mode
refresh()	make current screen look like \*s
resetterm()	set terminal into normal mode
resetty()	reset tty flags to stored value
savetty()	store current tty flags
saveterm()	save current state of tty
scanw(fmt,arg1,arg2,...)	scanf through \*s
scroll(win)	scroll \*w one line
scrollok(win,boolf)	set scroll flag
setscrreg(top,bottom)	set up scrolling region on \*s
setterm(name)	set term variables for name
set_term(new)	change current terminal
setupterm(term,fd,errret)	initialise terminal capabilities
standend()	end standout mode
standout()	start standout mode
subwin(win,lines,cols,begin_y,begin_x)\ 	create a subwindow
touchwin(win)	\*(lqchange\*(rq all of \*w
tparm(string,p1..p9)	instantiate a parameterised string
tputs(string,affcnt,outc)	process a capability string
traceoff()	turn off debugging output
traceon()	turn on debugging output
unctrl(ch)	printable version of \fIch\fR
vidattr(newmode)	set terminal's video attributes
vidputs(newmode,outc)	set video attributes into a function
waddch(win,ch)	add char to \*w
waddstr(win,str)	add string to \*w
wattroff(win,at)	turn off video attributes on \*w
wattron(win,at)	turn on video attributes on \*w
wattrset(win,at)	set video attributes on \*w
wclear(win)	clear \*w
wclrtobot(win)	clear to bottom of \*w
wclrtoeol(win)	clear to end of line on \*w
wdelch(win,c)	delete char from \*w
wdeleteln(win)	delete line from \*w
werase(win)	erase \*w
wgetch(win)	get a char through \*w
wgetstr(win,str)	get a string through \*w
winch(win)	get char at current (y,x) in \*w
winsch(win,c)	insert char into \*w
winsertln(win)	insert line into \*w
wmove(win,y,x)	set current (y,x) co-ordinates on \*w
wnoutrefresh(win)	copy \*w to virtual screen
wprintw(win,fmt,arg1,arg2,...)\ 	printf on \*w
wrefresh(win)	make screen look like \*w
wscanw(win,fmt,arg1,arg2,...)\ 	scanf through \*w
wsetscrreg(win,top,bottom)	set up scrolling region on \*w
wstandend(win)	end standout mode on \*w
wstandout(win)	start standout mode on \*w
