eb);
			time(&timeb.curtim);
		}
		p = wait(&s);
		if(wasintr) p = wait(&s);
		if(p == -1)
			break;
		e = s&0177;
		exitcode = (s>>8)&0377;
		if(e==INTR && wasintr)  /* process returned intr */
			e = 0;
		if(mesg[e] != 0) {
			if(p != i) {
				prs(itoa(p));
				prs(": ");
			}
			prs(mesg[e]);
			if(s&0200)
				prs(" -- Core dumped");
		}
		if (p == i)
			setxcod(exitcode);
		if(e != 0)
			err("");
		for(t1 = t; t1; t1 = t1[DLEF]) { /* hunt proc; elims most **gok*/
			if (t1[DSPR] == p) {
				nprocs--;
				break;
			}
		}
		acct(t1);
	} while (nprocs);
}


acct(t)
int *t;
{
	if(t == 0)
		enacct("**gok", 0);
	else if(*t == TPAR)
		enacct("()", 0);
	else
		enacct(t[DCOM], 0);
}


enacct(as, acctype)
char *as;
int acctype;	/* 0 ==> child process, 1 ==> internal cmd */
{
	struct stime timbuf;
	register i;
	register char *np;

	if (uid == 0)
		return;
	if (acctf <= 0)	/* if no accounting active, elim sys calls */
		return;
	if (acctype && acctfi <= 0)
		return;	/* internal cmd, but no internal acctg */
	times(&timbuf);
	time(&timbuf.curtim);
	tbuf.realt = timbuf.curtim - timeb.curtim;
	if (acctype) {
		tbuf.bcput = timbuf.procu - timeb.procu;
		tbuf.bsyst = timbuf.procs - timeb.procs;
	} else {
		tbuf.bcput = timbuf.childu - timeb.childu;
		tbuf.bsyst = timbuf.childs - timeb.childs;
	}
	np = sname(as);
	for (i=0; i<8; i++) {
		tbuf.cname[i] = *np;
		if (*np)
			np++;
	}
	tbuf.datet = timbuf.curtim;
	tbuf.tuid = uid;
	seek(acctf, 0, 2);
	write(acctf, &tbuf, sizeof(tbuf));
}


rdval(pipef, lef, na)
char *na;
{
	register char *st, *np;
	char c;

	st = endptr;
	np = na;
	if(!pipef && lef) {
		pipef = eq(lef, "--") ? dup(oldfil0) : open(lef, 0);
		if(pipef<0)  return 0;
	}
	for(;;) {
		if(endptr >= endcore-10)
			if((endcore=sbrk(64))<0) return 0;
		if(!na) {
			if(read(pipef, &c, 1) <= 0) {
				setxcod(1);	/* EOF indicator */
				break;
			}
		} else c = *np++ & 0177;
		*endptr++ = c;
		if(c=='\n' || c=='\0') break;
	}
	if(c=='\n') --endptr;
	*endptr++ = '\0';
	if(pipef || lef) close(pipef);
	return st;
}


catchintr() {
	if (proflag)
		proflag++;	/* in .profile, make sure come out ok */
	wasintr++;
	signal(INTR, 1);
}


pcat(so1, so2, si, sz)
register char *so1, *so2;
char *si;
int sz;
{
	register char *s;

	s = si;
	while(*so1 != ':' && *so1 != '\0' && --sz) *s++ = *so1++;
	if(si != s && --sz > 0) *s++ = '/';
	while(*so2 && --sz > 0) *s++ = *so2++;
	if (--sz < 0) {
			*si = '\0';
			die("cmd line overflow", 0);
	}
	else *s = '\0';
	return *so1 ? ++so1 : 0;
}


setxcod(code)
int code;
{
	copy(itoa(code), exitstr);
	seta[R] = exitstr;
	return;
}

copy(source, sink)
register char *source, *sink;
{
	 while(*sink++ = *source++ & 0177);
}

/*
 *	copyn: copy at most n bytes from source to sink.
 */
copyn(source, sink, n)
register char *source, *sink;
int	n;
{
	register i;
	for (i = 0; i < n; i++)
		if (!(*sink++ = *source++))
			break;
}

itoa(n) {
	register i, j;
	register char *cp;
	static char *str[12];

	j = n;
	for(cp = &str[4]; ;--cp) {
		if(wide) --wide;
		j = ldiv(0, j, 10);
		*cp = ldivr+'0';
		if((j | wide) == 0)
			return cp;
	}
}

char *nxtarg()
{
	register iap;

	if ((iap = ap++) > ac || av[iap] == 0)
		return(0);
	return trim(av[iap]);
}

exp() {
	int p1;

	p1 = e1();
	if (eq(nxtarg(), "-o")) return(p1 | exp());
	ap--;
	return(p1);
}

e1() {
	int p1;

	p1 = e2();
	if (eq(nxtarg(), "-a")) return (p1 & e1());
	ap--;
	return(p1);
}

e2() {
	if (eq(nxtarg(), "!"))
		return(!e3());
	ap--;
	return(e3());
}

e3() {
	int ccode;
	int nap;
	int int1, int2;
	register char *a, *p1, *p2;

	ccode = 0;
	a = nxtarg();
	if(eq(a, "(")) {
		ccode = exp();
		if(!eq(nxtarg(), ")")) goto erre3;
		return(ccode);
	}

	if(eq(a, "{")) { /* execute a command for exit code */
		nap = ap;	/*	save 1st arg ptr */
		while (ap < ac && !eq(av[ap], "}")) trim(av[ap++]);
		if (ap >= ac || nap == ap) {
			die(SYNTAX, av[nap]);
			return 0;
		}
		av[ap++] = 0;	/*	change } to 0 for pexec */
		if ((int1 = dofork()) > 0)
			wait(&ccode);	/* parent */
		else if (int1 == 0)	/* child */
			texec(av[nap], &av[nap-DCOM]);
		return(ccode? 0 : 1);
	}

	p1 = nxtarg();

	/* file predicates */
	if(eq(a, "-r"))
		return(tio(p1, 0));

	if(eq(a, "-w"))
		return(tio(p1, 1));
	if (eq(a, "-f")) {
		if (stat(p1, &sb) == -1)
			return 0;
		return ((sb.i_mode & IFMT) == 0);
	}
	if (eq(a, "-d")) {
		if (stat(p1, &sb) == -1)
			return 0;
		return ((sb.i_mode & IFMT) == IFDIR);
	}
	if (eq(a, "-s")) {
		if (stat(p1, &sb) == -1)
			return 0;
		return (sb.i_size0 || sb.i_size1);
	}

	/* string predicates */
	if (eq(a, "-n"))
		return(p1 && *p1 != '\0');
	if (eq(a, "-z"))
		return(p1 == 0 || *p1 == '\0');
	if ((p2 = nxtarg()) == 0)
		goto erre3;
	if(eq(p1, "="))
		return(eq(a, p2));

	if(eq(p1, "!="))
		return(!eq(a, p2));

	int1 = atoi(a);
	int2 = atoi(p2);
	if(eq(p1, "-eq"))
		return( int1 == int2 );
	if(eq(p1, "-ne"))
		return( int1 != int2 );
	if(eq(p1, "-gt"))
		return( int1 > int2 );
	if(eq(p1, "-lt"))
		return( int1 < int2 );
	if(eq(p1, "-ge"))
		return( int1 >= int2 );
	if(eq(p1, "-le"))
		return( int1 <= int2 );

erre3:
	die(SYNTAX, p1);
}

tio(a, f)
char *a; int f;
{
	register int fil;

	if ((fil = open(a, f)) >= 0) {
		close(fil);
		return(1);
	}
	return(0);
}


/*	search: forward search for required token, type =
 *	ZGOTO: : label
 *	ZSWITCH: : label, : default, or unmatched ENDSW
 *	ZBREAKSW: unmatched endsw
 *	ZIF: unmatched else or endif (or }) (this is failed if-then)
 *	ZELSE: unmatched endif (or })
 *	ZBREAK: unmatched end (break, failed while or end)
 *	levinit = 0, except when called from else if ... then, when it is 1
 */
search(type, levinit)
int type, levinit;
{
	register int level, t;
	register char *aword;
	char fifel, fbr, fswex;
	char wordbuf[128];
	if (type == ZGOTO)
		bseek(0L);
	fifel = type == ZIF || type == ZELSE;
	fbr = type == ZBREAK;
	fswex = type == ZSWITCH || type == ZBREAKSW;
	aword = wordbuf;
	level = levinit;

	do {
		*aword = '\0';
		getword(aword);
		if ((t = lookup(aword)) >= 0)
			switch(t) {
			case ZELSE:
				if (level == 0 && type == ZIF)
					return;	/* leave rest of else line */
				continue;
			case ZIF:
				while(getword(aword));
				if (fifel && eq(aword, THEN))
					level++;
				break;
			case ZENDIF:
				if (fifel)
					level--;
				break;
			case ZWHILE:
				if (fbr)
					level++;
				break;
			case ZEND:
				if (fbr)
					level--;
				break;
			case ZSWITCH:
				if (fswex)
					level++;
				break;
			case ZENDSW:
				if (fswex)
					level--;
				break;
			case ZLABEL:
				if (getword(aword)) {
					if (type == ZGOTO) {
						if (eq(aword, ARG1))
							level = -1;
					} else if (type == ZSWITCH &&
						level == 0 &&
						(eq(aword, "default") ||
						match(ARG1, aword)))
						level = -1;
				}
				break;
			}
		getword(0);	/* gobble rest of line, if any */
	} while (level >= 0 && proflag < 2);
	return;
}

/*	getword: return next word from input (if any):
	aword != 0 : get next word (if any, return 1),
			if none, return 0, do not distturb *aword.
	aword == 0 : consume rest of line thru (nl).
	return 1 if word, 0 if only newline left.
*/

getword(aword)
char *aword;
{
	register int found;	/* 1 ==> found word, 0 ==> not */
	register char c, *wp;
	wp = aword;
	found = 0;
	c = peekc ? peekc : readc();
	peekc = '\0';

	do {
		while(c == ' ' || c == '\t')
			c = readc();
		if (c == '\n') {
			if (wp)
				break;
			else
				return 0;	/* newline only thing left */
		}
		found++;
		do {
			if (wp)
				*wp++ = c;
			c = readc();
			if (c == '\\' && (c = readc()) == '\n')
				c = ' ';
		} while (c != ' ' && c != '\t' && c != '\n');
	} while (!wp);
	peekc = c;
	if (found)
		*wp = '\0';
	return(found);
}

readc()
{
	register c;

	if (arginp) {
		if (arginp == 1)
			goto ONLYEXIT;
		if ((c = *arginp++) == 0) {
			arginp = 1;
			c = '\n';
		}
		return(c);
	}
	if (onelflg==1)
		goto ONLYEXIT;
	if (b.nleft == 0) {
		b.nextp = bbuf;
		b.start = b.start + b.gotten;	/* increm by last gotten */
		if ((b.nleft = read(0, b.nextp, bnread)) == 0 || proflag > 1) {
			if (proflag) {	/* still inside .profile */
				b.nleft = 5;	/* fake next */
				b.nextp = "next\n";
			} else {
				eoferr();
			ONLYEXIT:
				exit(atoi(seta[R]));
			}
		}
		b.gotten = b.nleft;
	}
	b.nleft--;
	c = *b.nextp++;
	if (c=='\n' && onelflg)
		onelflg--;
	return(c);
}

/*	eoferr: issue error message if cmd was in middle of search */
eoferr()
{
	switch (COMTYPE) {
	case ZGOTO:
		die(MISSL, ARG1);
		break;
	case ZIF:
	case ZELSE:
		die(MISS, ENDIF);
		break;
	case ZSWITCH:
	case ZBREAKSW:
		die(MISS, ENDSW);
		break;
	case ZWHILE:
	case ZBREAK:
		die(MISS, END);
		break;
	}
	bsynch(1);
	return;
}

/*	bflush: complete input flush */
bflush()
{
	seek(0, 0, 2);
	b.nleft = b.gotten = 0;
	return;
}

/*	bsynch: synchronize internal buffering & outside world */
/*	btarg gives nominal target value of bstate */
bsynch(btarg)
register btarg;
{
	register obstate;
	long f;
	if 