# include "mfile2"


int lflag;
int edebug = 0;
int xdebug = 0;

#ifndef ONEPASS

int tdebug = 0;
NODE node[TREESZ];
char filename[100];
int ftnno;
int lineno;

main(ar, av)
char *av[];
{
	return(mainp2(ar,av));
}
#endif




OFFSZ tmpoff;  /* offset for first temporary, in bits for current block */
OFFSZ maxoff;  /* maximum temporary offset over all blocks in current ftn, in bits */
int maxtreg;

OFFSZ baseoff = 0;
OFFSZ maxtemp = 0;

p2init( argc, argv ) char *argv[];{
	/* set the values of the pass 2 arguments */

	register int c;
	register char *cp;
	register files;

	files = 0;

	for( c=1; c<argc; ++c ){
		if( *(cp=argv[c]) == '-' ){
			while( *++cp ){
				switch( *cp ){

				case 'X':  /* pass1 flags */
					while( *++cp ) { /* VOID */ }
					--cp;
					break;

				case 'l':  /* linenos */
					++lflag;
					break;

				case 'e':  /* expressions */
					++edebug;
					break;




				case 't':  /* ttype calls */
					++tdebug;
					break;



				case 'x':  /* general machine-dependent debugging flag */
					++xdebug;
					break;

				default:
					cerror( "bad option: %c", *cp );
					}
				}
			}
		else {		/* assumed to be a filename */
			if( *(argv[c]) != '-' ) switch( files++ ) {
				case 0:
				case 1:
					if( freopen(argv[c], files==1 ? "r" : "w", files==1 ? stdin : stdout) == NULL) {
						fprintf(stderr, "ccom:can't open %s\n", argv[c]);
						exit(1);
					}
					break;

				default:
					;
				}
		}
		}

	mkdope();
	return( files );

	}


NODE *topn;
int se;		/* compute for side effects */
top(p)
NODE *p;
{
	return p == topn;
}
#ifndef ONEPASS
mainp2(argc, argv)
char *argv[];
{	
	register files, temp, c;
	register  char *cp;
	register NODE *p;
	NODE *eread();


	files = p2init(argc, argv);
	tinit();
	while( (c=getchar()) > 0)
	switch(c)
	{
    case ')':
	while( (c=getchar()) > 0 )
	{
		PUTCHAR(c);
		if(c=='\n')
			break;
	}
	continue;
    case '[':
	getchar();
	temp = rdin(10);
	tmpoff = baseoff = rdin(10);
	maxtreg = rdin(10);
	if( getchar() != '\n')
		cerror("intermediate file format error");
	if(temp!=ftnno)
	{
		/* beginning of function */
		maxoff = baseoff;
		ftnno = temp;
		maxtemp = 0;
	}
	else
	{
		if(baseoff>maxoff)
			maxoff = baseoff;
	}
	continue;

    case ']': 
	eobl2();
	while((c=getchar())!='\n')
	{
		if(c<=0)
			cerror("intermediate file format eof");
	}
	continue;

   case '.':
	lineno = rdin(10);
	for(cp=filename; (*cp=getchar())!='\n'; ++cp)
		;
	*cp = '\0';
	if(lflag)
		lineid(lineno, filename);
	tmpoff = baseoff;
	p = eread();
#ifndef BUG2
	if(edebug)
		fwalk(p, eprint, 0);
#endif
	topn = p;
	se = 1;
	ind(p);
	se = 0;
	tfree(p);
	tcheck();
	continue;

default:
	cerror("intermediate file format error  (funny command character)");
	}
	return(nerrors);
}


NODE *eread()
{
register NODE *p;
	register i, j, c;
	register char *pc;

	i= rdin(10);
	p = talloc();
	p->in.op = i;
	i=optype(i);
	if(i==LTYPE)
		p->tn.lval = rdin(10);
	if(i!=BITYPE)
		p->tn.rval = rdin(10);
	p->in.type = rdin(8);
	if(p->in.op == STASG || p->in.op == STARG || p->in.op == STCALL ||
		p->in.op == UNARY STCALL)
	{
		p->stn.stsize = (rdin(10) + (SZCHAR-1))/SZCHAR;
		p->stn.stalign = rdin(10)/SZCHAR;
		if(getchar() != '\n')
			cerror("illegal \n");
	}
	else
	{
		for(pc=p->in.name, j=0; (c=getchar())!='\n'; ++j)
		{
			if(j<NCHNAM)*pc++ =c;
		}
		if(j<NCHNAM)
			*pc= '\0';
	}
	if(i!=LTYPE)
		p->in.left = eread();
	if(i==BITYPE)
		p->in.right = eread();
	return(p);
}
CONSZ
rdin(base)
{
	register sign, c;
	CONSZ val;

	sign = 1;
	val = 0;

	while((c=getchar()) >0)
	{
		if(c== '-')
		{
			if(val!=0)
				cerror("illegal -");
			sign = -sign;
			continue;
		}
		if(c=='\t')
			break;
		if(c>='0' && c<='9')
		{
			val *= base;
			if(sign>0)
				val += c-'0';
			else
				val -= c-'0';
			continue;
		}
		cerror("illegal character in intermediate file");
		break;
	}
	if(c<=0)
		cerror("unexpected EOF");
	return val;
}
#endif
int nopop = 0;
#ifdef ONEPASS
p2compile( p ) NODE *p; {

	if( lflag ) lineid( lineno, filename );
	tmpoff = baseoff;  /* expression at top level reuses temps */
	/* generate code for the tree p */
#ifndef BUG2
	if( edebug ) fwalk( p, eprint, 0 );
#endif

# ifdef MYREADER
	MYREADER(p);  /* do your own laundering of the input */
# endif
	topn = p;
	se = 1;
	ind(p);
	se = 0;
}
#endif

p2bbeg( aoff, myreg ) {
	static int myftn = -1;
	tmpoff = baseoff = aoff;
	maxtreg = myreg;
	if( myftn != ftnno ){ /* beginning of function */
		maxoff = baseoff;
		myftn = ftnno;
		maxtemp = 0;
		}
	else {
		if( baseoff > maxoff ) maxoff = baseoff;
		/* maxoff at end of ftn is max of autos and temps over all blocks */
		}
	}




int callflag;

eprint( p, down, a, b ) NODE *p; int *a, *b; {

	*a = *b = down+1;
	while( down >= 2 ){
		printf( "\t" );
		down -= 2;
		}
	if( down-- ) printf( "    " );


	printf( "%o) %s", p, opst[p->in.op] );
	switch( p->in.op ) { /* special cases */


	case NAME:
	printf("  global: '%s'", p->in.name);
	case ICON:
		printf( " " );
		printf("%D", p->tn.lval);
printf(p->in.name);
		break;
	case REG:
		printf("  %d", p->tn.rval);
		break;

	case STCALL:
	case UNARY STCALL:
	case STARG:
	case STASG:
		printf( " size=%d", p->stn.stsize );
		printf( " align=%d", p->stn.stalign );
		break;
		}

	printf( ", " );
#ifndef BUG4
	tprint( p->in.type );
#endif
	printf( ", " );
	printf( ", SU= %d\n", p->bn.su );

	}

#ifndef FIELDOPS
	/* do this if there is no special hardware support for fields */

ffld( p, down, down1, down2 ) NODE *p; int *down1, *down2; {
	 /* look for fields that are not in an lvalue context, and rewrite them... */
	register NODE *shp;
	register s, o, v, ty;

	*down1 =  asgop( p->in.op );
	*down2 = 0;

	if( !down && p->in.op == FLD ){ /* rewrite the node */

		if( !rewfld(p) ) return;

		ty = (szty(p->in.type) == 2)? LONG: INT;
		v = p->tn.rval;
		s = UPKFSZ(v);
# ifdef RTOLBYTES
		o = UPKFOFF(v);  /* amount to shift */
# else
		o = szty(p->in.type)*SZINT - s - UPKFOFF(v);  /* amount to shift */
#endif

		/* make & mask part */

		p->in.left->in.type = ty;

		p->in.op = AND;
		p->in.right = talloc();
		p->in.right->in.op = ICON;
		p->in.right->stn.rall = NOPREF;
		p->in.right->in.type = ty;
		p->in.right->tn.lval = 1;
		p->in.right->tn.rval = 0;
		p->in.right->in.name[0] = '\0';
		p->in.right->tn.lval <<= s;
		p->in.right->tn.lval--;

		/* now, if a shift is needed, do it */

		if( o != 0 ){
			shp = talloc();
			shp->in.op = RS;
			shp->stn.rall = NOPREF;
			shp->in.type = ty;
			shp->in.left = p->in.left;
			shp->in.right = talloc();
			shp->in.right->in.op = ICON;
			shp->in.right->stn.rall = NOPREF;
			shp->in.right->in.type = ty;
			shp->in.right->tn.rval = 0;
			shp->in.right->tn.lval = o;  /* amount to shift */
			shp->in.right->in.name[0] = '\0';
			p->in.left = shp;
			/* whew! */
			}
		}
	}
#endif

szty(t) TWORD t; { /* size, in words, needed to hold thing of type t */
	/* really is the number of registers to hold type t */
	switch( t ) {

	case LONG:
	case ULONG:
		return( SZLONG/SZINT );

	default:
		return(1);

		}
	}

rewfld( p ) NODE *p; {
	return(1);
	}
lineid( l, fn ) char *fn; {
	/* identify line l and file fn */
	printf( "*	line %d, file %s\n", l, fn );
	}

eobl2(){
	OFFSZ spoff;	/* offset from stack pointer */

	spoff = maxoff;
	if( spoff >= AUTOINIT ) spoff -= AUTOINIT;
	spoff /= SZCHAR;
	printf( "F%d:	=	%d\n", ftnno, -(short)(spoff) );
	}


#ifndef ONEPASS
NODE *block( o, l, r, t, d, s ) register NODE *l, *r; TWORD t; {

	register NODE *p;

	p = talloc();
	p->in.op = o;
	p->in.left = l;
	p->in.right = r;
	p->in.type = t;
	return(p);
	}

where(c){ /* print location of error  */
	/* c is either 'u', 'c', or 'w' */
	fprintf( stderr, "%s, line %d: ", filename, lineno );
	}

deflab( n ){
	/* output something to define the current position as label n */
	printf(  "L%d:\n", n );
	}

int crslab = 1000;

getlab(){
	/* return a number usable for a label */
	return( ++crslab );
	}
dexit( v ) {
	exit(1);
	}

#endif
