/*
 * MSC/AMPEX disk driver
 */

#include <sys/param.h>
#include <sys/inode.h>
#include "saio.h"

struct	device
{
	int	msccra;	/* command completion register A */
	int	msccrb;	/* command completion register B */
	int	mscsr;	/* control and status register */
	int	msctra;	/* command transmission register A */
	int	msctrb;	/* command transmission register B */
};

struct	msdesc
{
	int	 ds_id;		/* command identifier - drive number for us */
	int	 ds_stat;	/* status word */
	char	 ds_nexthi;	/* hi portion of link to next descriptor */
	char	 ds_sfc;	/* system fault code */
	unsigned ds_nextlo;	/* lo portion of link to next descriptor */
	int	 ds_discop;	/* disc operation code */
	int	 ds_drive;	/* disc drive number */
	int	 ds_cylinder;	/* disc cylinder number */
	int	 ds_head;	/* disc head number (track) */
	int	 ds_sector;	/* disc sector number */
	unsigned ds_wcount;	/* word count */
	unsigned ds_memlo;	/* lo part of memory address */
	unsigned ds_memhi;	/* hi part of memory address - watch bit 6! */
	unsigned ds_rid1;	/* part one of record id on "readid"s */
	unsigned ds_rid2;	/* part two of record id on "readid"s */
} msd;

#define	MSADDR	((struct device *)0177400)
#define	NSECT	21
#define	NTRAC	19

#define	CMDQERR	0010000	/* command queue error */
#define	CMDNXM	0004000	/* nxm during command descriptor fetch */
#define	CMDPAR	0002000	/* memory parity during descriptor fetch */

#define	RETRY	0100000	/* retry occurred due to data miss */
#define	ECCERR	0020000	/* ecc correction made */

#define	RDYCC	0100000	/* ready from command completion */
#define	RESET	0002000	/* reset controller */
#define	CCACK	0001000	/* command completion acknowledge */
#define	CARDY	0000400	/* command address ready */
#define	RDYCT	0000200	/* ready for command transmission */
#define	RCOM	020	/* read data */
#define	WCOM	06	/* write data */

msopen(io)
register struct iob *io;
{
	msd.ds_nexthi = 0;
	msd.ds_nextlo = 0;
	msd.ds_id = io->i_unit & 03;
	msd.ds_drive = io->i_unit & 03;
}

msstrategy(io, func)
register struct iob *io;
{
	register unit;
	register i;
	daddr_t bn;
	int sn, cn, tn;

	if (((unit = io->i_unit) & 04) == 0)
		bn = io->i_bn;
	else {
		unit &= 03;
		bn = io->i_bn;
		bn -= io->i_boff;
		i = unit + 1;
		unit = bn%i;
		bn /= i;
		bn += io->i_boff;
	}

	while ((MSADDR->mscsr & RDYCT) == 0);

	cn = bn / (NSECT*NTRAC);
	sn = bn % (NSECT*NTRAC);
	tn = sn / NSECT;
	sn = sn % NSECT;

	msd.ds_cylinder = cn;
	msd.ds_head = tn;
	msd.ds_sector = sn;
	msd.ds_memlo = io->i_ma;
	msd.ds_memhi = segflag;
	msd.ds_wcount = (io->i_cc >> 1);
	if (func == READ)
		msd.ds_discop = RCOM;
	else if (func == WRITE)
		msd.ds_discop = WCOM;
	MSADDR->msctrb = &msd;
	MSADDR->msctra = segflag;
	MSADDR->mscsr =| CARDY;
	putchar(0);
	while ((MSADDR->mscsr & RDYCC) == 0);

	if (MSADDR->msccra & (CMDQERR | CMDNXM | CMDPAR))
	{
		printf("MS FATAL\n");
		MSADDR->mscsr =| CCACK;
		return(-1);
	}
	MSADDR->mscsr =| CCACK;
	if (msd.ds_stat & ~(RETRY | ECCERR))
	{
		printf("MS err: cyl %d trk %d blk %d\n", cn, tn, sn);
		return(-1);
	}
	return(io->i_cc);
}
