/*
**	Converts the null terminated string pointed to by "s" into an
**	integer value modulo PWHASHSIZE.
*/ 

#include	<pwr.h>


int
pwhash(s)
	register char	*s;
{
	register long	sum = 0;
	register	c;

	while(c = *s++)
	{
		if(c >= '0' && c <= '9')
			sum = sum*10 + c-'0';
		else
		if(c >= 'a' && c <= 'z')
			sum = sum*26 + c-'a';
		else
			sum = (sum<<7) + c;
		sum += sum>>16;
		sum &= ~((long)-1<<16);
	}

	return ((int)sum&077777)%PWHASHSIZE;
}
