/*
 * 	The world famous game of ....
 *
 * 		ANIMALS
 *
 *	Original idea .... who knows ?
 *	This programme by Stephen Frede 7981554
 */

#include <local-system>
#include <passwd.h>
#include <fcntl.h>
#include <stdio.h>

#define STRSIZ		256	/* maximum string length */
#define FIRSTANIMAL	"a lecturer"
#define INTERRUPT	2
#define IGNORE		1
#define FNAMESIZ	50	/* maximum pathname length */
#define LEAFCHAR	'l'
#define BRANCHAR	'b'

struct pwent pe;

typedef struct tnode
{
	char string[STRSIZ];
	struct tnode *yes;
	struct tnode *no;
} TREENODE, *TREEPTR;

TREENODE top;
char leaf = LEAFCHAR;		/* leaf mark for files */
char branch = BRANCHAR;		/* branch mark for files */
				/* default file names */
char animfin[FNAMESIZ] = "animals.save";
char animfout[FNAMESIZ] = "animals.save";
FILE *strin, *strout;		/* stream pointers for animalsfile */
int ans = 0;			/* number of animals known */

main(argc, argv)
register int argc;
register char **argv;
{
	extern fin();
	char buf[SSIZ];		/* for password file entry */
	if(argc > 3)
	{
		fputs("Usage: animals [infile [outfile]]\n", stderr);
		quit(-1, "");
	}
	else	if(argc == 1)
	{
		pe.pw_uid = getuid();
		if(getpwlog(&pe, buf, SSIZ) < 0)
			quit(-1, "who are you??");
		if(chdir(pe.pw_strings[DIRPATH]) < 0)
			quit(-1, "cannot chdir");
	}
	else
	{
		strcpy(argv[1], animfin);
		strcpy(argv[argc-1], animfout);
	}
	if((strin = fopen(animfin, "r")) == NULL)
	{
		top.yes = top.no = NULL;
		strcpy(FIRSTANIMAL,  top.string);
		ans++;
	}
	else
	{
		readfile(&top);
		fclose(strin);
	}
	instructions();
	signal(INTERRUPT, fin);
	for(;;)
	{
		climb(&top);
		fputs("again", stdout);
		if(!ask())
			quit(0, "");
	}
}

climb(p)
TREEPTR p;
{
	TREEPTR newentry();
	char	newanimal[STRSIZ],
		oldanimal[STRSIZ];

	if((p->yes == NULL) || (p->no == NULL))
	{
		fputs("Is the animal you were thinking of ", stdout);
		fputs(p->string, stdout);
		if(ask())
		{
			fputs("I guessed it - smart eh?\n", stdout);
			return;		/* back to start */
		}
		else
		{
			strcpy(p->string, oldanimal);
			fputs("What was the animal you were thinking of?\n", stdout);
			readstr(newanimal);
			fputs("Enter a question to distinguish between ", stdout);
			fputs(oldanimal, stdout);
			fputs(" and ", stdout);
			fputs(newanimal, stdout);
			putchar('\n');
			readstr(p->string);
			fputs("What would be the answer for ", stdout);
			fputs(newanimal, stdout);
			if(ask())
			{
				p->yes = newentry(newanimal);
				p->no = newentry(oldanimal);
			}
			else
			{
				p->no = newentry(newanimal);
				p->yes = newentry(oldanimal);
			}
			fputs("I now know ", stdout);
			printn(++ans);
			fputs(" animals\n", stdout);
		}
	}
	else
	{
		fputs(p->string, stdout);
		if(ask())
			climb(p->yes);
		else
			climb(p->no);
	}
}

strcpy(s1, s2)
register char *s1, *s2;
{
	while(*s2++ = *s1++);
}

TREEPTR
newentry(s)
register char *s;
{
	TREEPTR calloc(), sbrk();
	TREEPTR t;
	if((t = sbrk(sizeof(TREENODE))) == (TREEPTR) -1)
		quit(1, "out of core");
	t->yes = t->no = 0;
	strcpy(s, t->string);
	return(t);
}

instructions()
{
	fputs("\t\t\tANIMALS\t Version 2.0\n\n", stdout);
	fputs("Think of an animal and I will try to guess it\n", stdout);
}

ask()
{
	register int answer;
	register char c;
	fputs("? ", stdout);
	fflush(stdout);
	while((c = getchar()) && c != 'n' && c != 'y' && c != '\n');
	answer = (c == 'y');
	while(c != '\n')
		c = getchar();
	return(answer);
}

fin()
{
	quit(0, "");
}

quit(n, s)
register int n;
register char *s;
{
	signal(INTERRUPT, IGNORE);
	fputs(s, stderr);
	if(n != -1);
	{
		strout = fopen(animfout, "w");
		writefile(&top);
		fputs("\nanimals saved in '", stdout);
		fputs(animfout, stdout);
		fputs("'\n", stdout);
	}
	exit(n);
}

readstr(s)
register char *s;
{
	fflush(stdout);
	reads(s, stdin);
}

writefile(p)
TREEPTR p;
{
	fputs(p->string, strout);
	fputc('\n', strout);
	if(p->yes == 0 || p->no == 0)
		fputc(leaf, strout);
	else
	{	/* branch */
		fputc(branch, strout);
		writefile(p->yes);
		writefile(p->no);
	}
}

readfile(p)
TREEPTR p;
{
	register char mark;

	reads(p->string, strin);
	mark = getc(strin);
	if(mark == branch)
	{		/* the string was a question */
		readfile(p->yes = newentry(""));
		readfile(p->no = newentry(""));
	}
	else
	{		/* the string was an animal */
		p->yes = p->no = NULL;
		ans++;
	}
}

printn(num)
register int num;
{
	register int temp;

	temp = num / 10;
	if(temp)
		printn(temp);
	temp = num % 10 + '0';
	putchar(temp);
}

reads(s, strin)
register char *s;
register FILE *strin;
{
	while((*s++ = getc(strin)) != '\n');
	*--s = 0;
}
