/*
 *	who [-[c][d][f][l]] [ [wtmp] | [am i] ]
 * 
 *
 *	oct  77		piers lauder
 *			new wtmp/utmp formats
 *	feb  78		piers lauder
 *			ausam
 *	apr  79		davec
 *			C flag
 *	june 79		michael coorey
 *			rewritten, output reformatted
 *	april 81	ian grigg
 *			output reformatted, rubbish removed
 *
 *
 *
 *	lists names and details of unix users
 *	flags	d	initial directory
 *		f	firstname
 *		l	lastname
 *		c	class
 *
 *	usually accesses files 	/etc/utmp
 *			    or	/usr/adm/wtmp
 *
 *
 *
 *
 *		output format:
 *
 *	type	name		ttyid	time		newtime
 *				newuid
 *	1-8	9-16	17-24	25-32	33-44	45-48	49-60
 *	( who on default file is left-shifted 8 chars (does not include type or uid) )
*/


#include	<local-system>		/* system paramters */
#include	<param.h>		/* system parameters */
#include	<stat.h>		/* format for "fstat" */
#include	<utmp.h>		/* utmp/wtmp formats */
#include	<wtmp.h>		/* utmp/wtmp formats */
#include	<passwd.h>		/* user details on passwd file */
#include	<class.h>		/* user class info */
#include	<stdio.h>		/* standard i/o */


union
{
	struct	utmp	u[BSIZE/UTMPSIZ];	/* buffer for utmp records */
	struct	uwtmp	w[BSIZE/UWTMPSIZ];	/* buffer for wtmp records */
}
	buf;

char		utmpf[]		= UTMPF;

struct
{
	char	d,f,l,c,locking,yes;
}
	flags;
struct pwent		pe;		/* password entry for user */
short			pwentry;	/* true if there exists a pwent for current user */
char			pbuf[SSIZ];	/* strings from password entry */
char			out[BUFSIZ];	/* buffered output */




main(argc,argv)
int argc;
char *argv[];
{
	dev_t		tty;		/* users tty */
	char		*ifile;		/* input file name */
	register	n, fin;

	setbuf(stdout, out);

	/* set flag arguments */

	flags.yes = 0;
	pe.pw_limits.l_uid = -1;

	while ( argc > 1 && argv[1][0] == '-' )
	{
		register	c;

		while ( c = *++(argv[1]) ) 
		{
			switch( c )
			{
			case 'd':
				flags.d++;
				break;
			case 'f':
				flags.f++;
				break;
			case 'l':
				flags.l++;
				break;
			case 'c':
				flags.c++;
				break;
			default:
				fprintf(stderr, "Usage: who [-cdfl] [utmp | wtmp]\n");
				exit(1);
			}
			flags.yes++;
		}
		argc--;
		argv++;
	}

	/* set and open input file */

	if ( argc == 2 )
		ifile = argv[1];
	else
		ifile = utmpf;

	if ( (fin = open(ifile, 0)) == SYSERROR )
	{
		perror(ifile);
		exit(1);
	}

	if ( argc != 2 )	/* then use utmp */
	{
		/* set user tty */

		if (argc==3)
		{
			struct stat	sbuf;

			fstat( 0, &sbuf );
			tty = sbuf.st_rdev;
		}

		while ( (n = read( fin, (char *)buf.u, sizeof buf.u )) > 0 )
		{
			register struct utmp	*p;

			for ( p = buf.u ; (n -= UTMPSIZ) >= 0 ; p++ )
			{
				if ( p->ut_line[0] == 0 || (argc == 3 && tty != p->ut_ttyid) )
					continue;

				putname( p->ut_name, p->ut_uid );
				/* the 10 and 8 are "incompatible" with std Unixs LINESIZ == 16 */
				printf( "%-10.8s %.12s", p->ut_line, ctime(p->ut_time)+4 );
				putopt();
				if ( argc == 3 )
					exit(0);
			}
		}
	}
	else
	{
		{
			struct stat	sbuf;

			fstat( fin, &sbuf );

			switch ( sbuf.st_mode & S_IFMT )
			{
			 case S_IFLOK:
			 case S_IFALK:
				flags.locking++;
			}
		}

		pe.pw_limits.l_uid = -1;	/* unlikely value */

		/* step thru wtmp file */

		while( (n=read(fin,(char *)buf.w,sizeof buf.w)) > 0 )
		{
			register struct uwtmp	*p;

			if ( flags.locking )
				if ( unlock() == SYSERROR )
				{
					fprintf(stderr, "unlock - ");
					perror( ifile );
					exit(1);
				}

			/* step through buffer */

			for( p = buf.w ; (n -= UWTMPSIZ)>=0 ; p++ )
			{
				switch( p->uw_type )
				{
				case U_TYPE:	/* log on record */
				case O_TYPE:	/* log off record */

					/* print type */

					if ( p->uw_type == U_TYPE )
						printf( "logon\t" );
					else
						printf( "logoff\t" );
					putname ( "", p->uw_uid );


					/* print tty time */

					printf("\t%c%c\t%.15s",
						p->uw_ttyid[0],
						p->uw_ttyid[1],
						ctime(p->uw_logintime)+4);

					putopt();
					break;

				case W_TYPE:	/* async process */
					printf( "async\t" );
					putname( "", ((struct wtmp *)p)->w_uid );
					printf( "\t\t%.15s\n",
						ctime(((struct wtmp *)p)->w_finishtime)+4 );
					break;

				case SU_TYPE: /* super user */
					printf( "SUPER\t" );
					putname( "", ((struct sutmp *)p)->su_olduid);
					printf( " -> " );
					putname( "", ((struct sutmp *)p)->su_newuid);
					printf( "%.15s\n",
						ctime(((struct sutmp *)p)->su_usetime)+4 );
					break;

				case D_TYPE:	/* date change */
					printf( "DATE\t\t\t\t\t%.15s",
						ctime(((struct dtmp *)p)->d_oldtime)+4 );
					printf( " to %.15s\n",
						ctime(((struct dtmp *)p)->d_newtime)+4 );
					break;

				case T_TYPE:	/* system shutdown */
					printf( "SHUTDOWN\t\t\t\t%.15s\n",
						ctime(((struct ttmp *)p)->t_downtime)+4 );
					break;

				case S_TYPE:	/* system boot */
					printf( "BOOT\t\t\t\t\t%.15s\n",
						ctime(((struct stmp *)p)->s_boottime)+4 );
					break;

				default:
					fprintf(stderr, "Bad wtmp\n");
					exit(1);
				}
			}

			if ( flags.locking )
			{
				pwclose();	/* passwd file maybe */
				if ( readlock( fin ) == SYSERROR )
				{
					fprintf(stderr, "Lock - ");
					perror( ifile );
					exit(1);
				}
			}
		}
	}

	/* check for error */

	if( n == SYSERROR )
	{
		perror(ifile);
		exit(1);
	}

	if( argc==3 )
	{
		/*  - who am i -  failed */

		printf( "nobody\t\tbad utmp\n" );
		exit(1);
	}

	exit(0);
}





#define	NAMLEN	12	/* field width for name : was 15 */
#define	NAMCUT	10	/* where we truncate the name */

/*
 *	putname - if name available, print it, else get it first from passwd file
*/

putname( name, uid )
	register char	*name;
	uid_t		uid;
{
	if( !flags.yes && name[0] )
		/* no options and name in utmp */
		printf("%-*.*s", NAMLEN, NAMCUT, name);
	else
	{
		/* get name from passwd file */

		if(pe.pw_limits.l_uid != uid)
		{
			pe.pw_limits.l_uid = uid;
			pwentry = (getpwlog(&pe,pbuf,SSIZ) >0);
		}
		if(pwentry)
#ifdef	FROTH
			printf("%-*.*s", NAMLEN, NAMCUT, pe.pw_strings[LNAME]);
#else
			printf("%-*.*s", NAMLEN, NAMCUT, name[0] ? name : pe.pw_strings[LNAME]);
#endif
		else
			printf( "??? %-*d", NAMLEN, uid);
	}
}



/*
 *	putopt - if options requested, print them
*/

putopt()
{
	if( flags.yes && pwentry )
	{
		if( flags.f || flags.l || flags.d || flags.c )
		{
			putchar( '\t' );
			if( flags.f )
				printf( " %s",pe.pw_strings[FIRSTNAME] );
			if( flags.l )
				printf( " %s",pe.pw_strings[LASTNAME] );
			if( flags.d )
				printf( " %s",pe.pw_strings[DIRPATH] );
			if( flags.c )
			{
				/* print class name */

				register	i;
				register char	*cp;

				for ( i = 0 ; i < NCLASS && (cp = classes[i].c_name) ; i++ )
					if( pe.pw_limits.l_cmask[classes[i].c_index] & classes[i].c_mask )
						printf( " %s", cp );
			}
			putchar( '\n' );
		}
	}
	else
		putchar( '\n' );
}
