h05514
s 00001/00001/00291
d D 1.3 81/03/19 23:42:38 root 3 2
c minor correction (Ian Grigg)
e
s 00049/00048/00243
d D 1.2 81/01/10 14:45:07 root 2 1
c original from elecvax 9/1/81, modified to accept standard input
c and to be less verbose.
e
s 00291/00000/00000
d D 1.1 81/01/10 14:19:29 root 1 0
e
u
U
t
T
I 1
/*
 *	Huffman decompressor  (new files to standard output)
 *	Adapted April 1979, from program by T.G. Szymanski, March 1978.
 *	Usage:	pcat filename...
I 2
 *	modified to accept standard input. Peter Ivanov UNSW 9/1/81
E 2
 */

#include <stdio.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>

jmp_buf env;
D 2
char	*argv0, *argvk;
short	errorm;
E 2
I 2
char	*argvk;
E 2

#define	BLKSIZE	512
#define NAMELEN 80
#define	SUF0	'.'
#define	SUF1	'z'
D 2
#define US 037
#define RS 036
E 2
I 2
#define US 037	/* indicates old style packing */
#define RS 036	/* and this is new style packing */
E 2
#ifdef pdp11
#define COMPATABILITY
#endif

/* variables associated with i/o */
char	filename [NAMELEN+2];
short	infile;
D 2
short	outfile;
E 2
I 2
short	outfile = 1;
E 2
short	inleft;
char	*inp;
char	*outp;
char	inbuff [BLKSIZE];
char	outbuff [BLKSIZE];

/* the dictionary */
long	origsize;
short	maxlev;
short	intnodes [25];
char	*tree [25];
char	characters [256];
char	*eof;

/* read in the dictionary portion and build decoding structures */
/* return 1 if successful, 0 otherwise */
getdict ()
{
	register int c, i, nchildren;
	/*
	 * check two-byte header
	 * get size of original file,
	 * get number of levels in maxlev,
	 * get number of leaves on level i in intnodes[i],
	 * set tree[i] to point to leaves for level i
	 */
	eof = &characters[0];
	inbuff[6] = 25;
	inleft = read(infile, &inbuff[0], BLKSIZE);
	if (inleft < 0) {
D 2
		eprintf (".z: read error");
E 2
I 2
		pcaterr (": read error");
E 2
		return (0);
	}
	if (inbuff[0] != US) goto goof;
#ifdef COMPATABILITY
	if (inbuff[1] == US) { /* oldstyle packing */
		if (setjmp(env)) return (0);
		expand();
		return (1);
	}
#endif
	if (inbuff[1] != RS) goto goof;

	inp = &inbuff[2];
	origsize = 0;
	for (i=0; i<4; i++) {
		origsize = origsize*256 + ((*inp++) & 0377);
	}
	maxlev = *inp++ & 0377;
	if (maxlev > 24) {
D 2
goof:		eprintf (".z: not in packed format");
E 2
I 2
goof:		pcaterr (": not in packed format");
E 2
		return (0);
	}
	for (i=1; i<=maxlev; i++)
		intnodes[i] = *inp++ & 0377;
	for (i=1; i<=maxlev; i++) {
		tree[i] = eof;
		for (c=intnodes[i]; c>0; c--) {
			if (eof >= &characters[255])
				goto goof;
			*eof++ = *inp++;
		}
	}
	*eof++ = *inp++;
	intnodes[maxlev] += 2;
	inleft -= inp-&inbuff[0];
	if (inleft < 0)
		goto goof;

	/*
	 * convert intnodes[i] to be number of
	 * internal nodes possessed by level i
	 */
	nchildren = 0;
	for (i=maxlev; i>=1; i--) {
		c = intnodes[i];
		intnodes[i] = nchildren /= 2;
		nchildren += c;
	}
	return (decode());
}

/* unpack the file */
/* return 1 if successful, 0 otherwise */
decode ()
{
	register int bitsleft, c, i;
	int j, lev;
	char *p;
	outp = &outbuff[0];
	lev = 1;
	i = 0;
	while (1) {
		if (inleft <= 0) {
			inleft = read(infile, inp = &inbuff[0], BLKSIZE);
			if (inleft < 0) {
D 2
				eprintf (".z: read error");
E 2
I 2
				pcaterr (": read error");
E 2
				return (0);
			}
		}
		if (--inleft < 0) {
D 2
uggh:			eprintf (".z: unpacking error");
E 2
I 2
uggh:			pcaterr (": unpacking error");
E 2
			return (0);
		}
		c = *inp++;
		bitsleft = 8;
		while (--bitsleft >= 0) {
			i *= 2;
			if (c & 0200)
				i++;
			c <<= 1;
			if ((j = i-intnodes[lev]) >= 0) {
				p = &tree[lev][j];
				if (p == eof) {
					c = outp-&outbuff[0];
					if (write(outfile, outbuff, c) != c) {
D 2
wrerr:						eprintf (": write error");
E 2
I 2
wrerr:						pcaterr (": write error");
E 2
						return (0);
					}
					origsize -= c;
					if (origsize != 0) goto uggh;
					return(1);
				}
				*outp++ = *p;
				if (outp == &outbuff[BLKSIZE]) {
					if (write(outfile, outp = &outbuff[0], BLKSIZE) != BLKSIZE)
						goto wrerr;
					origsize -= BLKSIZE;
				}
				lev = 1;
				i = 0;
			} else
				lev++;
		}
	}
}


main(argc, argv)
short argc; char *argv[];
{       register int i, k;
	int sep;
	register char *cp;
	int fcount = 0; /* failure count */

D 2
	argv0 = argv[0];
	for (k = 1; k<argc; k++)
E 2
I 2
	if( argc == 1)
E 2
	{
D 2
		errorm = 0;
		sep = -1;  cp = filename;
		for (i=0; i < (NAMELEN-3) && (*cp = argv[k][i]); i++)
			if (*cp++ == '/') sep = i;
		if (cp[-1]==SUF1 && cp[-2]==SUF0)
		{       argv[k][i-2] = '\0'; /* Remove suffix and try again */
			k--;
			continue;
		}

		fcount++;  /* expect the worst */
		argvk = argv[k];
		if (i >= (NAMELEN-3) || (i-sep) > 13)
		{       eprintf (": file name too long");
			goto done;
E 2
I 2
		infile = 0;
		argvk = "standard-input";
		getdict();
	}
	else
	{
		for (k = 1; k<argc; k++)
		{
			sep = -1;  cp = filename;
			argvk = argv[k];
			for (i=0; i < (NAMELEN-3) && (*cp = argv[k][i]); i++)
				if (*cp++ == '/') sep = i;
			if (cp[-1]==SUF1 && cp[-2]==SUF0)
			{       argv[k][i-2] = '\0'; /* Remove suffix and try again */
				k--;
				continue;
			}
	
			fcount++;  /* expect the worst */
			if (i >= (NAMELEN-3) || (i-sep) > 13)
			{       pcaterr (": file name too long");
				continue;
			}
			*cp++ = SUF0;  *cp++ = SUF1;  *cp = '\0';
			if ((infile = open(filename, 0)) == -1)
			{       pcaterr (": cannot open");
				continue;
			}
	
	
			if (getdict()) {		/* unpack */
				fcount--; 	/* success after all */
			}
			close(infile);
E 2
		}
D 2
		*cp++ = SUF0;  *cp++ = SUF1;  *cp = '\0';
		if ((infile = open(filename, 0)) == -1)
		{       eprintf (".z: cannot open");
			goto done;
		}

		outfile = 1; 	/* standard output */

		if (getdict()) {		/* unpack */
			fcount--; 	/* success after all */
		}
		close(infile);
done:		if (errorm) fprintf (stderr, "\n");
E 2
	}
	return (fcount);
}

D 2
eprintf(s) char *s; {
	if (!errorm) {
		errorm = 1;
		fprintf (stderr, "%s: %s", argv0, argvk);
	}
	fprintf (stderr, s);
E 2
I 2
pcaterr(s) char *s; {
D 3
	fprintf (stderr, "%s: %s%s\n", "pcat", argvk, s);
E 3
I 3
	fprintf (stderr, "%s%s\n", argvk, s);
E 3
E 2
}

#ifdef COMPATABILITY
/* this code is for unpacking files, which were packed using the previous algorithm */
int Tree [1024];
expand()
{       register int tp, bit, word;
	int keysize, i, *t;

	outp = outbuff;
	inp = &inbuff[2];
	inleft -= 2;
	origsize = ((long int ) (unsigned) getwd())*256*256;
	origsize += (unsigned) getwd();
	t = Tree;
	for ( keysize=getwd(); keysize--; )
	{       if ((i = getch()) == 0377)
			*t++ = getwd();
		else
			*t++ = i & 0377;
	}

	bit = tp = 0;
	for (;;)
	{       if (bit <= 0)
		{       word = getwd();
			bit = 16;
		}
		tp += Tree[tp + (word<0)];
		word <<= 1;  bit--;
		if (Tree[tp] == 0)
		{       putch(Tree[tp+1]);
			tp = 0;
			if ((origsize -= 1) == 0) {
				write (outfile, outbuff, outp-&outbuff[0]);
				return;
			}
		}
	}
}

getch() {
	if (inleft <= 0) {
		inleft = read (infile, inp=inbuff, BLKSIZE);
		if (inleft < 0) {
D 2
			eprintf (".z: read error");
E 2
I 2
			pcaterr (": read error");
E 2
			longjmp (env, 1);
		}
	}
	inleft--;
	return (*inp++ & 0377);
}

getwd() {
	register char c;
	register d;
	c = getch();
	d = getch();
	d <<= 8;
	d |= (c & 0377);
	return (d);
}

putch(c) char c; {
	register int n;
	*outp++ = c;
	if (outp == &outbuff[BLKSIZE]) {
		n = write (outfile, outp=outbuff, BLKSIZE);
		if (n < BLKSIZE) {
D 2
			eprintf (": write error");
E 2
I 2
			pcaterr (": write error");
E 2
			longjmp (env, 2);
		}
	}
}
#endif
E 1
