/*
 *	Program to assist in determining the magic interleaving number.
 *	NOTE: it times itself by reading locations 54-56 which
 *	contain the current clock-tick count since boot.
 *	Also: this program is not particularly accurate -
 *	it should be used to obtain a rough idea only.
 */

#include	<local-system>		/* define HZ */

#define	NTRK	22		/* sectors per track */
char *dev "/dev/rhp14";		/* typical dev - opened for read only */


char usage[] "Usage: intlv hi-intlv-num [raw-dev]\n";

main(c, v)
char *v[];
{
	register blk, intlv, fd;
	int n, hintlv;
	long oldt, newt;
	long fred[4];
	char buf[512];
	long times();

	if (c == 3)
		dev = v[2];
	else if (c != 2)
	{
		printf(usage);
		exit(1);
	}
	if ((fd = open(dev, 0)) < 0)
	{
		perror(dev);
		exit(1);
	}
	hintlv = atoi(v[1]);
	nice(-50);
	for (intlv = 1; intlv < hintlv; intlv++)
	{
		oldt = times(fred);
		blk = 0;
		for (n = 0; n < 1000; n++)
		{
			lseek(fd, (long)blk * 512L, 0);
			read(fd, buf, 512);
			blk = (blk + intlv) % NTRK;
		}
		newt = times(fred);
		printf("interleaved %3d -> %5ld.%2ld sec\n",
			intlv, (newt-oldt)/HZ, ((newt-oldt)%HZ)*2);
	}
	exit(0);
}
